/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.folhaportal.service;

import br.com.elotech.core.utils.EloPage;
import br.com.elotech.folhapagamento.client.IntegracaoFolhaPortalTransparenciaClient;
import br.com.elotech.folhapagamento.client.domain.CargoReduzidoDTO;
import br.com.elotech.folhapagamento.client.domain.MatrizSalarialDTO;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaCargoDTO;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaCargoViewDTO;
import br.com.elotech.folhapagamento.client.domain.enums.CargoTipo;
import br.com.elotech.portaltransparencia.aiseportal.domain.Cargo;
import br.com.elotech.portaltransparencia.aiseportal.domain.GrupoOcupacional;
import br.com.elotech.portaltransparencia.aiseportal.domain.GrupoOcupacionalNivel;
import br.com.elotech.portaltransparencia.aiseportal.domain.QuadroSalarial;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.CargoFaixaDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.CargoParamsConverter;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.CargoParams;
import br.com.elotech.portaltransparencia.aiseportal.service.CargoService;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class CargoServiceOxy
implements CargoService {
    private final IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient;

    public List<Cargo> findCargo(CargoParams params) {
        return new ArrayList<Cargo>();
    }

    public List<QuadroSalarial> findQuadroSalarial(CargoParams params) {
        return new ArrayList<QuadroSalarial>();
    }

    public List<GrupoOcupacional> findGrupoOcupacional(CargoParams params) {
        return new ArrayList<GrupoOcupacional>();
    }

    public List<GrupoOcupacionalNivel> findGrupoOcupacionalNivel(CargoParams params) {
        return new ArrayList<GrupoOcupacionalNivel>();
    }

    public Page<CargoFaixaDTO> findCargos(CargoParams params, Pageable pageable) {
        return new PageImpl(new ArrayList(), pageable, 0L);
    }

    public List<CargoFaixaDTO> findFaixas(CargoParams params) {
        return new ArrayList<CargoFaixaDTO>();
    }

    public Page<PortalTransparenciaCargoDTO> findCargosOxy(CargoParams params, Pageable pageable) {
        EloPage cargos = this.integracaoFolhaPortalTransparenciaClient.findAllCargos(CargoParamsConverter.toFiltroDTO((CargoParams)params), pageable);
        return new PageImpl(cargos.getContent(), pageable, cargos.getTotalElements());
    }

    public List<PortalTransparenciaCargoViewDTO> getMatrizVigente(CargoParams params) {
        return this.integracaoFolhaPortalTransparenciaClient.getCargoMatrizVigente(CargoParamsConverter.toFiltroDTO((CargoParams)params));
    }

    public List<CargoTipo> getTipoCargo() {
        return this.integracaoFolhaPortalTransparenciaClient.findCargoTipo();
    }

    public List<String> getVigenciasMatrizSalarial(Long matrizId) {
        return this.integracaoFolhaPortalTransparenciaClient.getAllVigenciasMatriz(matrizId);
    }

    public List<CargoReduzidoDTO> getCargosReduzido() {
        return this.integracaoFolhaPortalTransparenciaClient.getCargosReduzido();
    }

    public List<MatrizSalarialDTO> getAllMatrizesByEntidade(Long entidade) {
        return this.integracaoFolhaPortalTransparenciaClient.getAllMatrizesByEntidade(entidade);
    }

    @Generated
    public CargoServiceOxy(IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient) {
        this.integracaoFolhaPortalTransparenciaClient = integracaoFolhaPortalTransparenciaClient;
    }
}

