/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.portaltransparencia.contabportal.domain.TotalAcesso;
import br.com.elotech.portaltransparencia.contabportal.repository.TotalAcessoRepository;
import br.com.elotech.portaltransparencia.contabportal.service.TotalAcessoLockService;
import java.time.LocalDate;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TotalAcessoService {
    private final TotalAcessoRepository totalAcessoRepository;
    private final TotalAcessoLockService totalAcessoLockService;

    @Transactional
    public TotalAcesso getTotalAcesso() {
        this.totalAcessoLockService.lockTable();
        TotalAcesso totalAcesso = this.totalAcessoRepository.findByData(LocalDate.now()).orElseGet(() -> {
            TotalAcesso newTotalAcesso = new TotalAcesso();
            newTotalAcesso.setId(this.totalAcessoRepository.getNextId());
            return newTotalAcesso;
        });
        totalAcesso.incrementa();
        return (TotalAcesso)this.totalAcessoRepository.save((Object)totalAcesso);
    }

    @Transactional
    public TotalAcesso calculateTotalAcessoDiarioOficial() {
        this.totalAcessoLockService.lockTable();
        TotalAcesso totalAcesso = this.totalAcessoRepository.findByData(LocalDate.now()).orElseGet(() -> {
            TotalAcesso newTotalAcesso = new TotalAcesso();
            newTotalAcesso.setId(this.totalAcessoRepository.getNextId());
            return newTotalAcesso;
        });
        totalAcesso.incrementaDiarioOficial();
        return (TotalAcesso)this.totalAcessoRepository.save((Object)totalAcesso);
    }

    @Generated
    public TotalAcessoService(TotalAcessoRepository totalAcessoRepository, TotalAcessoLockService totalAcessoLockService) {
        this.totalAcessoRepository = totalAcessoRepository;
        this.totalAcessoLockService = totalAcessoLockService;
    }
}

