/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.portaltransparencia.contabportal.domain.EmpresaTerceirizadaFuncionario;
import br.com.elotech.portaltransparencia.contabportal.repository.EmpresaTerceirizadaFuncionarioRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.EmpresaTerceirizadaFuncionarioParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class EmpresaTerceirizadaFuncionarioService {
    @Autowired
    private final EmpresaTerceirizadaFuncionarioRepository empresaTerceirizadaRepository;

    public EmpresaTerceirizadaFuncionarioService(EmpresaTerceirizadaFuncionarioRepository empresaTerceirizadaRepository) {
        this.empresaTerceirizadaRepository = empresaTerceirizadaRepository;
    }

    public Page<EmpresaTerceirizadaFuncionario> findEmpresaTerceirizada(Long entidade, Long exercicio, Pageable pageable, EmpresaTerceirizadaFuncionarioParams params) {
        StringBuilder sql = new StringBuilder();
        sql.append(" AND et.exercicio = ").append(exercicio).append(" ");
        this.appendConditionCpfCnpj(sql, "f.cnpj", (Object)params.getCnpj());
        this.appendCondition(sql, "f.nome", (Object)params.getEmpresa());
        this.appendCondition(sql, "e.nome", (Object)params.getTrabalhador());
        this.appendCondition(sql, "e.cargo", (Object)params.getCargo());
        this.appendCondition(sql, "e.lotacao", (Object)params.getLotacao());
        return this.empresaTerceirizadaRepository.findByEntidadeAndExercicio(pageable, sql.toString(), entidade, params);
    }

    private void appendCondition(StringBuilder sql, String columnName, Object value) {
        if (value != null) {
            sql.append(" AND ${db.contabilidade.schema}.tiraacento(LOWER(").append(columnName).append(")) LIKE ${db.contabilidade.schema}.tiraacento(LOWER('%").append(value).append("%')) ");
        }
    }

    private void appendConditionCpfCnpj(StringBuilder sql, String columnName, Object value) {
        if (value != null) {
            sql.append(" AND ${db.contabilidade.schema}.tiraacento(LOWER(").append(columnName).append(")) LIKE ${db.contabilidade.schema}.tiraacento(LOWER('").append(value).append("%')) ");
        }
    }
}

