/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.core.utils.EloPage;
import br.com.elotech.orcamento.client.AudienciaPublicaFeignClient;
import br.com.elotech.orcamento.client.dto.AudienciaPublicaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.AudienciasPublicasDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.AudienciasPublicasParams;
import br.com.elotech.portaltransparencia.contabportal.service.AudienciasPublicasService;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class AudienciasPublicasOxyService
implements AudienciasPublicasService {
    private final AudienciaPublicaFeignClient feignClient;

    public Page<AudienciasPublicasDTO> findAudienciasPublicas(Pageable pageable, AudienciasPublicasParams params) {
        String entidade = Optional.ofNullable(params.getEntidade()).map(Object::toString).orElse("");
        String exercicio = Optional.ofNullable(params.getExercicio()).map(Object::toString).orElse("");
        EloPage audienciasPublicas = this.feignClient.findAll(entidade, exercicio, params.toFiltroOxy(), pageable);
        return new PageImpl(audienciasPublicas.getContent().stream().map(AudienciasPublicasDTO::of).collect(Collectors.toList()), pageable, audienciasPublicas.getTotalElements());
    }

    public AudienciasPublicasDTO findAudienciasPublicasDetalhes(AudienciasPublicasParams params) {
        AudienciaPublicaDTO audienciaPublicaDTO = this.feignClient.findByIdPortal(params.getId());
        return AudienciasPublicasDTO.of((AudienciaPublicaDTO)audienciaPublicaDTO);
    }

    public List<ArquivoPessoalDTO> findAudienciasPublicasArquivos(AudienciasPublicasParams params) {
        return Optional.ofNullable(this.feignClient.findByIdPortal(params.getId())).map(dto -> dto.getAnexos().stream().map(ArquivoPessoalDTO::of).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public ArquivoDTO findAudienciasPublicasArquivo(Long idAnexo) {
        return Optional.ofNullable(this.feignClient.findAnexoById(idAnexo)).map(ArquivoDTO::ofAudienciaPublicaAnexo).orElse(null);
    }

    @Generated
    public AudienciasPublicasOxyService(AudienciaPublicaFeignClient feignClient) {
        this.feignClient = feignClient;
    }
}

