/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.resource.params;

import br.com.elotech.oxy.adm.compras.client.portal.FindResponsavelParamsDTO;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindResponsavelParams;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class FindResponsavelParams {
    private Long entidade;
    private Long exercicio;
    private String tipoContrato;
    private Long contrato;
    private Long numeroContrato;
    private Long sequencia;
    private Long exercicioContrato;
    private Long exercicioLicitacao;
    private Long numeroLicitacao;
    private Long tipoLicitacao;
    private String inicioVigencia;
    private String fimVigencia;
    private Long idContrato;
    private String rateio;
    private String isCovid;
    private Long tipoAto;
    private String tipo;
    private String gestor;
    private String ocupante;
    private Boolean somenteVigentes;
    private String exportType;

    public String montaWhere() {
        StringBuilder where = new StringBuilder();
        if (Objects.nonNull(this.entidade)) {
            where.append("\n WHERE A.ENTIDADE = :entidade");
        }
        if (Objects.nonNull(this.exercicio)) {
            where.append("\n AND A.EXERCICIO = :exercicio");
        }
        if (Objects.nonNull(this.tipoContrato)) {
            where.append("\n AND B.TIPOCONTRATO :tipoContrato");
        }
        if (Objects.nonNull(this.contrato)) {
            where.append("\n AND A.CONTRATO = :contrato");
        }
        if (Objects.nonNull(this.numeroContrato)) {
            where.append("\n AND B.NUMEROCONTRATO = :numeroContrato");
        }
        if (Objects.nonNull(this.sequencia)) {
            where.append("\n AND A.SEQUENCIA = :sequencia");
        }
        if (Objects.nonNull(this.exercicioContrato)) {
            where.append("\n AND A.EXERCICIO = :exercicioContrato");
        }
        if (Objects.nonNull(this.exercicioLicitacao)) {
            where.append("\n AND B.EXERCICIOLICITACAO = :exercicioLicitacao");
        }
        if (Objects.nonNull(this.numeroLicitacao)) {
            where.append("\n AND B.NUMEROLICITACAO = :numeroLicitacao");
        }
        if (Objects.nonNull(this.tipoLicitacao)) {
            where.append("\n AND B.TIPOLICITACAO = :tipoLicitacao");
        }
        if (Objects.nonNull(this.inicioVigencia)) {
            where.append("\n AND B.VIGENCIA >= :inicioVigencia");
        }
        if (Objects.nonNull(this.fimVigencia)) {
            where.append("\n AND B.VIGENCIA <= :fimVigencia");
        }
        if (Objects.nonNull(this.idContrato)) {
            where.append("\n AND B.IDCONTRATO = :idContrato");
        }
        if (Objects.nonNull(this.rateio)) {
            where.append("\n AND B.RATEIO = :rateio");
        }
        if (Objects.nonNull(this.isCovid)) {
            where.append("\n AND B.ISCOVID = :isCovid");
        }
        if (Objects.nonNull(this.tipoAto)) {
            where.append("\n AND B.TIPOATO = :tipoAto");
        }
        if (Objects.nonNull(this.tipo)) {
            where.append("\n AND A.TIPO = :tipo");
        }
        if (Objects.nonNull(this.gestor)) {
            where.append("\n AND A.GESTOR = :gestor");
        }
        if (Objects.nonNull(this.ocupante)) {
            where.append(SqlUtils.andLike((String)"${db.compras.schema}", (String)"C.OCUPANTE", (String)this.ocupante));
        }
        if (Boolean.TRUE.equals(this.somenteVigentes)) {
            where.append("\n AND B.SITUACAO = :somenteVigentes");
        }
        return where.toString();
    }

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addEntidade(params);
        this.addExercicios(params);
        this.addTipoContrato(params);
        this.addContrato(params);
        this.addNumeroContrato(params);
        this.addSequencia(params);
        this.addTipoLicitacao(params);
        this.addNumeroLicitacao(params);
        this.addInicioVigencia(params);
        this.addFimVigencia(params);
        this.addIdContrato(params);
        this.addRateio(params);
        this.addTipoAto(params);
        this.addOcupante(params);
        this.addSomenteVigentes(params);
        return params;
    }

    private void addEntidade(MapSqlParameterSource params) {
        if (Objects.nonNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
    }

    private void addInicioVigencia(MapSqlParameterSource params) {
        if (Objects.nonNull(this.inicioVigencia)) {
            params.addValue("inicioVigencia", (Object)this.inicioVigencia, 91);
        }
    }

    private void addFimVigencia(MapSqlParameterSource params) {
        if (Objects.nonNull(this.fimVigencia)) {
            params.addValue("fimVigencia", (Object)this.fimVigencia, 91);
        }
    }

    private void addExercicios(MapSqlParameterSource params) {
        if (Objects.nonNull(this.exercicio)) {
            params.addValue("exercicio", (Object)this.exercicio, 2);
        }
        if (Objects.nonNull(this.exercicioLicitacao)) {
            params.addValue("exercicioLicitacao", (Object)this.exercicioLicitacao, 2);
        }
        if (Objects.nonNull(this.exercicioContrato)) {
            params.addValue("exercicioContrato", (Object)this.exercicioContrato, 2);
        }
    }

    private void addTipoContrato(MapSqlParameterSource params) {
        if (Objects.nonNull(this.tipoContrato)) {
            params.addValue("tipoContrato", (Object)this.tipoContrato, 12);
        }
    }

    private void addContrato(MapSqlParameterSource params) {
        params.addValue("contrato", (Object)this.contrato, 2);
    }

    private void addNumeroContrato(MapSqlParameterSource params) {
        params.addValue("numeroContrato", (Object)this.numeroContrato, 2);
    }

    private void addSequencia(MapSqlParameterSource params) {
        params.addValue("sequencia", (Object)this.sequencia, 2);
    }

    private void addTipoLicitacao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.tipoLicitacao)) {
            params.addValue("tipoLicitacao", (Object)this.tipoLicitacao, 2);
        }
    }

    private void addNumeroLicitacao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.numeroLicitacao)) {
            params.addValue("numeroLicitacao", (Object)this.numeroLicitacao, 2);
        }
    }

    private void addIdContrato(MapSqlParameterSource params) {
        if (Objects.nonNull(this.idContrato)) {
            params.addValue("idContrato", (Object)this.idContrato, 2);
        }
    }

    private void addTipoAto(MapSqlParameterSource params) {
        if (Objects.nonNull(this.tipoAto)) {
            params.addValue("tipoAto", (Object)this.tipoAto, 2);
        }
    }

    private void addRateio(MapSqlParameterSource params) {
        if (Objects.nonNull(this.rateio)) {
            params.addValue("rateio", (Object)this.rateio, 12);
        }
    }

    private void addOcupante(MapSqlParameterSource params) {
        if (Objects.nonNull(this.ocupante)) {
            params.addValue("ocupante", (Object)("%" + this.ocupante + "%"), 12);
        }
    }

    private void addSomenteVigentes(MapSqlParameterSource params) {
        if (Boolean.TRUE.equals(this.somenteVigentes)) {
            params.addValue("somenteVigentes", (Object)"Vigente", 12);
        }
    }

    private String tryLongToStr(Long value) {
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public FindResponsavelParamsDTO toComprasOxyParams() {
        FindResponsavelParamsDTO params = new FindResponsavelParamsDTO();
        params.setEntidade(this.entidade);
        params.setExercicio(this.exercicio);
        params.setContrato(this.tryLongToStr(this.contrato));
        params.setNumeroContrato(this.numeroContrato);
        params.setExercicioContrato(this.exercicioContrato);
        params.setInicioVigencia(this.inicioVigencia);
        params.setFimVigencia(this.fimVigencia);
        params.setIdContrato(this.tryLongToStr(this.idContrato));
        params.setTipoAto(this.tipoAto);
        if (this.gestor != null) {
            params.setGestor(Boolean.valueOf(List.of("S", "true", "True", "TRUE", "s").contains(this.gestor)));
        }
        params.setOcupante(this.ocupante);
        params.setSomenteVigentes(this.somenteVigentes);
        return params;
    }

    @Generated
    public static FindResponsavelParamsBuilder builder() {
        return new FindResponsavelParamsBuilder();
    }

    @Generated
    public FindResponsavelParams(Long entidade, Long exercicio, String tipoContrato, Long contrato, Long numeroContrato, Long sequencia, Long exercicioContrato, Long exercicioLicitacao, Long numeroLicitacao, Long tipoLicitacao, String inicioVigencia, String fimVigencia, Long idContrato, String rateio, String isCovid, Long tipoAto, String tipo, String gestor, String ocupante, Boolean somenteVigentes, String exportType) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.tipoContrato = tipoContrato;
        this.contrato = contrato;
        this.numeroContrato = numeroContrato;
        this.sequencia = sequencia;
        this.exercicioContrato = exercicioContrato;
        this.exercicioLicitacao = exercicioLicitacao;
        this.numeroLicitacao = numeroLicitacao;
        this.tipoLicitacao = tipoLicitacao;
        this.inicioVigencia = inicioVigencia;
        this.fimVigencia = fimVigencia;
        this.idContrato = idContrato;
        this.rateio = rateio;
        this.isCovid = isCovid;
        this.tipoAto = tipoAto;
        this.tipo = tipo;
        this.gestor = gestor;
        this.ocupante = ocupante;
        this.somenteVigentes = somenteVigentes;
        this.exportType = exportType;
    }

    @Generated
    public FindResponsavelParams() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getTipoContrato() {
        return this.tipoContrato;
    }

    @Generated
    public Long getContrato() {
        return this.contrato;
    }

    @Generated
    public Long getNumeroContrato() {
        return this.numeroContrato;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public Long getExercicioContrato() {
        return this.exercicioContrato;
    }

    @Generated
    public Long getExercicioLicitacao() {
        return this.exercicioLicitacao;
    }

    @Generated
    public Long getNumeroLicitacao() {
        return this.numeroLicitacao;
    }

    @Generated
    public Long getTipoLicitacao() {
        return this.tipoLicitacao;
    }

    @Generated
    public String getInicioVigencia() {
        return this.inicioVigencia;
    }

    @Generated
    public String getFimVigencia() {
        return this.fimVigencia;
    }

    @Generated
    public Long getIdContrato() {
        return this.idContrato;
    }

    @Generated
    public String getRateio() {
        return this.rateio;
    }

    @Generated
    public String getIsCovid() {
        return this.isCovid;
    }

    @Generated
    public Long getTipoAto() {
        return this.tipoAto;
    }

    @Generated
    public String getTipo() {
        return this.tipo;
    }

    @Generated
    public String getGestor() {
        return this.gestor;
    }

    @Generated
    public String getOcupante() {
        return this.ocupante;
    }

    @Generated
    public Boolean getSomenteVigentes() {
        return this.somenteVigentes;
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoContrato(String tipoContrato) {
        this.tipoContrato = tipoContrato;
    }

    @Generated
    public void setContrato(Long contrato) {
        this.contrato = contrato;
    }

    @Generated
    public void setNumeroContrato(Long numeroContrato) {
        this.numeroContrato = numeroContrato;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setExercicioContrato(Long exercicioContrato) {
        this.exercicioContrato = exercicioContrato;
    }

    @Generated
    public void setExercicioLicitacao(Long exercicioLicitacao) {
        this.exercicioLicitacao = exercicioLicitacao;
    }

    @Generated
    public void setNumeroLicitacao(Long numeroLicitacao) {
        this.numeroLicitacao = numeroLicitacao;
    }

    @Generated
    public void setTipoLicitacao(Long tipoLicitacao) {
        this.tipoLicitacao = tipoLicitacao;
    }

    @Generated
    public void setInicioVigencia(String inicioVigencia) {
        this.inicioVigencia = inicioVigencia;
    }

    @Generated
    public void setFimVigencia(String fimVigencia) {
        this.fimVigencia = fimVigencia;
    }

    @Generated
    public void setIdContrato(Long idContrato) {
        this.idContrato = idContrato;
    }

    @Generated
    public void setRateio(String rateio) {
        this.rateio = rateio;
    }

    @Generated
    public void setIsCovid(String isCovid) {
        this.isCovid = isCovid;
    }

    @Generated
    public void setTipoAto(Long tipoAto) {
        this.tipoAto = tipoAto;
    }

    @Generated
    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setGestor(String gestor) {
        this.gestor = gestor;
    }

    @Generated
    public void setOcupante(String ocupante) {
        this.ocupante = ocupante;
    }

    @Generated
    public void setSomenteVigentes(Boolean somenteVigentes) {
        this.somenteVigentes = somenteVigentes;
    }

    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindResponsavelParams)) {
            return false;
        }
        FindResponsavelParams other = (FindResponsavelParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$contrato = this.getContrato();
        Long other$contrato = other.getContrato();
        if (this$contrato == null ? other$contrato != null : !((Object)this$contrato).equals(other$contrato)) {
            return false;
        }
        Long this$numeroContrato = this.getNumeroContrato();
        Long other$numeroContrato = other.getNumeroContrato();
        if (this$numeroContrato == null ? other$numeroContrato != null : !((Object)this$numeroContrato).equals(other$numeroContrato)) {
            return false;
        }
        Long this$sequencia = this.getSequencia();
        Long other$sequencia = other.getSequencia();
        if (this$sequencia == null ? other$sequencia != null : !((Object)this$sequencia).equals(other$sequencia)) {
            return false;
        }
        Long this$exercicioContrato = this.getExercicioContrato();
        Long other$exercicioContrato = other.getExercicioContrato();
        if (this$exercicioContrato == null ? other$exercicioContrato != null : !((Object)this$exercicioContrato).equals(other$exercicioContrato)) {
            return false;
        }
        Long this$exercicioLicitacao = this.getExercicioLicitacao();
        Long other$exercicioLicitacao = other.getExercicioLicitacao();
        if (this$exercicioLicitacao == null ? other$exercicioLicitacao != null : !((Object)this$exercicioLicitacao).equals(other$exercicioLicitacao)) {
            return false;
        }
        Long this$numeroLicitacao = this.getNumeroLicitacao();
        Long other$numeroLicitacao = other.getNumeroLicitacao();
        if (this$numeroLicitacao == null ? other$numeroLicitacao != null : !((Object)this$numeroLicitacao).equals(other$numeroLicitacao)) {
            return false;
        }
        Long this$tipoLicitacao = this.getTipoLicitacao();
        Long other$tipoLicitacao = other.getTipoLicitacao();
        if (this$tipoLicitacao == null ? other$tipoLicitacao != null : !((Object)this$tipoLicitacao).equals(other$tipoLicitacao)) {
            return false;
        }
        Long this$idContrato = this.getIdContrato();
        Long other$idContrato = other.getIdContrato();
        if (this$idContrato == null ? other$idContrato != null : !((Object)this$idContrato).equals(other$idContrato)) {
            return false;
        }
        Long this$tipoAto = this.getTipoAto();
        Long other$tipoAto = other.getTipoAto();
        if (this$tipoAto == null ? other$tipoAto != null : !((Object)this$tipoAto).equals(other$tipoAto)) {
            return false;
        }
        Boolean this$somenteVigentes = this.getSomenteVigentes();
        Boolean other$somenteVigentes = other.getSomenteVigentes();
        if (this$somenteVigentes == null ? other$somenteVigentes != null : !((Object)this$somenteVigentes).equals(other$somenteVigentes)) {
            return false;
        }
        String this$tipoContrato = this.getTipoContrato();
        String other$tipoContrato = other.getTipoContrato();
        if (this$tipoContrato == null ? other$tipoContrato != null : !this$tipoContrato.equals(other$tipoContrato)) {
            return false;
        }
        String this$inicioVigencia = this.getInicioVigencia();
        String other$inicioVigencia = other.getInicioVigencia();
        if (this$inicioVigencia == null ? other$inicioVigencia != null : !this$inicioVigencia.equals(other$inicioVigencia)) {
            return false;
        }
        String this$fimVigencia = this.getFimVigencia();
        String other$fimVigencia = other.getFimVigencia();
        if (this$fimVigencia == null ? other$fimVigencia != null : !this$fimVigencia.equals(other$fimVigencia)) {
            return false;
        }
        String this$rateio = this.getRateio();
        String other$rateio = other.getRateio();
        if (this$rateio == null ? other$rateio != null : !this$rateio.equals(other$rateio)) {
            return false;
        }
        String this$isCovid = this.getIsCovid();
        String other$isCovid = other.getIsCovid();
        if (this$isCovid == null ? other$isCovid != null : !this$isCovid.equals(other$isCovid)) {
            return false;
        }
        String this$tipo = this.getTipo();
        String other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        String this$gestor = this.getGestor();
        String other$gestor = other.getGestor();
        if (this$gestor == null ? other$gestor != null : !this$gestor.equals(other$gestor)) {
            return false;
        }
        String this$ocupante = this.getOcupante();
        String other$ocupante = other.getOcupante();
        if (this$ocupante == null ? other$ocupante != null : !this$ocupante.equals(other$ocupante)) {
            return false;
        }
        String this$exportType = this.getExportType();
        String other$exportType = other.getExportType();
        return !(this$exportType == null ? other$exportType != null : !this$exportType.equals(other$exportType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindResponsavelParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $contrato = this.getContrato();
        result = result * 59 + ($contrato == null ? 43 : ((Object)$contrato).hashCode());
        Long $numeroContrato = this.getNumeroContrato();
        result = result * 59 + ($numeroContrato == null ? 43 : ((Object)$numeroContrato).hashCode());
        Long $sequencia = this.getSequencia();
        result = result * 59 + ($sequencia == null ? 43 : ((Object)$sequencia).hashCode());
        Long $exercicioContrato = this.getExercicioContrato();
        result = result * 59 + ($exercicioContrato == null ? 43 : ((Object)$exercicioContrato).hashCode());
        Long $exercicioLicitacao = this.getExercicioLicitacao();
        result = result * 59 + ($exercicioLicitacao == null ? 43 : ((Object)$exercicioLicitacao).hashCode());
        Long $numeroLicitacao = this.getNumeroLicitacao();
        result = result * 59 + ($numeroLicitacao == null ? 43 : ((Object)$numeroLicitacao).hashCode());
        Long $tipoLicitacao = this.getTipoLicitacao();
        result = result * 59 + ($tipoLicitacao == null ? 43 : ((Object)$tipoLicitacao).hashCode());
        Long $idContrato = this.getIdContrato();
        result = result * 59 + ($idContrato == null ? 43 : ((Object)$idContrato).hashCode());
        Long $tipoAto = this.getTipoAto();
        result = result * 59 + ($tipoAto == null ? 43 : ((Object)$tipoAto).hashCode());
        Boolean $somenteVigentes = this.getSomenteVigentes();
        result = result * 59 + ($somenteVigentes == null ? 43 : ((Object)$somenteVigentes).hashCode());
        String $tipoContrato = this.getTipoContrato();
        result = result * 59 + ($tipoContrato == null ? 43 : $tipoContrato.hashCode());
        String $inicioVigencia = this.getInicioVigencia();
        result = result * 59 + ($inicioVigencia == null ? 43 : $inicioVigencia.hashCode());
        String $fimVigencia = this.getFimVigencia();
        result = result * 59 + ($fimVigencia == null ? 43 : $fimVigencia.hashCode());
        String $rateio = this.getRateio();
        result = result * 59 + ($rateio == null ? 43 : $rateio.hashCode());
        String $isCovid = this.getIsCovid();
        result = result * 59 + ($isCovid == null ? 43 : $isCovid.hashCode());
        String $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        String $gestor = this.getGestor();
        result = result * 59 + ($gestor == null ? 43 : $gestor.hashCode());
        String $ocupante = this.getOcupante();
        result = result * 59 + ($ocupante == null ? 43 : $ocupante.hashCode());
        String $exportType = this.getExportType();
        result = result * 59 + ($exportType == null ? 43 : $exportType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FindResponsavelParams(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", tipoContrato=" + this.getTipoContrato() + ", contrato=" + this.getContrato() + ", numeroContrato=" + this.getNumeroContrato() + ", sequencia=" + this.getSequencia() + ", exercicioContrato=" + this.getExercicioContrato() + ", exercicioLicitacao=" + this.getExercicioLicitacao() + ", numeroLicitacao=" + this.getNumeroLicitacao() + ", tipoLicitacao=" + this.getTipoLicitacao() + ", inicioVigencia=" + this.getInicioVigencia() + ", fimVigencia=" + this.getFimVigencia() + ", idContrato=" + this.getIdContrato() + ", rateio=" + this.getRateio() + ", isCovid=" + this.getIsCovid() + ", tipoAto=" + this.getTipoAto() + ", tipo=" + this.getTipo() + ", gestor=" + this.getGestor() + ", ocupante=" + this.getOcupante() + ", somenteVigentes=" + this.getSomenteVigentes() + ", exportType=" + this.getExportType() + ")";
    }
}

