/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource;

import br.com.elotech.portaltransparencia.aiseportal.domain.dto.AfastamentoDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.enums.TipoAfastamento;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AfastamentoParams;
import br.com.elotech.portaltransparencia.aiseportal.service.AfastamentoService;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/afastamentos"})
public class AfastamentoResource {
    private final AfastamentoService afastamentoService;

    @Autowired
    public AfastamentoResource(AfastamentoService afastamentoService) {
        this.afastamentoService = afastamentoService;
    }

    @GetMapping
    public ResponseEntity<Page<AfastamentoDTO>> findAfastamentos(@RequestHeader(value="entidade") Long entidade, @Valid AfastamentoParams params, Pageable pageable) {
        params.setEntidade(entidade);
        return ResponseEntity.ok((Object)this.afastamentoService.findAfastamentos(params, pageable));
    }

    @GetMapping(value={"/tiposAfastamento"})
    public ResponseEntity<TipoAfastamento[]> getSituacoes() {
        return ResponseEntity.ok((Object)TipoAfastamento.values());
    }
}

