SELECT L.entidade,
	   L.exercicio,
	   L.tipolicitacao,
	   L.licitacao,
	   tipoLic.descricao,
	   L.numerolicitacao,
	   L.datapublicacao,
	   CASE WHEN COALESCE(L.datareabertura, L.dataabertura) > L.dataabertura
	        THEN COALESCE(L.datareabertura, L.dataabertura)
	        ELSE L.dataabertura
	   END AS dataabertura,
	   L.horarioabertura,
       L.visualizaportal,
       CASE WHEN L.tipocancelamento = 'A' THEN 'Anulada'
            WHEN L.tipocancelamento = 'D' THEN 'Deserta'
            WHEN L.tipocancelamento = 'F' THEN 'Fracassada'
            WHEN L.tipocancelamento = 'R' THEN 'Revogada'
            WHEN L.tipocancelamento = 'S' THEN 'Suspensa pelo TCE'
            WHEN L.tipocancelamento = 'P' THEN 'Suspensa'
            WHEN (EXISTS( SELECT h.entidade
                                        FROM ${db.compras.schema}.clhomologacao h
                                        JOIN ${db.compras.schema}.clanalisevencedor v
                                          ON h.entidade = v.entidade
            				             AND h.exerciciolicitacao = v.exerciciolicitacao
                                         AND h.tipolicitacao = v.tipolicitacao
                                         AND h.licitacao = v.licitacao
                                         AND h.pessoa = v.pessoa
                                         AND v.vencedor = 'S'
                                       WHERE L.entidade = h.entidade
                                         AND L.exercicio = h.exerciciolicitacao
                                         AND L.tipolicitacao = h.tipolicitacao
                                         AND L.licitacao = h.licitacao)) THEN 'Homologada'
            WHEN (EXISTS(
              SELECT 1
              FROM ${db.compras.schema}.clAcompanhamento ac
              WHERE ac.entidade = l.entidade
                AND ac.exercicioLicitacao = l.exercicio
                AND ac.tipoLicitacao = l.tipoLicitacao
                AND ac.licitacao = l.licitacao
                AND ac.situacao = '09'
              )) THEN 'Adjudicada'
            WHEN L.dataabertura < CURRENT_DATE THEN 'Em Andamento'
            ELSE CASE WHEN L.status = 2 THEN 'Descartada'
                      ELSE 'Aguardando Abertura'
                 END
       END AS tipocancelamento,
       N.DESCRICAO AS natureza,
       L.objeto,
       L.numeroprocessoadm AS protocolo,
       L.anoprocessoadm AS anoprotocolo,
       L.NUMEROPROCESSOADM||'/'||L.ANOPROCESSOADM AS DISPLAYPROCESSOADM,
       L.valormaximo,
	   (SELECT count(*) AS count
          FROM ${db.compras.schema}.clmidiasonline mi
         WHERE L.entidade = mi.entidade
           AND L.exercicio = mi.exercicio
           AND L.tipolicitacao = mi.tipolicitacao
           AND L.licitacao = mi.licitacao) AS qtdemidiasonline,
       L.processoportal,
       L.observacao,
       L.mpcovid19 AS isCovid,
       CASE WHEN (L.tipolicitacao = 9 AND n.tipo = 5)
             AND (COALESCE(( SELECT SUM (PC.QUANTIDADE*PC.VALOR)
                               FROM ${db.compras.schema}.CLANALISEVENCEDOR AV
                              INNER JOIN ${db.compras.schema}.CLPROPOSTACOMERCIAL PC
                                 ON PC.ENTIDADE = AV.ENTIDADE
                                AND PC.EXERCICIOLICITACAO = AV.EXERCICIOLICITACAO
                                AND PC.TIPOLICITACAO = AV.TIPOLICITACAO
                                AND PC.LICITACAO = AV.LICITACAO
                                AND PC.LOTE = AV.LOTE
                                AND PC.ORDEM = AV.ORDEM
                                AND PC.PESSOA = AV.PESSOA
                              INNER JOIN ${db.compras.schema}.CLHOMOLOGACAO H
                                   ON H.ENTIDADE = AV.ENTIDADE
                                  AND H.EXERCICIOLICITACAO = AV.EXERCICIOLICITACAO
                                  AND H.TIPOLICITACAO = AV.TIPOLICITACAO
                                  AND H.LICITACAO = AV.LICITACAO
                                  AND H.PESSOA = AV.PESSOA
                                WHERE L.ENTIDADE = AV.ENTIDADE
                                  AND L.EXERCICIO = AV.EXERCICIOLICITACAO
                                  AND L.TIPOLICITACAO = AV.TIPOLICITACAO
                                  AND L.LICITACAO = AV.LICITACAO
                                  AND AV.VENCEDOR = 'S'), 0)) >=  L.valormaximo THEN L.valormaximo
	         ELSE COALESCE(( SELECT	SUM (PC.QUANTIDADE*PC.VALOR)
	                           FROM ${db.compras.schema}.CLANALISEVENCEDOR AV
                         INNER JOIN ${db.compras.schema}.CLPROPOSTACOMERCIAL PC
                                 ON PC.ENTIDADE = AV.ENTIDADE
                                AND PC.EXERCICIOLICITACAO = AV.EXERCICIOLICITACAO
                                AND PC.TIPOLICITACAO = AV.TIPOLICITACAO
                                AND PC.LICITACAO = AV.LICITACAO
                                AND PC.LOTE = AV.LOTE
                                AND PC.ORDEM = AV.ORDEM
                                AND PC.PESSOA = AV.PESSOA
                         INNER JOIN ${db.compras.schema}.CLHOMOLOGACAO H
                                 ON H.ENTIDADE = AV.ENTIDADE
                                AND H.EXERCICIOLICITACAO = AV.EXERCICIOLICITACAO
                                AND H.TIPOLICITACAO = AV.TIPOLICITACAO
                                AND H.LICITACAO = AV.LICITACAO
                                AND H.PESSOA = AV.PESSOA
                              WHERE	L.ENTIDADE = AV.ENTIDADE
                                AND L.EXERCICIO = AV.EXERCICIOLICITACAO
                                AND L.TIPOLICITACAO = AV.TIPOLICITACAO
                                AND L.LICITACAO = AV.LICITACAO
                                AND AV.VENCEDOR = 'S'),	0)
       END AS TOTALVENCIDO,
       CAST(CASE WHEN L.FORMAAPURACAO = 'G' THEN 'Global' ELSE 'Item' END AS VARCHAR(10)) FORMAAPURACAO,
       (SELECT CASE WHEN COUNT(*) > 0 THEN 'S' ELSE 'N' END
          FROM ${db.compras.schema}.CLLICITACAORECURSO B
         WHERE B.ENTIDADE= L.ENTIDADE
           AND B.EXERCICIOLICITACAO = L.EXERCICIO
           AND B.TIPOLICITACAO= L.TIPOLICITACAO
           AND B.LICITACAO= L.LICITACAO) AS HASRECURSO,
       TP.DESCRICAO AS TIPOPARTICIPACAO,
       L.NUMEROLICITACAO||'/'||L.EXERCICIO AS DISPLAYLICITACAO,
       L.PROTOCOLO||'/'||L.ANOPROTOCOLO AS DISPLAYPROTOCOLO,
       E.NOME AS NOMEENTIDADE,
       l.numeroinforiginal,
       l.anoinforiginal,
       l.datainforiginal,
       l.modalidadeinforiginal,
       l.entidadeinforiginal,
       l.datapubinforiginal,
       l.obsinforiginal,
       l.lei_14133_2021sn aplicaLei14133,
       l.tcemt_tipoproclicit tcemtTipoProcLicit,
       TC.identificador idTipoCompra,
       TC.descricao descTipoCompra,
       l.datainicialproposta dataInicialProposta,
       l.horarioinicialproposta horaInicialProposta,
       l.datafinalproposta dataFinalProposta,
       l.horariofinalproposta horaFinalProposta,
       l.orcamentosigiloso
  FROM ${db.compras.schema}.cllicitacao l
  LEFT JOIN ${db.compras.schema}.cltipolicitacao tipolic
    ON L.tipolicitacao = tipoLic.tipolicitacao
  LEFT JOIN ${db.compras.schema}.ENTIDADE E
    ON E.ENTIDADE = L.ENTIDADE
  LEFT JOIN ${db.compras.schema}.PARAMETRO P
    ON P.ENTIDADE = L.ENTIDADE
   AND P.EXERCICIO = L.EXERCICIO
   AND P.PARAMETRO = 259
  LEFT JOIN ${db.compras.schema}.TIPOPARTICIPACAO TP
    ON TP.ID = L.IDTIPOPARTICIPACAO
  LEFT JOIN ${db.compras.schema}.NATUREZAPROCEDIMENTO N
    ON N.ID = L.IDNATUREZAPROCEDIMENTO
  LEFT JOIN ${db.compras.schema}.CLTIPOCOMPRA TC
    ON TC.id = L.TIPOCOMPRA
 WHERE ( (COALESCE(P.VALOR,'N') = 'S' AND (L.processoportal = 'S' OR L.processoportal IS NULL)) OR ( COALESCE(P.VALOR,'N') = 'N'
   AND ( EXISTS ( SELECT pub.entidade
                    FROM ${db.compras.schema}.cllicitacaopublicacao pub
                   WHERE L.entidade = pub.entidade
                     AND L.exercicio = pub.exercicio
                     AND L.tipolicitacao = pub.tipolicitacao
                     AND L.licitacao = pub.licitacao
                     AND (pub.tipopublicacao IN (1,6))) OR L.TIPOCANCELAMENTO IN ('F', 'D', 'R', 'A') OR L.status = 2)))
   AND L.ENTIDADE = :entidade AND L.EXERCICIO = :exercicio AND L.TIPOLICITACAO = :tipoLicitacao
