/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.repository.PortalParametroRepository;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import br.com.elotech.portaltransparencia.contabportal.domain.QEntidade;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.portaltransparencia.contabportal.service.RegistroService;
import br.com.elotech.portaltransparencia.utils.EntidadeServiceUtils;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class EntidadeContabilidadeSustentacaoService
implements EntidadeContabilidadeService {
    private final EntidadeContabilidadeRepository entidadeRepository;
    private final RegistroService registroService;
    private final PortalParametroRepository portalParametroRepository;
    private final EntidadeServiceUtils entidadeUtils;

    @Autowired
    public EntidadeContabilidadeSustentacaoService(EntidadeContabilidadeRepository entidadeRepository, RegistroService registroService, PortalParametroRepository portalParametroRepository, EntidadeServiceUtils entidadeUtils) {
        this.entidadeRepository = entidadeRepository;
        this.registroService = registroService;
        this.portalParametroRepository = portalParametroRepository;
        this.entidadeUtils = entidadeUtils;
    }

    public Optional<Entidade> getEntidadePrincipal() {
        List entidades = this.getEntidades();
        Optional<Entidade> entidadePrincipal = entidades.stream().filter(e -> e.getId().equals(e.getEntidadePrincipal())).findFirst();
        if (entidadePrincipal.isPresent()) {
            return entidadePrincipal;
        }
        return entidades.stream().findFirst();
    }

    public String resolveWhereSQL(Long entidade) {
        return this.entidadeUtils.resolveWhereSQL(entidade);
    }

    public Entidade getEntidadeSelecionada(Long idEntidade) {
        if (idEntidade != null && idEntidade > 0L) {
            return this.findOne(idEntidade);
        }
        return this.getEntidadePrincipal().orElse(null);
    }

    public Boolean verificaRegistro(Entidade entidade) {
        return this.registroService.isValid("34", entidade.getNome());
    }

    public List<Entidade> getEntidades() {
        ArrayList entidadesHabilitadas = Lists.newArrayList((Iterable)this.entidadeRepository.findAll((Predicate)QEntidade.entidade.id.notIn((Collection)this.idsEntidadesNaoHabilitadasPortal())));
        entidadesHabilitadas.stream().forEach(e -> e.setRegistrado(this.verificaRegistro(e).booleanValue()));
        PortalParametroContabil mostraEntidadeConsolidada = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_MOSTRA_ENTIDADE_CONSOLIDADA);
        if (Objects.nonNull(mostraEntidadeConsolidada) && StringUtils.isNotBlank((String)mostraEntidadeConsolidada.getValor()) && mostraEntidadeConsolidada.getValor().equals("S")) {
            Entidade entidadeConsolidada = new Entidade(Long.valueOf(-1L));
            entidadeConsolidada.setNome("CONSOLIDADA");
            entidadesHabilitadas.add(entidadeConsolidada);
        }
        return entidadesHabilitadas;
    }

    public List<Entidade> findByNome(String nome) {
        if (nome == null) {
            nome = "";
        }
        ArrayList entidadesHabilitadas = Lists.newArrayList((Iterable)this.entidadeRepository.findAll((Predicate)QEntidade.entidade.id.notIn((Collection)this.idsEntidadesNaoHabilitadasPortal()).and((Predicate)QEntidade.entidade.nome.containsIgnoreCase(nome))));
        entidadesHabilitadas.stream().forEach(e -> e.setRegistrado(this.verificaRegistro(e).booleanValue()));
        PortalParametroContabil mostraEntidadeConsolidada = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_MOSTRA_ENTIDADE_CONSOLIDADA);
        if (Objects.nonNull(mostraEntidadeConsolidada) && StringUtils.isNotBlank((String)mostraEntidadeConsolidada.getValor()) && mostraEntidadeConsolidada.getValor().equals("S")) {
            Entidade entidadeConsolidada = new Entidade(Long.valueOf(-1L));
            entidadeConsolidada.setNome("CONSOLIDADA");
            entidadesHabilitadas.add(entidadeConsolidada);
        }
        return entidadesHabilitadas;
    }

    private List<Long> idsEntidadesNaoHabilitadasPortal() {
        return this.entidadeUtils.idsEntidadesNaoHabilitadasPortal();
    }

    public Entidade findOne(Long id) {
        return (Entidade)this.entidadeRepository.findOne((Object)id);
    }

    public Integer getTamanhoReceita(Long entidade, Long exercicio) {
        return this.entidadeRepository.getTamanhoReceita(entidade, exercicio);
    }

    public String getUf(Long entidade) {
        return this.entidadeRepository.getUf(entidade);
    }

    public boolean isHabilitadoPortal(Long entidade) {
        return this.idsEntidadesNaoHabilitadasPortal().stream().filter(id -> id.equals(entidade)).count() == 0L;
    }

    public List<Entidade> findAll() {
        return this.entidadeRepository.findAll().stream().map(e -> {
            e.setHabilitadoPortal(this.entidadeUtils.isHabilitadoPortal(e.getId()));
            return e;
        }).collect(Collectors.toList());
    }
}

