/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.portaltransparencia.contabportal.domain.EmpresaTerceirizadaFuncionario;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpresaTercerizadaFuncionarioDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.EmpresaTerceirizadaFuncionarioParams;
import br.com.elotech.portaltransparencia.contabportal.service.EmpresaTerceirizadaFuncionarioService;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/empresa-terceirizada"})
public class EmpresaTerceirizadaResource {
    private final EmpresaTerceirizadaFuncionarioService empresaTerceirizadaFuncionarioService;
    private final ElotechProperties elotechProperties;
    private final BaseExport baseExport;

    @GetMapping
    public ResponseEntity<Page<EmpresaTerceirizadaFuncionario>> getFuncionarios(@RequestParam(value="entidade") Long entidade, @RequestParam(value="exercicio") Long exercicio, Pageable pageable, EmpresaTerceirizadaFuncionarioParams params) {
        return ResponseEntity.ok((Object)this.empresaTerceirizadaFuncionarioService.findEmpresaTerceirizada(entidade, exercicio, pageable, params));
    }

    @GetMapping(value={"/report"})
    public ModelAndView exportListTerceirizados(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="entidade") Long entidade, @RequestParam(value="exercicio") Long exercicio, Pageable pageable, @RequestParam(required=false) String cnpj, @RequestParam(required=false) String cargo, @RequestParam(required=false) String lotacao, @RequestParam(required=false) String trabalhador, @RequestParam(required=false) String empresa, @RequestParam String exportType) throws Throwable {
        EmpresaTerceirizadaFuncionarioParams params = EmpresaTerceirizadaFuncionarioParams.builder().empresa(empresa).cnpj(cnpj).trabalhador(trabalhador).lotacao(lotacao).cargo(cargo).build();
        Page data = this.empresaTerceirizadaFuncionarioService.findEmpresaTerceirizada(entidade, exercicio, pageable, params);
        PageImpl page = new PageImpl(data.stream().map(EmpresaTercerizadaFuncionarioDTO::mapToDTO).collect(Collectors.toList()));
        ReportParam reportParam = new ReportParam();
        reportParam.setReportTitle("Listagem dos Terceirizados");
        reportParam.setClazzDTO(EmpresaTercerizadaFuncionarioDTO.class);
        reportParam.setHeaderFields("Trabalhador,Empresa,CNPJ,Cargo/Atividade, Lota\u00e7\u00e3o");
        reportParam.setFields("nome,fornecedorNome,fornecedorCnpj,cargo,lotacao");
        float[] fieldsPerc = new float[]{0.8f, 1.0f, 0.8f, 0.8f, 2.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{20, 30, 20, 20, 500};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage((Page)page);
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(exportType);
        return this.baseExport.toExport(reportParam);
    }

    @Generated
    public EmpresaTerceirizadaResource(EmpresaTerceirizadaFuncionarioService empresaTerceirizadaFuncionarioService, ElotechProperties elotechProperties, BaseExport baseExport) {
        this.empresaTerceirizadaFuncionarioService = empresaTerceirizadaFuncionarioService;
        this.elotechProperties = elotechProperties;
        this.baseExport = baseExport;
    }
}

