/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.contabilidade.client.dto.DotacaoDTO;
import br.com.elotech.portaltransparencia.dto.AvaliacaoRealizadaDTO;
import br.com.elotech.portaltransparencia.dto.DotacaoSaldoLoadedDTO;
import java.math.BigDecimal;
import java.util.List;
import lombok.Generated;

public class AvaliacaoPPAProgramaDTO {
    private Long entidade;
    private Long exercicio;
    private BigDecimal valorPlanejado;
    private BigDecimal valorPlanejadoAtualizado;
    private BigDecimal valorExecutado;
    private String projeto;
    private String unidade;
    private String funcao;
    private String subfuncao;
    private String programa;
    private String descricaoProjeto;
    private String unidadeMedida;
    private String resultadoObtido;
    private BigDecimal metaFisicaPrevista = BigDecimal.ZERO;
    private BigDecimal numeroRealizado = BigDecimal.ZERO;

    public AvaliacaoPPAProgramaDTO(Long entidade, Long exercicio, BigDecimal valorPlanejado, BigDecimal valorPlanejadoAtualizado, BigDecimal valorExecutado, String projeto, String unidade, String funcao, String programa, String descricaoProjeto, String unidadeMedida, String resultadoObtido, BigDecimal metaFisicaPrevista, BigDecimal numeroRealizado) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.valorPlanejado = valorPlanejado;
        this.valorPlanejadoAtualizado = valorPlanejadoAtualizado;
        this.valorExecutado = valorExecutado;
        this.projeto = projeto;
        this.unidade = unidade;
        this.funcao = funcao;
        this.programa = programa;
        this.descricaoProjeto = descricaoProjeto;
        this.unidadeMedida = unidadeMedida;
        this.resultadoObtido = resultadoObtido;
        this.metaFisicaPrevista = metaFisicaPrevista;
        this.numeroRealizado = numeroRealizado;
    }

    public void setMetaPrevistaAndRealizada(AvaliacaoRealizadaDTO avaliacaoRealizadaDTO) {
        this.metaFisicaPrevista = avaliacaoRealizadaDTO.getMetaFisicaPrevista();
        this.numeroRealizado = avaliacaoRealizadaDTO.getMetaFisicaRealizada();
    }

    public static AvaliacaoPPAProgramaDTO fromDotacaoSaldo(List<DotacaoSaldoLoadedDTO> saldos) {
        DotacaoDTO dotacao = ((DotacaoSaldoLoadedDTO)saldos.stream().findAny().get()).getDotacao();
        AvaliacaoPPAProgramaDTO dto = new AvaliacaoPPAProgramaDTO();
        dto.setEntidade(dotacao.getUnidade().getEntidade().getId());
        dto.setExercicio(dotacao.getExercicio());
        dto.setValorPlanejado(saldos.stream().map(DotacaoSaldoLoadedDTO::getValorPrevisto).reduce(BigDecimal.ZERO, BigDecimal::add));
        dto.setValorPlanejadoAtualizado(saldos.stream().map(DotacaoSaldoLoadedDTO::getValorAtualizado).reduce(BigDecimal.ZERO, BigDecimal::add));
        dto.setValorExecutado(saldos.stream().map(DotacaoSaldoLoadedDTO::getValorEmpenhado).reduce(BigDecimal.ZERO, BigDecimal::add));
        dto.setProjeto(dotacao.getProjetoAtividade().getCodigo());
        dto.setUnidade(dotacao.getUnidade().getUnidadeComposta());
        dto.setFuncao(dotacao.getFuncao().getCodigo());
        dto.setSubfuncao(dotacao.getSubfuncao().getCodigo());
        dto.setPrograma(dotacao.getPrograma().getCodigo());
        dto.setDescricaoProjeto(dotacao.getProjetoAtividade().getDescricao());
        return dto;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public BigDecimal getValorPlanejado() {
        return this.valorPlanejado;
    }

    @Generated
    public BigDecimal getValorPlanejadoAtualizado() {
        return this.valorPlanejadoAtualizado;
    }

    @Generated
    public BigDecimal getValorExecutado() {
        return this.valorExecutado;
    }

    @Generated
    public String getProjeto() {
        return this.projeto;
    }

    @Generated
    public String getUnidade() {
        return this.unidade;
    }

    @Generated
    public String getFuncao() {
        return this.funcao;
    }

    @Generated
    public String getSubfuncao() {
        return this.subfuncao;
    }

    @Generated
    public String getPrograma() {
        return this.programa;
    }

    @Generated
    public String getDescricaoProjeto() {
        return this.descricaoProjeto;
    }

    @Generated
    public String getUnidadeMedida() {
        return this.unidadeMedida;
    }

    @Generated
    public String getResultadoObtido() {
        return this.resultadoObtido;
    }

    @Generated
    public BigDecimal getMetaFisicaPrevista() {
        return this.metaFisicaPrevista;
    }

    @Generated
    public BigDecimal getNumeroRealizado() {
        return this.numeroRealizado;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setValorPlanejado(BigDecimal valorPlanejado) {
        this.valorPlanejado = valorPlanejado;
    }

    @Generated
    public void setValorPlanejadoAtualizado(BigDecimal valorPlanejadoAtualizado) {
        this.valorPlanejadoAtualizado = valorPlanejadoAtualizado;
    }

    @Generated
    public void setValorExecutado(BigDecimal valorExecutado) {
        this.valorExecutado = valorExecutado;
    }

    @Generated
    public void setProjeto(String projeto) {
        this.projeto = projeto;
    }

    @Generated
    public void setUnidade(String unidade) {
        this.unidade = unidade;
    }

    @Generated
    public void setFuncao(String funcao) {
        this.funcao = funcao;
    }

    @Generated
    public void setSubfuncao(String subfuncao) {
        this.subfuncao = subfuncao;
    }

    @Generated
    public void setPrograma(String programa) {
        this.programa = programa;
    }

    @Generated
    public void setDescricaoProjeto(String descricaoProjeto) {
        this.descricaoProjeto = descricaoProjeto;
    }

    @Generated
    public void setUnidadeMedida(String unidadeMedida) {
        this.unidadeMedida = unidadeMedida;
    }

    @Generated
    public void setResultadoObtido(String resultadoObtido) {
        this.resultadoObtido = resultadoObtido;
    }

    @Generated
    public void setMetaFisicaPrevista(BigDecimal metaFisicaPrevista) {
        this.metaFisicaPrevista = metaFisicaPrevista;
    }

    @Generated
    public void setNumeroRealizado(BigDecimal numeroRealizado) {
        this.numeroRealizado = numeroRealizado;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AvaliacaoPPAProgramaDTO)) {
            return false;
        }
        AvaliacaoPPAProgramaDTO other = (AvaliacaoPPAProgramaDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        BigDecimal this$valorPlanejado = this.getValorPlanejado();
        BigDecimal other$valorPlanejado = other.getValorPlanejado();
        if (this$valorPlanejado == null ? other$valorPlanejado != null : !((Object)this$valorPlanejado).equals(other$valorPlanejado)) {
            return false;
        }
        BigDecimal this$valorPlanejadoAtualizado = this.getValorPlanejadoAtualizado();
        BigDecimal other$valorPlanejadoAtualizado = other.getValorPlanejadoAtualizado();
        if (this$valorPlanejadoAtualizado == null ? other$valorPlanejadoAtualizado != null : !((Object)this$valorPlanejadoAtualizado).equals(other$valorPlanejadoAtualizado)) {
            return false;
        }
        BigDecimal this$valorExecutado = this.getValorExecutado();
        BigDecimal other$valorExecutado = other.getValorExecutado();
        if (this$valorExecutado == null ? other$valorExecutado != null : !((Object)this$valorExecutado).equals(other$valorExecutado)) {
            return false;
        }
        String this$projeto = this.getProjeto();
        String other$projeto = other.getProjeto();
        if (this$projeto == null ? other$projeto != null : !this$projeto.equals(other$projeto)) {
            return false;
        }
        String this$unidade = this.getUnidade();
        String other$unidade = other.getUnidade();
        if (this$unidade == null ? other$unidade != null : !this$unidade.equals(other$unidade)) {
            return false;
        }
        String this$funcao = this.getFuncao();
        String other$funcao = other.getFuncao();
        if (this$funcao == null ? other$funcao != null : !this$funcao.equals(other$funcao)) {
            return false;
        }
        String this$subfuncao = this.getSubfuncao();
        String other$subfuncao = other.getSubfuncao();
        if (this$subfuncao == null ? other$subfuncao != null : !this$subfuncao.equals(other$subfuncao)) {
            return false;
        }
        String this$programa = this.getPrograma();
        String other$programa = other.getPrograma();
        if (this$programa == null ? other$programa != null : !this$programa.equals(other$programa)) {
            return false;
        }
        String this$descricaoProjeto = this.getDescricaoProjeto();
        String other$descricaoProjeto = other.getDescricaoProjeto();
        if (this$descricaoProjeto == null ? other$descricaoProjeto != null : !this$descricaoProjeto.equals(other$descricaoProjeto)) {
            return false;
        }
        String this$unidadeMedida = this.getUnidadeMedida();
        String other$unidadeMedida = other.getUnidadeMedida();
        if (this$unidadeMedida == null ? other$unidadeMedida != null : !this$unidadeMedida.equals(other$unidadeMedida)) {
            return false;
        }
        String this$resultadoObtido = this.getResultadoObtido();
        String other$resultadoObtido = other.getResultadoObtido();
        if (this$resultadoObtido == null ? other$resultadoObtido != null : !this$resultadoObtido.equals(other$resultadoObtido)) {
            return false;
        }
        BigDecimal this$metaFisicaPrevista = this.getMetaFisicaPrevista();
        BigDecimal other$metaFisicaPrevista = other.getMetaFisicaPrevista();
        if (this$metaFisicaPrevista == null ? other$metaFisicaPrevista != null : !((Object)this$metaFisicaPrevista).equals(other$metaFisicaPrevista)) {
            return false;
        }
        BigDecimal this$numeroRealizado = this.getNumeroRealizado();
        BigDecimal other$numeroRealizado = other.getNumeroRealizado();
        return !(this$numeroRealizado == null ? other$numeroRealizado != null : !((Object)this$numeroRealizado).equals(other$numeroRealizado));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AvaliacaoPPAProgramaDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        BigDecimal $valorPlanejado = this.getValorPlanejado();
        result = result * 59 + ($valorPlanejado == null ? 43 : ((Object)$valorPlanejado).hashCode());
        BigDecimal $valorPlanejadoAtualizado = this.getValorPlanejadoAtualizado();
        result = result * 59 + ($valorPlanejadoAtualizado == null ? 43 : ((Object)$valorPlanejadoAtualizado).hashCode());
        BigDecimal $valorExecutado = this.getValorExecutado();
        result = result * 59 + ($valorExecutado == null ? 43 : ((Object)$valorExecutado).hashCode());
        String $projeto = this.getProjeto();
        result = result * 59 + ($projeto == null ? 43 : $projeto.hashCode());
        String $unidade = this.getUnidade();
        result = result * 59 + ($unidade == null ? 43 : $unidade.hashCode());
        String $funcao = this.getFuncao();
        result = result * 59 + ($funcao == null ? 43 : $funcao.hashCode());
        String $subfuncao = this.getSubfuncao();
        result = result * 59 + ($subfuncao == null ? 43 : $subfuncao.hashCode());
        String $programa = this.getPrograma();
        result = result * 59 + ($programa == null ? 43 : $programa.hashCode());
        String $descricaoProjeto = this.getDescricaoProjeto();
        result = result * 59 + ($descricaoProjeto == null ? 43 : $descricaoProjeto.hashCode());
        String $unidadeMedida = this.getUnidadeMedida();
        result = result * 59 + ($unidadeMedida == null ? 43 : $unidadeMedida.hashCode());
        String $resultadoObtido = this.getResultadoObtido();
        result = result * 59 + ($resultadoObtido == null ? 43 : $resultadoObtido.hashCode());
        BigDecimal $metaFisicaPrevista = this.getMetaFisicaPrevista();
        result = result * 59 + ($metaFisicaPrevista == null ? 43 : ((Object)$metaFisicaPrevista).hashCode());
        BigDecimal $numeroRealizado = this.getNumeroRealizado();
        result = result * 59 + ($numeroRealizado == null ? 43 : ((Object)$numeroRealizado).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AvaliacaoPPAProgramaDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", valorPlanejado=" + this.getValorPlanejado() + ", valorPlanejadoAtualizado=" + this.getValorPlanejadoAtualizado() + ", valorExecutado=" + this.getValorExecutado() + ", projeto=" + this.getProjeto() + ", unidade=" + this.getUnidade() + ", funcao=" + this.getFuncao() + ", subfuncao=" + this.getSubfuncao() + ", programa=" + this.getPrograma() + ", descricaoProjeto=" + this.getDescricaoProjeto() + ", unidadeMedida=" + this.getUnidadeMedida() + ", resultadoObtido=" + this.getResultadoObtido() + ", metaFisicaPrevista=" + this.getMetaFisicaPrevista() + ", numeroRealizado=" + this.getNumeroRealizado() + ")";
    }

    @Generated
    public AvaliacaoPPAProgramaDTO(Long entidade, Long exercicio, BigDecimal valorPlanejado, BigDecimal valorPlanejadoAtualizado, BigDecimal valorExecutado, String projeto, String unidade, String funcao, String subfuncao, String programa, String descricaoProjeto, String unidadeMedida, String resultadoObtido, BigDecimal metaFisicaPrevista, BigDecimal numeroRealizado) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.valorPlanejado = valorPlanejado;
        this.valorPlanejadoAtualizado = valorPlanejadoAtualizado;
        this.valorExecutado = valorExecutado;
        this.projeto = projeto;
        this.unidade = unidade;
        this.funcao = funcao;
        this.subfuncao = subfuncao;
        this.programa = programa;
        this.descricaoProjeto = descricaoProjeto;
        this.unidadeMedida = unidadeMedida;
        this.resultadoObtido = resultadoObtido;
        this.metaFisicaPrevista = metaFisicaPrevista;
        this.numeroRealizado = numeroRealizado;
    }

    @Generated
    public AvaliacaoPPAProgramaDTO() {
    }
}

