SELECT A.LEI AS ID,
       :entidade AS Entidade,
       CAST('Lei' AS VARCHAR(3)) AS NATUREZA,
       A.LEI AS NUMERO,
       A.ANO AS EXERCICIO,
       A.PAGINA_EDICAO AS PAGINA,
       A.NUMERO_EDICAO AS NUMEROEDICAO,
       F.DESCRICAO ||
       COALESCE((SELECT ' (' || SIT.DESCRICAO || ') '
                  FROM ${db.contabilidade.schema}.LG_SITUACAOLEI SL
                  LEFT OUTER JOIN ${db.contabilidade.schema}.LG_SITUACAO SIT ON SL.SITUACAO =
                                                     SIT.SITUACAO
                 WHERE SL.LEI = A.LEI
                   AND SL.ANO = A.ANO
                   AND SL.TIPO = A.TIPO
                   AND SL.CODIGO = (SELECT MAX(SL3.CODIGO)
                          FROM ${db.contabilidade.schema}.LG_SITUACAOLEI SL3
                         WHERE SL3.LEI = SL.LEI
                           AND SL3.ANO = SL.ANO
                           AND SL3.TIPO = SL.TIPO)
                   AND SL.DATA =
                       (SELECT MAX(SL3.DATA)
                          FROM ${db.contabilidade.schema}.LG_SITUACAOLEI SL3
                         WHERE SL3.LEI = SL.LEI
                           AND SL3.ANO = SL.ANO
                           AND SL3.TIPO = SL.TIPO)),
                ' ') AS DESCRICAO,
       A.DATALEI AS DATA,
       B.NOME AS VEICULOPUBLICACAO,
       A.DATAPUBLICACAO,
       '' AS TIPODOCUMENTOLEGAL,
       A.SUMULA, 
       CASE WHEN A.ARQUIVOPDF IS NULL THEN 0 ELSE 1 END AS TOTALARQUIVO,
       CAST('L' AS VARCHAR(1)) AS SISTEMA,
       CAST('L' AS VARCHAR(1)) AS TABELALEGISLATIVO
  FROM ${db.contabilidade.schema}.LG_LEI A
  LEFT JOIN ${db.contabilidade.schema}.LG_ORGAOPUBLICACAO B ON A.ORGAOPUBLICACAO = B.ORGAOPUBLICACAO
  LEFT JOIN ${db.contabilidade.schema}.LG_FINALIDADE F ON A.FINALIDADE = F.FINALIDADE
WHERE A.LEI IS NOT NULL