/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.service.impl;

import br.com.elotech.core.common.dto.MailResultInfo;
import br.com.elotech.portaltransparencia.contabportal.service.ProcessoMailService;
import br.com.elotech.portaltransparencia.protocportal.domain.Processo;
import br.com.elotech.portaltransparencia.protocportal.domain.TipoProcesso;
import br.com.elotech.portaltransparencia.protocportal.dto.ProcessoDTO;
import br.com.elotech.portaltransparencia.protocportal.mapper.ProcessoToDTO;
import br.com.elotech.portaltransparencia.protocportal.params.ConsultaProcessoEsicParams;
import br.com.elotech.portaltransparencia.protocportal.params.ConsultaProcessoParams;
import br.com.elotech.portaltransparencia.protocportal.repository.ProcessoRepository;
import br.com.elotech.portaltransparencia.protocportal.repository.TipoProcessoRepository;
import br.com.elotech.portaltransparencia.protocportal.service.ParametroService;
import br.com.elotech.portaltransparencia.protocportal.service.ProcessoConsultaEsicService;
import br.com.elotech.protocolo.dto.TipoProcessoDTO;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ProcessoConsultaEsicServiceImpl
implements ProcessoConsultaEsicService {
    private final ProcessoRepository processoRepository;
    private final TipoProcessoRepository tipoProcessoRepository;
    private final ParametroService parametroService;
    private final ProcessoMailService processoMailService;

    public ProcessoConsultaEsicServiceImpl(ProcessoRepository processoRepository, ParametroService parametroService, ProcessoMailService processoMailService, TipoProcessoRepository tipoProcessoRepository) {
        this.processoRepository = processoRepository;
        this.parametroService = parametroService;
        this.processoMailService = processoMailService;
        this.tipoProcessoRepository = tipoProcessoRepository;
    }

    public ProcessoDTO consultaProcesso(ConsultaProcessoParams params) {
        String codigoSituacaoCancelado;
        Long entidade = params.getEntidade();
        Long exercicio = params.getExercicio();
        Long numero = params.getNumero();
        Long tipo = params.getTipo();
        String senha = params.getSenha();
        Optional processo = !Strings.isNullOrEmpty((String)senha) ? this.processoRepository.findByEntidadeExercicioTipoSenha(entidade, exercicio, numero, tipo, senha) : this.processoRepository.findByEntidadeExercicioTipoNumero(entidade, exercicio, numero, tipo);
        if (processo.isPresent() && StringUtils.isNotBlank((CharSequence)(codigoSituacaoCancelado = this.parametroService.findParametroPorEntidadeEExercicio(entidade, Long.valueOf(91L))))) {
            return new ProcessoToDTO().convert((Processo)processo.get(), Long.valueOf(Long.parseLong(codigoSituacaoCancelado)));
        }
        return null;
    }

    private Long tipoProcessoProtocolo(Long entidade, Long exercicio) {
        return Long.parseLong(this.parametroService.findTipoProcessoProtocoloOrThrow(entidade, exercicio));
    }

    public Future<MailResultInfo> enviaeSicEmail(ProcessoDTO processo) {
        return this.processoMailService.enviaeSicEmail(processo);
    }

    public Future<MailResultInfo> enviaContatoEmail(ProcessoDTO processo) {
        return this.processoMailService.enviaContatoEmail(processo);
    }

    public Page<ProcessoDTO> findProcessoByTipo(ConsultaProcessoEsicParams params, Pageable pageable) {
        Long tipo = this.tipoProcessoProtocolo(params.getEntidade(), params.getExercicio());
        if (Objects.nonNull(tipo)) {
            params.setTipo(tipo);
        }
        return this.processoRepository.findProcessoByTipo(params, pageable);
    }

    public List<TipoProcessoDTO> findTipoProcesso(Long entidade, Long exercicio) {
        Long tipoProcessoPadrao = Long.parseLong(this.parametroService.findTipoProcessoProtocoloOrThrow(entidade, exercicio));
        if (Objects.isNull(tipoProcessoPadrao)) {
            throw new IllegalArgumentException("O param\u00eatro 83 n\u00e3o foi configurado.");
        }
        return Collections.singletonList(((TipoProcesso)this.tipoProcessoRepository.findOne((Object)tipoProcessoPadrao)).toDTO());
    }
}

