/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.resource;

import br.com.elotech.portaltransparencia.protocportal.dto.EstatisticaDTO;
import br.com.elotech.portaltransparencia.protocportal.dto.RelatorioAnualEstatisticaDTO;
import br.com.elotech.portaltransparencia.protocportal.dto.SerieItemDTO;
import br.com.elotech.portaltransparencia.protocportal.resource.params.EstatisticaParams;
import br.com.elotech.portaltransparencia.protocportal.service.EstatisticaService;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.math.BigDecimal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/estatisticas"})
public class EstatisticaResource {
    private final EstatisticaService service;
    private final BaseExport baseExport;

    public EstatisticaResource(EstatisticaService service, BaseExport baseExport) {
        this.service = service;
        this.baseExport = baseExport;
    }

    @GetMapping
    public ResponseEntity<List<EstatisticaDTO>> findEstatisticas(EstatisticaParams params) {
        return ResponseEntity.ok((Object)this.service.findEstatisticas(params));
    }

    @GetMapping(value={"/media"})
    public ResponseEntity<BigDecimal> getMediaRespostas(EstatisticaParams params) {
        return ResponseEntity.ok((Object)this.service.getMediaResposta(params));
    }

    @GetMapping(value={"/processos-por-genero"})
    public ResponseEntity<List<SerieItemDTO>> findProcessosPorGenero(EstatisticaParams params) {
        return ResponseEntity.ok((Object)this.service.findProcessosPorGenero(params));
    }

    @GetMapping(value={"/processos-por-idade"})
    public ResponseEntity<List<SerieItemDTO>> findProcessosPorIdade(EstatisticaParams params) {
        return ResponseEntity.ok((Object)this.service.findProcessosPorIdade(params));
    }

    @GetMapping(value={"/processos-por-escolaridade"})
    public ResponseEntity<List<SerieItemDTO>> findProcessosPorEscolaridade(EstatisticaParams params) {
        return ResponseEntity.ok((Object)this.service.findProcessosPorEscolaridade(params));
    }

    @GetMapping(value={"/relatorio-anual"})
    public ResponseEntity<List<RelatorioAnualEstatisticaDTO>> findRelatorioAnual(EstatisticaParams params) {
        return ResponseEntity.ok((Object)this.service.findRelatorioAnual(params));
    }

    @GetMapping(value={"/export-relatorio-anual"})
    public ModelAndView exportRelatorioAnual(@RequestParam Long exercicio, @RequestParam Long entidade, @RequestParam String exportType, HttpServletRequest request, HttpServletResponse response) throws Throwable {
        EstatisticaParams params = new EstatisticaParams();
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        float[] fieldsPerc = new float[]{6.0f, 4.0f};
        int[] fieldTab = new int[]{300, 200};
        PageImpl page = new PageImpl(this.service.findRelatorioAnual(params));
        ReportParam param = new ReportParam();
        param.setReportTitle("Relat\u00f3rio Anual de Pedidos");
        param.setClazzDTO(RelatorioAnualEstatisticaDTO.class);
        param.setFields("descricao,quantidade");
        param.setHeaderFields("Descri\u00e7\u00e3o,Quantidade");
        param.setWidthsFieldsPerc(fieldsPerc);
        param.setWidthsFieldsTab(fieldTab);
        param.setPage((Page)page);
        param.setRequest(request);
        param.setResponse(response);
        param.setReportType(exportType);
        return this.baseExport.toExport(param);
    }
}

