/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service.impl;

import br.com.elotech.orcamento.client.PPAFeignClient;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.AvaliacaoPPADTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.AvaliacaoPPAProgramaDTO;
import br.com.elotech.portaltransparencia.contabportal.mapper.AvaliacaoPpaToTree;
import br.com.elotech.portaltransparencia.contabportal.repository.impl.AvaliacaoPPARepositoryOxyImpl;
import br.com.elotech.portaltransparencia.contabportal.resource.params.AvaliacaoPPAParams;
import br.com.elotech.portaltransparencia.contabportal.service.AvaliacaoPPAService;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public class AvaliacaoPPAServiceOxyImpl
implements AvaliacaoPPAService {
    private static final Long THREE_YEARS = 3L;
    private final AvaliacaoPPARepositoryOxyImpl repository;
    private final PPAFeignClient ppaFeignClient;

    public AvaliacaoPPADTO findAvaliacoesPPA(AvaliacaoPPAParams params) {
        List avaliacoesRealizadas = this.repository.findAvaliacoesPPA(params);
        List avaliacoesOrc = this.ppaFeignClient.findAllByExercicioRetroativos(params.getExercicio(), THREE_YEARS);
        avaliacoesRealizadas.forEach(avaliacao -> avaliacoesOrc.stream().filter(avaOrc -> Objects.equals(avaOrc.getCodigoAcao(), avaliacao.getProjeto()) && Objects.equals(avaOrc.getCodigoFuncao(), avaliacao.getFuncao()) && Objects.equals(avaOrc.getCodigoSubfuncao(), avaliacao.getSubfuncao()) && Objects.equals(avaOrc.getCodigoPrograma(), avaliacao.getPrograma()) && Objects.equals(avaOrc.getUnidadeComposta(), avaliacao.getUnidade()) && Objects.equals(avaOrc.getExercicio(), avaliacao.getExercicio())).findFirst().ifPresent(arg_0 -> ((AvaliacaoPPAProgramaDTO)avaliacao).setMetaPrevistaAndRealizada(arg_0)));
        return new AvaliacaoPpaToTree().apply(avaliacoesRealizadas);
    }

    @Generated
    public AvaliacaoPPAServiceOxyImpl(AvaliacaoPPARepositoryOxyImpl repository, PPAFeignClient ppaFeignClient) {
        this.repository = repository;
        this.ppaFeignClient = ppaFeignClient;
    }
}

