/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.portaltransparencia.admportal.domain.Orcamento;
import br.com.elotech.portaltransparencia.arquivoportal.service.ArquivoService;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.PortalOrcamentoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.PortalOrcamentoRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.PortalOrcamentoParams;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import org.joda.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class PortalOrcamentoService {
    private final PortalOrcamentoRepository portalOrcamentoRepository;
    private final ArquivoService arquivoService;

    @Autowired
    public PortalOrcamentoService(PortalOrcamentoRepository portalOrcamentoRepository, ArquivoService arquivoService) {
        this.portalOrcamentoRepository = portalOrcamentoRepository;
        this.arquivoService = arquivoService;
    }

    public List<PortalOrcamentoDTO> findOrcamentos(PortalOrcamentoParams params) {
        return this.portalOrcamentoRepository.findOrcamentos(params, this.arquivoService.getNomeSchemaEloArquivo());
    }

    public Orcamento findOne(Long id) {
        return (Orcamento)this.portalOrcamentoRepository.findOne((Object)id);
    }

    public Orcamento save(Orcamento orcamento) {
        if (Objects.isNull(orcamento.getId())) {
            orcamento.setDataCadastro(LocalDate.now());
            orcamento.setHoraCadastro(LocalDateTime.now().toString("HH:mm"));
        }
        return (Orcamento)this.portalOrcamentoRepository.save((Object)orcamento);
    }

    public void remove(Orcamento orcamento) {
        this.portalOrcamentoRepository.delete((Object)orcamento);
    }

    public Page<Orcamento> findByEntidadeId(Long entidade, Pageable pageable) {
        return this.portalOrcamentoRepository.findByEntidade(entidade, pageable);
    }

    public Page<Orcamento> findByEntidadeIdAndExercicio(PortalOrcamentoParams params, Pageable pageable) {
        return this.portalOrcamentoRepository.findByEntidadeAndExercicio((Long)params.getEntidade().get(), (Long)params.getExercicio().get(), pageable);
    }
}

