/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.Exercicio;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.portaltransparencia.contabportal.service.ExercicioService;
import java.util.List;
import java.util.Optional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/exercicios", "/admin/exercicios"})
public class ExercicioResource {
    private final ExercicioService exercicioService;
    private final EntidadeContabilidadeService entidadeService;

    public ExercicioResource(ExercicioService exercicioService, EntidadeContabilidadeService entidadeService) {
        this.exercicioService = exercicioService;
        this.entidadeService = entidadeService;
    }

    @GetMapping(value={"/entidade/{idEntidade}"})
    public ResponseEntity<List<Exercicio>> findListExercicios(@PathVariable Long idEntidade) {
        Entidade entidade = this.entidadeService.getEntidadeSelecionada(idEntidade);
        if (entidade == null || !this.entidadeService.isHabilitadoPortal(entidade.getId())) {
            throw RestException.notFound((String)"Entidade n\u00e3o encontrada ou n\u00e3o habilitada");
        }
        return ResponseEntity.ok((Object)this.exercicioService.getExercicios(entidade.getId()));
    }

    @GetMapping(value={"/exercicioByAno/{idEntidade}/{ano}"})
    public ResponseEntity<List<Exercicio>> findListExerciciosByAno(@PathVariable Long idEntidade, @PathVariable Long ano) {
        Entidade entidade = this.entidadeService.getEntidadeSelecionada(idEntidade);
        if (entidade == null || !this.entidadeService.isHabilitadoPortal(entidade.getId())) {
            throw RestException.notFound((String)"Entidade n\u00e3o encontrada ou n\u00e3o habilitada");
        }
        return ResponseEntity.ok((Object)this.exercicioService.getExerciciosByAno(entidade.getId(), ano));
    }

    @GetMapping(value={"/padrao"})
    public ResponseEntity<?> findEntidadePrincipal() {
        Optional exercicioPadrao = this.exercicioService.findExercicioPadrao();
        if (exercicioPadrao.isPresent()) {
            return ResponseEntity.ok((Object)((Exercicio)exercicioPadrao.get()));
        }
        return ResponseEntity.noContent().build();
    }
}

