/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.contabilidade.client.dto.CentralPagamentoDTO;
import br.com.elotech.contabilidade.client.dto.DocumentoLiquidacaoDTO;
import br.com.elotech.contabilidade.client.dto.EmpenhoDTO;
import br.com.elotech.contabilidade.client.dto.ExercicioDTO;
import br.com.elotech.contabilidade.client.dto.LicitacaoDTO;
import br.com.elotech.contabilidade.client.dto.PagamentoDTO;
import br.com.elotech.contabilidade.client.dto.PessoaDTO;
import br.com.elotech.contabilidade.client.dto.TipoLicitacaoDTO;
import br.com.elotech.core.utils.NumberUtils;
import br.com.elotech.orcamento.client.dto.FonteRecursoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LiquidacaoDTO;
import br.com.elotech.portaltransparencia.utils.MaskFormatterUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class LiquidacaoDTO {
    private Long ordemFonteRecurso;
    private String fonteRecurso;
    private LocalDate data;
    private LocalDate dataVencimento;
    private LocalDate dataPagamento;
    private Long exercicioLiquidacao;
    private Long noLiquidacao;
    private Long entidade;
    private Long exercicio;
    private Long empenho;
    private String empenhoExercicio;
    private String tipoLicitacao;
    private String licitacao;
    private String fornecedor;
    private String notasFiscais;
    private BigDecimal valor;
    private BigDecimal saldo;
    private String processo;
    private Long noOrdem;
    private Long sequencia;
    private BigDecimal valorParametro;
    private LocalDate dataLiquidacao;
    private String tipoContrato;
    private String tipoContratoContabil;
    private String observacao;

    public LiquidacaoDTO(PagamentoDTO pagamento) {
        CentralPagamentoDTO centralPagamento = pagamento.getCentralPagamento();
        br.com.elotech.contabilidade.client.dto.LiquidacaoDTO liquidacao = pagamento.getLiquidacao();
        EmpenhoDTO empenhoDTO = liquidacao.getEmpenho();
        FonteRecursoDTO fonteRecursoDTO = empenhoDTO.getFonteRecurso();
        LicitacaoDTO licitacaoDTO = empenhoDTO.getLicitacao();
        PessoaDTO credor = empenhoDTO.getCredor();
        ExercicioDTO exercicioCentral = centralPagamento.getExercicio();
        this.ordemFonteRecurso = Long.valueOf(fonteRecursoDTO.getCodigo());
        this.fonteRecurso = fonteRecursoDTO.getCodigo() + " - " + fonteRecursoDTO.getDescricao();
        this.data = centralPagamento.getData();
        this.dataVencimento = liquidacao.getDataVencimento();
        this.dataPagamento = null;
        this.dataLiquidacao = liquidacao.getDataLiquidacao();
        this.exercicioLiquidacao = liquidacao.getExercicioAno();
        this.noLiquidacao = liquidacao.getNumeroLiquidacao();
        this.entidade = exercicioCentral.getEntidade().getId();
        this.exercicio = empenhoDTO.getExercicio().getExercicio();
        this.empenho = empenhoDTO.getNumeroEmpenho();
        this.notasFiscais = this.generateNotasFiscais(liquidacao.getDocumentos());
        this.valor = pagamento.getValorLiquido();
        this.saldo = pagamento.getSaldoPago().subtract(pagamento.getSaldoPagoAnulado());
        this.noOrdem = centralPagamento.getNumeroCentral();
        this.valorParametro = pagamento.getSaldoPago().subtract(pagamento.getSaldoPagoAnulado());
        this.licitacao = "";
        this.fornecedor = MaskFormatterUtils.configMaskCnpjCpf((String)credor.getCnpjCpf()) + " - " + credor.getNome();
        this.tipoLicitacao = Optional.ofNullable(empenhoDTO.getTipoLicitacao()).orElse(new TipoLicitacaoDTO()).getDescricao();
        Optional.ofNullable(licitacaoDTO).ifPresent(l -> {
            this.licitacao = l.getNumeroLicitacao() + "/" + l.getAno();
        });
    }

    public LiquidacaoDTO(br.com.elotech.contabilidade.client.dto.LiquidacaoDTO liquidacao) {
        EmpenhoDTO empenhoDTO = liquidacao.getEmpenho();
        FonteRecursoDTO fonteRecursoDTO = empenhoDTO.getFonteRecurso();
        LicitacaoDTO licitacaoDTO = empenhoDTO.getLicitacao();
        PessoaDTO credor = empenhoDTO.getCredor();
        this.ordemFonteRecurso = Long.valueOf(fonteRecursoDTO.getCodigo());
        this.fonteRecurso = fonteRecursoDTO.getCodigo() + " - " + fonteRecursoDTO.getDescricao();
        this.data = liquidacao.getDataLiquidacao();
        this.dataVencimento = null;
        this.dataPagamento = null;
        this.dataLiquidacao = null;
        this.exercicioLiquidacao = liquidacao.getExercicioAno();
        this.noLiquidacao = liquidacao.getNumeroLiquidacao();
        this.entidade = liquidacao.getExercicio().getEntidade().getId();
        this.exercicio = empenhoDTO.getExercicio().getExercicio();
        this.empenho = empenhoDTO.getNumeroEmpenho();
        this.empenhoExercicio = empenhoDTO.getExercicio().getExercicio().toString();
        this.notasFiscais = this.generateNotasFiscais(liquidacao.getDocumentos());
        this.valor = liquidacao.getValor();
        this.saldo = liquidacao.getMovimentoAtePeriodo().getSaldoDisponivel();
        this.valorParametro = liquidacao.getMovimentoAtePeriodo().getSaldoDisponivel();
        this.licitacao = "";
        this.fornecedor = MaskFormatterUtils.configMaskCnpjCpf((String)credor.getCnpjCpf()) + " - " + credor.getNome();
        this.tipoLicitacao = Optional.ofNullable(empenhoDTO.getTipoLicitacao()).orElse(new TipoLicitacaoDTO()).getDescricao();
        Optional.ofNullable(licitacaoDTO).ifPresent(l -> {
            this.licitacao = l.getNumeroLicitacao() + "/" + l.getAno();
        });
    }

    public BigDecimal getValor() {
        return NumberUtils.formatBigDecimalRound((BigDecimal)this.valor);
    }

    public BigDecimal getSaldo() {
        return NumberUtils.formatBigDecimalRound((BigDecimal)this.saldo);
    }

    public String generateNotasFiscais(List<DocumentoLiquidacaoDTO> documento) {
        return documento.stream().map(DocumentoLiquidacaoDTO::getNumeroDocumento).collect(Collectors.joining("-"));
    }

    @Generated
    public static LiquidacaoDTOBuilder builder() {
        return new LiquidacaoDTOBuilder();
    }

    @Generated
    public Long getOrdemFonteRecurso() {
        return this.ordemFonteRecurso;
    }

    @Generated
    public String getFonteRecurso() {
        return this.fonteRecurso;
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public LocalDate getDataPagamento() {
        return this.dataPagamento;
    }

    @Generated
    public Long getExercicioLiquidacao() {
        return this.exercicioLiquidacao;
    }

    @Generated
    public Long getNoLiquidacao() {
        return this.noLiquidacao;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getEmpenho() {
        return this.empenho;
    }

    @Generated
    public String getEmpenhoExercicio() {
        return this.empenhoExercicio;
    }

    @Generated
    public String getTipoLicitacao() {
        return this.tipoLicitacao;
    }

    @Generated
    public String getLicitacao() {
        return this.licitacao;
    }

    @Generated
    public String getFornecedor() {
        return this.fornecedor;
    }

    @Generated
    public String getNotasFiscais() {
        return this.notasFiscais;
    }

    @Generated
    public String getProcesso() {
        return this.processo;
    }

    @Generated
    public Long getNoOrdem() {
        return this.noOrdem;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public BigDecimal getValorParametro() {
        return this.valorParametro;
    }

    @Generated
    public LocalDate getDataLiquidacao() {
        return this.dataLiquidacao;
    }

    @Generated
    public String getTipoContrato() {
        return this.tipoContrato;
    }

    @Generated
    public String getTipoContratoContabil() {
        return this.tipoContratoContabil;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public void setOrdemFonteRecurso(Long ordemFonteRecurso) {
        this.ordemFonteRecurso = ordemFonteRecurso;
    }

    @Generated
    public void setFonteRecurso(String fonteRecurso) {
        this.fonteRecurso = fonteRecurso;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setDataPagamento(LocalDate dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    @Generated
    public void setExercicioLiquidacao(Long exercicioLiquidacao) {
        this.exercicioLiquidacao = exercicioLiquidacao;
    }

    @Generated
    public void setNoLiquidacao(Long noLiquidacao) {
        this.noLiquidacao = noLiquidacao;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setEmpenho(Long empenho) {
        this.empenho = empenho;
    }

    @Generated
    public void setEmpenhoExercicio(String empenhoExercicio) {
        this.empenhoExercicio = empenhoExercicio;
    }

    @Generated
    public void setTipoLicitacao(String tipoLicitacao) {
        this.tipoLicitacao = tipoLicitacao;
    }

    @Generated
    public void setLicitacao(String licitacao) {
        this.licitacao = licitacao;
    }

    @Generated
    public void setFornecedor(String fornecedor) {
        this.fornecedor = fornecedor;
    }

    @Generated
    public void setNotasFiscais(String notasFiscais) {
        this.notasFiscais = notasFiscais;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setSaldo(BigDecimal saldo) {
        this.saldo = saldo;
    }

    @Generated
    public void setProcesso(String processo) {
        this.processo = processo;
    }

    @Generated
    public void setNoOrdem(Long noOrdem) {
        this.noOrdem = noOrdem;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setValorParametro(BigDecimal valorParametro) {
        this.valorParametro = valorParametro;
    }

    @Generated
    public void setDataLiquidacao(LocalDate dataLiquidacao) {
        this.dataLiquidacao = dataLiquidacao;
    }

    @Generated
    public void setTipoContrato(String tipoContrato) {
        this.tipoContrato = tipoContrato;
    }

    @Generated
    public void setTipoContratoContabil(String tipoContratoContabil) {
        this.tipoContratoContabil = tipoContratoContabil;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LiquidacaoDTO)) {
            return false;
        }
        LiquidacaoDTO other = (LiquidacaoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$ordemFonteRecurso = this.getOrdemFonteRecurso();
        Long other$ordemFonteRecurso = other.getOrdemFonteRecurso();
        if (this$ordemFonteRecurso == null ? other$ordemFonteRecurso != null : !((Object)this$ordemFonteRecurso).equals(other$ordemFonteRecurso)) {
            return false;
        }
        String this$fonteRecurso = this.getFonteRecurso();
        String other$fonteRecurso = other.getFonteRecurso();
        if (this$fonteRecurso == null ? other$fonteRecurso != null : !this$fonteRecurso.equals(other$fonteRecurso)) {
            return false;
        }
        LocalDate this$data = this.getData();
        LocalDate other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        LocalDate this$dataVencimento = this.getDataVencimento();
        LocalDate other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !((Object)this$dataVencimento).equals(other$dataVencimento)) {
            return false;
        }
        LocalDate this$dataPagamento = this.getDataPagamento();
        LocalDate other$dataPagamento = other.getDataPagamento();
        if (this$dataPagamento == null ? other$dataPagamento != null : !((Object)this$dataPagamento).equals(other$dataPagamento)) {
            return false;
        }
        Long this$exercicioLiquidacao = this.getExercicioLiquidacao();
        Long other$exercicioLiquidacao = other.getExercicioLiquidacao();
        if (this$exercicioLiquidacao == null ? other$exercicioLiquidacao != null : !((Object)this$exercicioLiquidacao).equals(other$exercicioLiquidacao)) {
            return false;
        }
        Long this$noLiquidacao = this.getNoLiquidacao();
        Long other$noLiquidacao = other.getNoLiquidacao();
        if (this$noLiquidacao == null ? other$noLiquidacao != null : !((Object)this$noLiquidacao).equals(other$noLiquidacao)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$empenho = this.getEmpenho();
        Long other$empenho = other.getEmpenho();
        if (this$empenho == null ? other$empenho != null : !((Object)this$empenho).equals(other$empenho)) {
            return false;
        }
        String this$empenhoExercicio = this.getEmpenhoExercicio();
        String other$empenhoExercicio = other.getEmpenhoExercicio();
        if (this$empenhoExercicio == null ? other$empenhoExercicio != null : !this$empenhoExercicio.equals(other$empenhoExercicio)) {
            return false;
        }
        String this$tipoLicitacao = this.getTipoLicitacao();
        String other$tipoLicitacao = other.getTipoLicitacao();
        if (this$tipoLicitacao == null ? other$tipoLicitacao != null : !this$tipoLicitacao.equals(other$tipoLicitacao)) {
            return false;
        }
        String this$licitacao = this.getLicitacao();
        String other$licitacao = other.getLicitacao();
        if (this$licitacao == null ? other$licitacao != null : !this$licitacao.equals(other$licitacao)) {
            return false;
        }
        String this$fornecedor = this.getFornecedor();
        String other$fornecedor = other.getFornecedor();
        if (this$fornecedor == null ? other$fornecedor != null : !this$fornecedor.equals(other$fornecedor)) {
            return false;
        }
        String this$notasFiscais = this.getNotasFiscais();
        String other$notasFiscais = other.getNotasFiscais();
        if (this$notasFiscais == null ? other$notasFiscais != null : !this$notasFiscais.equals(other$notasFiscais)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        BigDecimal this$saldo = this.getSaldo();
        BigDecimal other$saldo = other.getSaldo();
        if (this$saldo == null ? other$saldo != null : !((Object)this$saldo).equals(other$saldo)) {
            return false;
        }
        String this$processo = this.getProcesso();
        String other$processo = other.getProcesso();
        if (this$processo == null ? other$processo != null : !this$processo.equals(other$processo)) {
            return false;
        }
        Long this$noOrdem = this.getNoOrdem();
        Long other$noOrdem = other.getNoOrdem();
        if (this$noOrdem == null ? other$noOrdem != null : !((Object)this$noOrdem).equals(other$noOrdem)) {
            return false;
        }
        Long this$sequencia = this.getSequencia();
        Long other$sequencia = other.getSequencia();
        if (this$sequencia == null ? other$sequencia != null : !((Object)this$sequencia).equals(other$sequencia)) {
            return false;
        }
        BigDecimal this$valorParametro = this.getValorParametro();
        BigDecimal other$valorParametro = other.getValorParametro();
        if (this$valorParametro == null ? other$valorParametro != null : !((Object)this$valorParametro).equals(other$valorParametro)) {
            return false;
        }
        LocalDate this$dataLiquidacao = this.getDataLiquidacao();
        LocalDate other$dataLiquidacao = other.getDataLiquidacao();
        if (this$dataLiquidacao == null ? other$dataLiquidacao != null : !((Object)this$dataLiquidacao).equals(other$dataLiquidacao)) {
            return false;
        }
        String this$tipoContrato = this.getTipoContrato();
        String other$tipoContrato = other.getTipoContrato();
        if (this$tipoContrato == null ? other$tipoContrato != null : !this$tipoContrato.equals(other$tipoContrato)) {
            return false;
        }
        String this$tipoContratoContabil = this.getTipoContratoContabil();
        String other$tipoContratoContabil = other.getTipoContratoContabil();
        if (this$tipoContratoContabil == null ? other$tipoContratoContabil != null : !this$tipoContratoContabil.equals(other$tipoContratoContabil)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        return !(this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LiquidacaoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $ordemFonteRecurso = this.getOrdemFonteRecurso();
        result = result * 59 + ($ordemFonteRecurso == null ? 43 : ((Object)$ordemFonteRecurso).hashCode());
        String $fonteRecurso = this.getFonteRecurso();
        result = result * 59 + ($fonteRecurso == null ? 43 : $fonteRecurso.hashCode());
        LocalDate $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        LocalDate $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : ((Object)$dataVencimento).hashCode());
        LocalDate $dataPagamento = this.getDataPagamento();
        result = result * 59 + ($dataPagamento == null ? 43 : ((Object)$dataPagamento).hashCode());
        Long $exercicioLiquidacao = this.getExercicioLiquidacao();
        result = result * 59 + ($exercicioLiquidacao == null ? 43 : ((Object)$exercicioLiquidacao).hashCode());
        Long $noLiquidacao = this.getNoLiquidacao();
        result = result * 59 + ($noLiquidacao == null ? 43 : ((Object)$noLiquidacao).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $empenho = this.getEmpenho();
        result = result * 59 + ($empenho == null ? 43 : ((Object)$empenho).hashCode());
        String $empenhoExercicio = this.getEmpenhoExercicio();
        result = result * 59 + ($empenhoExercicio == null ? 43 : $empenhoExercicio.hashCode());
        String $tipoLicitacao = this.getTipoLicitacao();
        result = result * 59 + ($tipoLicitacao == null ? 43 : $tipoLicitacao.hashCode());
        String $licitacao = this.getLicitacao();
        result = result * 59 + ($licitacao == null ? 43 : $licitacao.hashCode());
        String $fornecedor = this.getFornecedor();
        result = result * 59 + ($fornecedor == null ? 43 : $fornecedor.hashCode());
        String $notasFiscais = this.getNotasFiscais();
        result = result * 59 + ($notasFiscais == null ? 43 : $notasFiscais.hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        BigDecimal $saldo = this.getSaldo();
        result = result * 59 + ($saldo == null ? 43 : ((Object)$saldo).hashCode());
        String $processo = this.getProcesso();
        result = result * 59 + ($processo == null ? 43 : $processo.hashCode());
        Long $noOrdem = this.getNoOrdem();
        result = result * 59 + ($noOrdem == null ? 43 : ((Object)$noOrdem).hashCode());
        Long $sequencia = this.getSequencia();
        result = result * 59 + ($sequencia == null ? 43 : ((Object)$sequencia).hashCode());
        BigDecimal $valorParametro = this.getValorParametro();
        result = result * 59 + ($valorParametro == null ? 43 : ((Object)$valorParametro).hashCode());
        LocalDate $dataLiquidacao = this.getDataLiquidacao();
        result = result * 59 + ($dataLiquidacao == null ? 43 : ((Object)$dataLiquidacao).hashCode());
        String $tipoContrato = this.getTipoContrato();
        result = result * 59 + ($tipoContrato == null ? 43 : $tipoContrato.hashCode());
        String $tipoContratoContabil = this.getTipoContratoContabil();
        result = result * 59 + ($tipoContratoContabil == null ? 43 : $tipoContratoContabil.hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LiquidacaoDTO(ordemFonteRecurso=" + this.getOrdemFonteRecurso() + ", fonteRecurso=" + this.getFonteRecurso() + ", data=" + this.getData() + ", dataVencimento=" + this.getDataVencimento() + ", dataPagamento=" + this.getDataPagamento() + ", exercicioLiquidacao=" + this.getExercicioLiquidacao() + ", noLiquidacao=" + this.getNoLiquidacao() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", empenho=" + this.getEmpenho() + ", empenhoExercicio=" + this.getEmpenhoExercicio() + ", tipoLicitacao=" + this.getTipoLicitacao() + ", licitacao=" + this.getLicitacao() + ", fornecedor=" + this.getFornecedor() + ", notasFiscais=" + this.getNotasFiscais() + ", valor=" + this.getValor() + ", saldo=" + this.getSaldo() + ", processo=" + this.getProcesso() + ", noOrdem=" + this.getNoOrdem() + ", sequencia=" + this.getSequencia() + ", valorParametro=" + this.getValorParametro() + ", dataLiquidacao=" + this.getDataLiquidacao() + ", tipoContrato=" + this.getTipoContrato() + ", tipoContratoContabil=" + this.getTipoContratoContabil() + ", observacao=" + this.getObservacao() + ")";
    }

    @Generated
    public LiquidacaoDTO() {
    }

    @Generated
    public LiquidacaoDTO(Long ordemFonteRecurso, String fonteRecurso, LocalDate data, LocalDate dataVencimento, LocalDate dataPagamento, Long exercicioLiquidacao, Long noLiquidacao, Long entidade, Long exercicio, Long empenho, String empenhoExercicio, String tipoLicitacao, String licitacao, String fornecedor, String notasFiscais, BigDecimal valor, BigDecimal saldo, String processo, Long noOrdem, Long sequencia, BigDecimal valorParametro, LocalDate dataLiquidacao, String tipoContrato, String tipoContratoContabil, String observacao) {
        this.ordemFonteRecurso = ordemFonteRecurso;
        this.fonteRecurso = fonteRecurso;
        this.data = data;
        this.dataVencimento = dataVencimento;
        this.dataPagamento = dataPagamento;
        this.exercicioLiquidacao = exercicioLiquidacao;
        this.noLiquidacao = noLiquidacao;
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.empenho = empenho;
        this.empenhoExercicio = empenhoExercicio;
        this.tipoLicitacao = tipoLicitacao;
        this.licitacao = licitacao;
        this.fornecedor = fornecedor;
        this.notasFiscais = notasFiscais;
        this.valor = valor;
        this.saldo = saldo;
        this.processo = processo;
        this.noOrdem = noOrdem;
        this.sequencia = sequencia;
        this.valorParametro = valorParametro;
        this.dataLiquidacao = dataLiquidacao;
        this.tipoContrato = tipoContrato;
        this.tipoContratoContabil = tipoContratoContabil;
        this.observacao = observacao;
    }
}

