/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.atos.client.dto.BeneficiarioDTO;
import br.com.elotech.atos.client.dto.TipoOperacaoConvenioDTO;
import br.com.elotech.atos.client.dto.TipoRegistroDTO;
import br.com.elotech.core.utils.NumberUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;

public class ConvenioDTO {
    private Long id;
    private Long nrConvenio;
    private Long nrAnoConvenio;
    private LocalDate dataCelebracao;
    private LocalDate dataInicioVigencia;
    private LocalDate dataFimVigencia;
    private Long fornecedor;
    private String cnpj;
    private String nome;
    private Long qtParcelas;
    private String dsObjeto;
    private Long fonteRecurso;
    private String descricaoFonte;
    private Long entidade;
    private BigDecimal valorConvenio;
    private String situacao;
    private Long idSituacao;
    private Long totalArquivo;
    private String linkGov;
    private String displayConvenio;
    private BigDecimal vlRecursoProprio;
    private Long idContaCorrente;
    private Long local;
    private String fiscalConvenio;
    private TipoRegistroDTO tipoRegistroConvenio;

    public ConvenioDTO(br.com.elotech.atos.client.dto.ConvenioDTO convenioFromOxy) {
        BeneficiarioDTO beneficiario = convenioFromOxy.getBeneficiario();
        this.id = convenioFromOxy.getId();
        this.entidade = convenioFromOxy.getEntidade().getId();
        this.nrConvenio = convenioFromOxy.getNumero();
        this.nrAnoConvenio = convenioFromOxy.getAno();
        this.nome = beneficiario.getPessoa().getNome();
        this.valorConvenio = convenioFromOxy.getValor();
        this.cnpj = beneficiario.getPessoa().getCnpjCpf();
        this.dataInicioVigencia = convenioFromOxy.getDataInicioVigencia();
        this.dataFimVigencia = convenioFromOxy.getDataFimVigencia();
        this.fonteRecurso = Long.valueOf(convenioFromOxy.getFonteRecurso().getCodigo());
        this.dataCelebracao = convenioFromOxy.getDataCelebracao();
        this.descricaoFonte = convenioFromOxy.getFonteRecurso().getDescricao();
        this.dsObjeto = convenioFromOxy.getObjetivo();
        this.tipoRegistroConvenio = convenioFromOxy.getTipoRegistroConvenio();
        this.idContaCorrente = 0L;
        this.local = 0L;
        this.fiscalConvenio = "";
        this.situacao = Optional.ofNullable(convenioFromOxy.getSituacaoConvenio()).map(TipoOperacaoConvenioDTO::getDescricao).orElse(null);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getNrConvenio() {
        return this.nrConvenio;
    }

    public void setNrConvenio(Long nrConvenio) {
        this.nrConvenio = nrConvenio;
    }

    public Long getIdContaCorrente() {
        return this.idContaCorrente;
    }

    public void setIdContaCorrente(Long idContaCorrente) {
        this.idContaCorrente = idContaCorrente;
    }

    public Long getNrAnoConvenio() {
        return this.nrAnoConvenio;
    }

    public void setNrAnoConvenio(Long nrAnoConvenio) {
        this.nrAnoConvenio = nrAnoConvenio;
    }

    public LocalDate getDataCelebracao() {
        return this.dataCelebracao;
    }

    public void setDataCelebracao(LocalDate dataCelebracao) {
        this.dataCelebracao = dataCelebracao;
    }

    public LocalDate getDataInicioVigencia() {
        return this.dataInicioVigencia;
    }

    public void setDataInicioVigencia(LocalDate dataInicioVigencia) {
        this.dataInicioVigencia = dataInicioVigencia;
    }

    public LocalDate getDataFimVigencia() {
        return this.dataFimVigencia;
    }

    public void setDataFimVigencia(LocalDate dataFimVigencia) {
        this.dataFimVigencia = dataFimVigencia;
    }

    public Long getFornecedor() {
        return this.fornecedor;
    }

    public void setFornecedor(Long fornecedor) {
        this.fornecedor = fornecedor;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Long getQtParcelas() {
        return this.qtParcelas;
    }

    public void setQtParcelas(Long qtParcelas) {
        this.qtParcelas = qtParcelas;
    }

    public String getDsObjeto() {
        return this.dsObjeto;
    }

    public void setDsObjeto(String dsObjeto) {
        this.dsObjeto = dsObjeto;
    }

    public Long getFonteRecurso() {
        return this.fonteRecurso;
    }

    public void setFonteRecurso(Long fonteRecurso) {
        this.fonteRecurso = fonteRecurso;
    }

    public String getDescricaoFonte() {
        return this.descricaoFonte;
    }

    public void setDescricaoFonte(String descricaoFonte) {
        this.descricaoFonte = descricaoFonte;
    }

    public Long getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    public BigDecimal getValorConvenio() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorConvenio);
    }

    public void setValorConvenio(BigDecimal valorConvenio) {
        this.valorConvenio = valorConvenio;
    }

    public BigDecimal getvlRecursoProprio() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.vlRecursoProprio);
    }

    public void setvlRecursoProprio(BigDecimal vlRecursoProprio) {
        this.vlRecursoProprio = vlRecursoProprio;
    }

    public String getSituacao() {
        return this.situacao;
    }

    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    public Long getIdSituacao() {
        return this.idSituacao;
    }

    public void setIdSituacao(Long idSituacao) {
        this.idSituacao = idSituacao;
    }

    public Long getTotalArquivo() {
        return this.totalArquivo;
    }

    public void setTotalArquivo(Long totalArquivo) {
        this.totalArquivo = totalArquivo;
    }

    public String getLinkGov() {
        return this.linkGov;
    }

    public void setLinkGov(String linkGov) {
        this.linkGov = linkGov;
    }

    public String getDisplayConvenio() {
        return this.displayConvenio;
    }

    public void setDisplayConvenio(String displayConvenio) {
        this.displayConvenio = displayConvenio;
    }

    public Long getLocal() {
        return this.local;
    }

    public void setLocal(Long local) {
        this.local = local;
    }

    public String getFiscalConvenio() {
        return this.fiscalConvenio;
    }

    public void setFiscalConvenio(String fiscalConvenio) {
        this.fiscalConvenio = fiscalConvenio;
    }

    public TipoRegistroDTO getTipoRegistroConvenio() {
        return this.tipoRegistroConvenio;
    }

    public void setTipoRegistro(TipoRegistroDTO tipoRegistro) {
        this.tipoRegistroConvenio = tipoRegistro;
    }

    @Generated
    public ConvenioDTO() {
    }
}

