/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.config;

import br.com.elotech.core.utils.EloPage;
import br.com.elotech.portaltransparencia.config.AuthenticationClientUnico;
import br.com.elotech.portaltransparencia.protocportal.domain.Pessoa;
import br.com.elotech.portaltransparencia.protocportal.mapper.PessoaDtoToPessoa;
import br.com.elotech.unico.client.PessoaFeignClient;
import br.com.elotech.unico.client.dto.PessoaDTO;
import br.com.elotech.unico.exception.UnicoClientException;
import feign.FeignException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class PessoaClientUnico {
    private static final Logger LOGGER = LoggerFactory.getLogger(PessoaClientUnico.class);
    private final PessoaFeignClient pessoaFeignClient;
    private final AuthenticationClientUnico authClient;

    public PessoaClientUnico(PessoaFeignClient pessoaFeignClient, AuthenticationClientUnico authenticationClient) {
        this.pessoaFeignClient = pessoaFeignClient;
        this.authClient = authenticationClient;
    }

    public Optional<Pessoa> findFirstPessoaByRSQL(String search) {
        PageRequest pageRequest = PageRequest.of((int)0, (int)1, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"});
        EloPage pessoaPage = this.findPessoasByRSQL(search, (Pageable)pageRequest);
        return pessoaPage.getContent().stream().findFirst().map(new PessoaDtoToPessoa());
    }

    public PessoaDTO savePessoa(PessoaDTO pessoaDTO) {
        try {
            String token = this.authClient.authenticateAndReturnToken();
            LOGGER.debug("Autenticado no \u00fanico com sucesso");
            return this.pessoaFeignClient.savePessoa(token, pessoaDTO);
        }
        catch (FeignException ex) {
            LOGGER.error("Erro inesperado ao salvar a pessoa no \u00fanico. [{}]", (Object)ex.getMessage(), (Object)ex);
            throw new UnicoClientException("N\u00e3o foi poss\u00edvel inserir a nova pessoa no \u00fanico", (Throwable)ex);
        }
    }

    private EloPage<PessoaDTO> findPessoasByRSQL(String search, Pageable pageable) {
        try {
            String authToken = this.authClient.authenticateAndReturnToken();
            LOGGER.debug("Autenticado no \u00fanico com sucesso");
            ResponseEntity response = this.pessoaFeignClient.findPessoaByRSQL(authToken, search);
            LOGGER.debug("Pesquisou pessoa no \u00fanico com sucesso. Response {}", (Object)response);
            if (HttpStatus.OK.equals((Object)response.getStatusCode())) {
                return (EloPage)response.getBody();
            }
        }
        catch (FeignException ex) {
            LOGGER.error("Erro ao consultar pessoa com search [{}]", new Object[]{search, ex.getMessage(), ex});
        }
        LOGGER.warn("O \u00fanico n\u00e3o respondeu com sucesso com os argumentos [{} : {}], nenhuma pessoa ser\u00e1 retornada.", (Object)search, (Object)pageable);
        return new EloPage();
    }

    public void ativaProtocolo(Long idUnico) {
        try {
            String token = this.authClient.authenticateAndReturnToken();
            LOGGER.debug("Autenticado no \u00fanico com sucesso");
            this.pessoaFeignClient.ativaProtocolo(idUnico, token);
        }
        catch (FeignException ex) {
            LOGGER.error("Erro inesperado ao ativar pessoa no protocolo. [{}]", (Object)ex.getMessage(), (Object)ex);
            throw new UnicoClientException("N\u00e3o foi poss\u00edvel ativar a pessoa no protocolo", (Throwable)ex);
        }
    }
}

