/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.resource;

import br.com.elotech.portaltransparencia.comprasportal.domain.dto.EntidadeComprasDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.enums.TipoContratoMatoGrosso;
import br.com.elotech.portaltransparencia.comprasportal.domain.enums.TipoContratoPadraoEstados;
import br.com.elotech.portaltransparencia.comprasportal.service.impl.EntidadeComprasService;
import java.util.Arrays;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tipos-contratos"})
public class TipoContratoResource {
    private static final String MATO_GROSSO = "MT";
    private final EntidadeComprasService entidadeComprasService;

    @Autowired
    public TipoContratoResource(EntidadeComprasService entidadeComprasService) {
        this.entidadeComprasService = entidadeComprasService;
    }

    @GetMapping
    public ResponseEntity<?> getTiposContrato(@RequestHeader(value="entidade") Long id) {
        EntidadeComprasDTO entidade = this.entidadeComprasService.findOne(id);
        if (Objects.nonNull(entidade) && MATO_GROSSO.equalsIgnoreCase(entidade.getUf())) {
            return ResponseEntity.ok((Object)TipoContratoMatoGrosso.values());
        }
        return ResponseEntity.ok(Arrays.stream(TipoContratoPadraoEstados.values()).filter(tipoContrato -> tipoContrato.allowedUF(Objects.nonNull(entidade) ? entidade.getUf() : "")));
    }
}

