/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.ResponsavelDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.ResponsavelRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindContratoParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindResponsavelParams;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class ResponsavelRepositoryImpl
implements ResponsavelRepository {
    private static final String RESPONSAVEIS = "db/sql/compras/responsaveis.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public ResponsavelRepositoryImpl(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public List<ResponsavelDTO> findResponsaveis(FindContratoParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)RESPONSAVEIS));
        sql.append(" WHERE A.EXERCICIOCONTRATO = :exercicio ").append(" AND A.ENTIDADE = :entidade ").append(" AND A.CONTRATO = :contrato ");
        return this.datasourceWrapper.getJdbcTemplate().query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ResponsavelDTO.class));
    }

    public Page<ResponsavelDTO> findAll(FindResponsavelParams params, Pageable pageable) {
        Object sql = FileUtils.readResourceAsString((String)RESPONSAVEIS);
        sql = (String)sql + params.montaWhere();
        Long qtdResponsaveis = this.getQuantidadeResponsaveis((String)sql, params.toJdbcParameter());
        sql = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql, (String)"ORDER BY A.DATAINICIO DESC, A.EXERCICIO DESC, C.OCUPANTE");
        sql = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)sql, (String)this.datasourceWrapper.getPlatform());
        List responsaveis = this.datasourceWrapper.getJdbcTemplate().query((String)sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ResponsavelDTO.class));
        return new PageImpl(responsaveis, pageable, qtdResponsaveis.longValue());
    }

    private Long getQuantidadeResponsaveis(String query, MapSqlParameterSource params) {
        StringBuilder queryCount = new StringBuilder("SELECT COUNT(*) FROM (");
        queryCount.append(query);
        queryCount.append(") COUNT");
        return (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(queryCount.toString(), (SqlParameterSource)params, Long.class);
    }
}

