/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.AtaLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.CertidaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.CotacaoArquivoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.CotacaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.LicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.LicitacaoSeiDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.MidiaLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.ParecerDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.PrecoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.PublicacaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.RecursoArquivoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.RecursoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.LicitacaoRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindExercicioParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindLicitacaoParams;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class LicitacaoRepositoryImpl
implements LicitacaoRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(LicitacaoRepositoryImpl.class);
    private static final String LICITACOES = "db/sql/compras/licitacoes.sql";
    private static final String LICITACOES_COUNT = "db/sql/compras/licitacoes_count.sql";
    private static final String LICITACAO = "db/sql/compras/licitacao.sql";
    private static final String PARECERES = "db/sql/compras/pareceres.sql";
    private static final String COTACOES = "db/sql/compras/cotacoes.sql";
    private static final String MIDIAS = "db/sql/compras/midias.sql";
    private static final String PUBLICACOES = "db/sql/compras/publicacoes.sql";
    private static final String ATASLICITACAO = "db/sql/compras/atasLicitacao.sql";
    private static final String ATASREGISTROPRECO = "db/sql/compras/atasRegistroPreco.sql";
    private static final String ATASSESSAOPREGAO = "db/sql/compras/atasSessaoPregao.sql";
    private static final String CERTIDOES = "db/sql/compras/certidoes.sql";
    private static final String PRECOS = "db/sql/compras/precos.sql";
    private static final String ULTIMA_ATUALIZACAO = "db/sql/compras/ultimaAtualizacaoLicitacao.sql";
    private static final String RECURSOS = "db/sql/compras/recursos.sql";
    private static final String RECURSOARQUIVOS = "db/sql/compras/recursoArquivos.sql";
    private static final String LISTAARQUIVOS = "db/sql/compras/listaArquivos.sql";
    private static final String NUMEROSEI = "db/sql/compras/numeroSei.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public LicitacaoRepositoryImpl(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public Page<LicitacaoDTO> findLicitacoes(FindLicitacaoParams params, Pageable pageable) {
        StringBuilder where = new StringBuilder(" ");
        if (Objects.isNull(params.getIgnoraExercicioLogado()) || !Boolean.TRUE.equals(params.getIgnoraExercicioLogado())) {
            where.append(" AND L.EXERCICIO = :exercicio ");
        }
        if (params.getDataAberturaMaior().isPresent()) {
            where = new StringBuilder(" AND L.DATAABERTURA >= :dataAberturaMaior ");
        }
        if (Boolean.FALSE.equals(params.getIgnoraEntidadeLogada()) && Objects.nonNull(params.getEntidade())) {
            where.append(" AND L.ENTIDADE = :entidade ");
        }
        String sqlCount = FileUtils.readResourceAsString((String)LICITACOES_COUNT) + where;
        String sql = FileUtils.readResourceAsString((String)LICITACOES) + where;
        StringBuilder query = params.filtrosLicitacao(sql, this.datasourceWrapper.getPlatform());
        String queryOrder = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)query.toString(), (String)" ORDER BY L.DATAABERTURA DESC, L.NUMEROLICITACAO DESC ");
        sql = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)queryOrder, (String)this.datasourceWrapper.getPlatform());
        this.consoleLogger(params, sql);
        List licitacoes = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(LicitacaoDTO.class));
        StringBuilder queryCount = params.filtrosLicitacao(sqlCount, this.datasourceWrapper.getPlatform());
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(queryCount.toString(), (SqlParameterSource)params.toJdbcParameter(), Long.class);
        return new PageImpl(licitacoes, pageable, total.longValue());
    }

    private void consoleLogger(FindLicitacaoParams params, String sql) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(sql);
            LOGGER.debug(params.toString());
        }
    }

    public LicitacaoDTO findLicitacao(FindLicitacaoParams params) {
        String sql = FileUtils.readResourceAsString((String)LICITACAO);
        if (params.getLicitacao().isPresent()) {
            sql = sql.concat(" AND L.LICITACAO = :licitacao ");
        }
        if (params.getNumeroLicitacao().isPresent()) {
            sql = sql.concat(" AND L.NUMEROLICITACAO = :numeroLicitacao ");
        }
        this.consoleLogger(params, sql);
        return (LicitacaoDTO)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(LicitacaoDTO.class));
    }

    public List<ParecerDTO> findPareceres(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)PARECERES).replace("schema_eloarquivo", nomeSchemaEloArquivo);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ParecerDTO.class));
    }

    public List<CotacaoLicitacaoDTO> findCotacoes(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)COTACOES).replace("schema_eloarquivo", nomeSchemaEloArquivo);
        this.consoleLogger(params, sql);
        String sqlArquivos = FileUtils.readResourceAsString((String)LISTAARQUIVOS).replace("schema_eloarquivo", nomeSchemaEloArquivo);
        List cotacoes = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(CotacaoLicitacaoDTO.class));
        cotacoes.forEach(cotacaoLicitacaoDTO -> {
            MapSqlParameterSource paramsWhere = new MapSqlParameterSource();
            paramsWhere.addValue("idchave", (Object)String.format("C%d-%d-%d-%d", params.getEntidade(), params.getExercicio(), cotacaoLicitacaoDTO.getCotacao(), cotacaoLicitacaoDTO.getPessoa()), 12);
            cotacaoLicitacaoDTO.setArquivos(this.datasourceWrapper.getJdbcTemplate().query(sqlArquivos, (SqlParameterSource)paramsWhere, (RowMapper)new ElotechBeanPropertyRowMapper(CotacaoArquivoDTO.class)));
        });
        return cotacoes;
    }

    public List<MidiaLicitacaoDTO> findMidia(FindLicitacaoParams params) {
        String sql = FileUtils.readResourceAsString((String)MIDIAS);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new BeanPropertyRowMapper(MidiaLicitacaoDTO.class));
    }

    public List<LicitacaoSeiDTO> findSei(FindLicitacaoParams params) {
        String sql = FileUtils.readResourceAsString((String)NUMEROSEI);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new BeanPropertyRowMapper(LicitacaoSeiDTO.class));
    }

    public List<PublicacaoLicitacaoDTO> findPublicacoes(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)PUBLICACOES).replaceAll("schema_eloarquivo", nomeSchemaEloArquivo);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(PublicacaoLicitacaoDTO.class));
    }

    public List<AtaLicitacaoDTO> findAtasRegistroPreco(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)ATASREGISTROPRECO).replaceAll("schema_eloarquivo", nomeSchemaEloArquivo);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(AtaLicitacaoDTO.class));
    }

    public List<AtaLicitacaoDTO> findAtasLicitacao(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)ATASLICITACAO).replaceAll("schema_eloarquivo", nomeSchemaEloArquivo);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(AtaLicitacaoDTO.class));
    }

    public List<AtaLicitacaoDTO> findAtasSessaoPregao(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)ATASSESSAOPREGAO).replaceAll("schema_eloarquivo", nomeSchemaEloArquivo);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(AtaLicitacaoDTO.class));
    }

    public List<CertidaoLicitacaoDTO> findCertidoes(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)CERTIDOES).replace("schema_eloarquivo", nomeSchemaEloArquivo);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(CertidaoLicitacaoDTO.class));
    }

    public List<PrecoLicitacaoDTO> findPrecos(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)PRECOS).replace("schema_eloarquivo", nomeSchemaEloArquivo);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(PrecoLicitacaoDTO.class));
    }

    public List<RecursoLicitacaoDTO> findRecursos(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)RECURSOS);
        String sqlArquivos = FileUtils.readResourceAsString((String)RECURSOARQUIVOS).replace("schema_eloarquivo", nomeSchemaEloArquivo);
        List recursos = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(RecursoLicitacaoDTO.class));
        for (RecursoLicitacaoDTO recurso : recursos) {
            MapSqlParameterSource paramsWhere = new MapSqlParameterSource();
            paramsWhere.addValue("idchave", (Object)String.format("R%s", recurso.getId()), 12);
            recurso.getArquivos().addAll(this.datasourceWrapper.getJdbcTemplate().query(sqlArquivos, (SqlParameterSource)paramsWhere, (RowMapper)new ElotechBeanPropertyRowMapper(RecursoArquivoDTO.class)));
        }
        return recursos;
    }

    public List<UltimaAtualizacaoDTO> findUltimaAtualizacao(FindExercicioParams params) {
        String sql = FileUtils.readResourceAsString((String)ULTIMA_ATUALIZACAO);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(UltimaAtualizacaoDTO.class));
    }
}

