/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.AutorizacaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.AutorizacaoRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindAutorizacaoParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindLicitacaoParams;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class AutorizacaoRepositoryImpl
implements AutorizacaoRepository {
    private static final String AUTORIZACOES = "db/sql/compras/autorizacoes.sql";
    private static final String AUTORIZACAO = "db/sql/compras/autorizacao.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public AutorizacaoRepositoryImpl(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public List<AutorizacaoLicitacaoDTO> findAutorizacoes(FindLicitacaoParams params) {
        String sql = FileUtils.readResourceAsString((String)AUTORIZACOES);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(AutorizacaoLicitacaoDTO.class));
    }

    public AutorizacaoLicitacaoDTO findAutorizacao(FindAutorizacaoParams params) {
        String sql = FileUtils.readResourceAsString((String)AUTORIZACAO);
        return (AutorizacaoLicitacaoDTO)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(AutorizacaoLicitacaoDTO.class));
    }
}

