/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.folhapagamento.client.IntegracaoFolhaPortalTransparenciaClient;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaAtoDTO;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaCargoDTO;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaCargoViewDTO;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaPlanoSalarialDTO;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.CargoParamsConverter;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.LeisAtosDTOConverter;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.LeisAtosNaturezaDTOConverter;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.LeisAtosParamsConverter;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.PlanoSalarialParamsConverter;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.CargoParams;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.PlanoSalarialParams;
import br.com.elotech.portaltransparencia.contabportal.domain.Parametro;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LeisAtosDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LeisAtosNaturezaDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.impl.ParametroRepositoryImpl;
import br.com.elotech.portaltransparencia.contabportal.resource.params.LeisAtosParams;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class IntegracaoAiseOxyFolhaPagamentoService {
    private final ParametroRepositoryImpl parametroRepository;
    private final IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient;

    public boolean isParametroHabilitado(Long entidade, Long exercicio) {
        Parametro parametro = this.parametroRepository.findByEntidadeExercicioModuloAndCodigo(entidade, exercicio, ModuloEnum.MODULO_SISCOP.getValue(), Parametros.PARAM_HABILITA_INTEGRACAO_OXYFOLHA);
        return Objects.nonNull(parametro) && SimNao.SIM.getSigla().equalsIgnoreCase(parametro.getValor());
    }

    public List<PortalTransparenciaCargoDTO> getCargos(CargoParams params) {
        if (!this.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            return new ArrayList<PortalTransparenciaCargoDTO>();
        }
        return this.integracaoFolhaPortalTransparenciaClient.getCargos(CargoParamsConverter.toFiltroDTO((CargoParams)params));
    }

    public LeisAtosDTO findAto(LeisAtosParams params) {
        if (params.getId().isPresent() && this.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            return LeisAtosDTOConverter.toPortalTransparenciaFiltroAtosDTO((PortalTransparenciaAtoDTO)this.integracaoFolhaPortalTransparenciaClient.findAto((Long)params.getId().get()));
        }
        return null;
    }

    public Page<PortalTransparenciaCargoDTO> findAllCargos(CargoParams params, Pageable pageable) {
        if (!this.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            return new PageImpl(new ArrayList(), pageable, 0L);
        }
        EloPage cargos = this.integracaoFolhaPortalTransparenciaClient.findAllCargos(CargoParamsConverter.toFiltroDTO((CargoParams)params), pageable);
        return new PageImpl(cargos.getContent(), pageable, cargos.getTotalElements());
    }

    public Page<PortalTransparenciaPlanoSalarialDTO> findAllPlanoSalarial(PlanoSalarialParams params, Pageable pageable) {
        if (!this.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            return new PageImpl(new ArrayList(), pageable, 0L);
        }
        EloPage planos = this.integracaoFolhaPortalTransparenciaClient.findAllPlanoSalarial(PlanoSalarialParamsConverter.toFiltroPlanoSalarialDTO((PlanoSalarialParams)params), pageable);
        return new PageImpl(planos.getContent(), pageable, planos.getTotalElements());
    }

    public List<PortalTransparenciaCargoViewDTO> getMatrizVigente(CargoParams params) {
        if (!this.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            return new ArrayList<PortalTransparenciaCargoViewDTO>();
        }
        return this.integracaoFolhaPortalTransparenciaClient.getCargoMatrizVigente(CargoParamsConverter.toFiltroDTO((CargoParams)params));
    }

    public Page<LeisAtosDTO> findAtos(LeisAtosParams params, Pageable pageable) {
        if (!this.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            return new PageImpl(new ArrayList(), pageable, 0L);
        }
        EloPage atos = this.integracaoFolhaPortalTransparenciaClient.findAtos(LeisAtosParamsConverter.toPortalTransparenciaFiltroAtosDTO((LeisAtosParams)params), pageable);
        return new PageImpl(atos.getContent().stream().map(LeisAtosDTOConverter::toPortalTransparenciaFiltroAtosDTO).collect(Collectors.toList()), pageable, atos.getTotalElements());
    }

    public List<LeisAtosNaturezaDTO> findNaturezas(LeisAtosParams params) {
        if (!this.isParametroHabilitado(params.getEntidade(), params.getExercicio())) {
            return Collections.emptyList();
        }
        return this.integracaoFolhaPortalTransparenciaClient.findAllTiposAtos().stream().map(LeisAtosNaturezaDTOConverter::toDTO).collect(Collectors.toList());
    }

    @Generated
    public IntegracaoAiseOxyFolhaPagamentoService(ParametroRepositoryImpl parametroRepository, IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient) {
        this.parametroRepository = parametroRepository;
        this.integracaoFolhaPortalTransparenciaClient = integracaoFolhaPortalTransparenciaClient;
    }
}

