/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.portaltransparencia.aiseportal.domain.ObraAcompanhamentoImagem;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.MedicaoObraDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ObraDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ObraEmpenhoPortalDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ObraOrdemServicoArquivoDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.PlanilhaObraDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.enums.SituacaoObra;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.FindObraParams;
import br.com.elotech.portaltransparencia.aiseportal.service.ObraService;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/obras"})
@CrossOrigin
public class ObraResource {
    private final ObraService obraService;
    private final BaseExport baseExport;
    private final ElotechProperties elotechProperties;
    private final EntidadeContabilidadeRepository entidadeRepository;

    @Autowired
    public ObraResource(ObraService obraService, BaseExport baseExport, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeRepository) {
        this.obraService = obraService;
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
        this.entidadeRepository = entidadeRepository;
    }

    @GetMapping
    public ResponseEntity<Page<ObraDTO>> findObras(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid FindObraParams findObraParams, Pageable pageable) {
        return ResponseEntity.ok((Object)this.obraService.findObras(findObraParams, pageable));
    }

    @GetMapping(value={"/report"})
    public ModelAndView findObrasExport(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="apenasParalisadas", required=false) Boolean reqApenasParalisadas, @Valid FindObraParams findObraParams, Pageable pageable) throws Throwable {
        int[] fieldTab;
        float[] fieldsPerc;
        boolean apenasParalisadas = Boolean.TRUE.equals(reqApenasParalisadas);
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page page = this.obraService.findObras(findObraParams, (Pageable)pageRequest);
        Entidade entidade = (Entidade)this.entidadeRepository.findOne((Object)findObraParams.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidade.getNome());
        reportParam.setReportTitle(apenasParalisadas ? "Obras Paralisada" : "Obras P\u00fablicas");
        reportParam.setClazzDTO(ObraDTO.class);
        if (apenasParalisadas) {
            reportParam.setHeaderFields("O.S/Ano,Situa\u00e7\u00e3o,Data,Prev T\u00e9rmino,Data Paralisa\u00e7\u00e3o,Motivo Paralisa\u00e7\u00e3o,Prev Rein\u00edcio,Fiscal Respons\u00e1vel,Empresa");
            reportParam.setFields("displayOrdemServico,displaySituacao,data,previsaoTermino,acompData,acompMotivo,acompPrevisaoReinicio,acompResponsavelNome,empresa");
            fieldsPerc = new float[]{0.7f, 0.7f, 0.7f, 0.7f, 0.9f, 2.1f, 0.7f, 1.5f, 1.5f};
            fieldTab = new int[]{50, 50, 50, 50, 100, 450, 50, 200, 200};
        } else {
            reportParam.setHeaderFields("O.S/Ano,Bem(Imovel),Interven\u00e7\u00e3o,Empresa,In\u00edcio,Valor O.S.,Valor Contrato,Situa\u00e7\u00e3o,Medi\u00e7\u00f5es,Objeto");
            reportParam.setFields("displayOrdemServico,descricaoBem,descricao,empresa,data,valorIntervencao,valorContrato,displaySituacao,percentual,objeto");
            fieldsPerc = new float[]{0.7f, 1.2f, 1.2f, 1.0f, 0.7f, 0.7f, 0.7f, 0.7f, 0.7f, 2.4f};
            fieldTab = new int[]{50, 200, 200, 100, 20, 20, 20, 50, 10, 500};
        }
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(page);
        reportParam.setFontSize(6.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(findObraParams.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    @GetMapping(params={"entidade", "exercicioObra", "idOrdemServico"})
    public ResponseEntity<ObraDTO> findObra(FindObraParams findObraParams) {
        return ResponseEntity.ok((Object)this.obraService.findObra(findObraParams));
    }

    @GetMapping(params={"idOxy"})
    public ResponseEntity<ObraDTO> findObraByIdOxy(FindObraParams findObraParams) {
        return ResponseEntity.ok((Object)this.obraService.findObra(findObraParams));
    }

    @GetMapping(value={"/situacoes"})
    public ResponseEntity<SituacaoObra[]> loadSituacoes() {
        return ResponseEntity.ok((Object)SituacaoObra.values());
    }

    @GetMapping(value={"/medicoes"})
    public ResponseEntity<List<MedicaoObraDTO>> findMedicoes(FindObraParams findObraParams) {
        return ResponseEntity.ok((Object)this.obraService.findMedicoes(findObraParams));
    }

    @GetMapping(value={"/ordens-arquivos"})
    public ResponseEntity<List<ObraOrdemServicoArquivoDTO>> findObraOrdemServicoArquivos(FindObraParams findObraParams) {
        return ResponseEntity.ok((Object)this.obraService.findObraOrdemServicoArquivos(findObraParams));
    }

    @GetMapping(value={"/planilhas"})
    public ResponseEntity<List<PlanilhaObraDTO>> findPlanilhas(FindObraParams findObraParams) {
        return ResponseEntity.ok((Object)this.obraService.findPlanilhas(findObraParams));
    }

    @GetMapping(value={"/ultimas-atualizacoes"})
    public ResponseEntity<List<UltimaAtualizacaoDTO>> findUltimaAtualizacao() {
        List findUltimaAtualizacao = this.obraService.findUltimaAtualizacao();
        return ResponseEntity.ok((Object)findUltimaAtualizacao);
    }

    @GetMapping(value={"/empenhos"})
    public List<ObraEmpenhoPortalDTO> getEmpenhosObras(FindObraParams params) {
        return this.obraService.getEmpenhosObras(params);
    }

    @GetMapping(value={"/medicoes/arquivos"})
    public List<ObraAcompanhamentoImagem> findArquivosMedicao(FindObraParams params) {
        return this.obraService.findArquivosMedicao(params);
    }
}

