/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.CedidoDTO;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.FindCedidoParams;
import br.com.elotech.portaltransparencia.aiseportal.service.CedidoService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/cedidos"})
@CrossOrigin
public class CedidoResource {
    private final CedidoService service;
    private final ElotechProperties elotechProperties;

    @Autowired
    public CedidoResource(CedidoService service, ElotechProperties elotechProperties) {
        this.service = service;
        this.elotechProperties = elotechProperties;
    }

    @GetMapping
    public ResponseEntity<Page<CedidoDTO>> findCedidos(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid FindCedidoParams params, Pageable pageable) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.service.findCedidos(params, pageable));
    }

    @GetMapping(value={"/report"})
    public ModelAndView findCedidosExport(HttpServletRequest request, HttpServletResponse response, @Valid FindCedidoParams params, Pageable pageable) throws Throwable {
        return this.service.exportReport(request, response, params, pageable, this.elotechProperties.getReport().getMaximoRegistros().intValue());
    }
}

