CREATE TABLE SISCOP.lg_pessoa
(
  pessoa double precision NOT NULL,
  nome character varying(100),
  apelido character varying(50),
  cpf character varying(15),
  rg character varying(15),
  orgaoemissor character varying(6),
  datanasc timestamp,
  cargo character varying(20),
  servidor character(1),
  partido double precision,
  foto varchar(2000),
  email character varying(50),
  datacadastro timestamp,
  dataalteracao timestamp,
  telefone character varying(15),
  CONSTRAINT pk_pessoa PRIMARY KEY (pessoa)
);

CREATE TABLE SISCOP.lg_tipodocumento (
  id DOUBLE PRECISION NOT NULL,
  descricao varchar(4000),
  CONSTRAINT pk_tipodoc PRIMARY KEY (id)
);

CREATE TABLE SISCOP.lg_modelodocumento (
  numero       DOUBLE PRECISION NOT NULL,
  descricao    VARCHAR(4000),
  modelo       BYTEA,
  CONSTRAINT pk_moddoc PRIMARY KEY (numero)
);

CREATE TABLE SISCOP.lg_documento (
  tipo         DOUBLE PRECISION NOT NULL,
  numero       DOUBLE PRECISION NOT NULL,
  ano          DOUBLE PRECISION NOT NULL,
  descricao    VARCHAR(4000),
  data         TIMESTAMP,
  destinatario DOUBLE PRECISION,
  resumo       BYTEA,
  texto        BYTEA,
  assinante    DOUBLE PRECISION,
  modelo       DOUBLE PRECISION,
  CONSTRAINT pk_documento PRIMARY KEY (numero, ano, tipo),
  CONSTRAINT fk_docdest FOREIGN KEY (destinatario) REFERENCES lg_pessoa(pessoa),
  CONSTRAINT fk_docassinante FOREIGN KEY (assinante) REFERENCES lg_pessoa(pessoa),
  CONSTRAINT fk_doctpdoc FOREIGN KEY (tipo) REFERENCES lg_tipodocumento(id),
  CONSTRAINT fk_docmodelo FOREIGN KEY (modelo) REFERENCES lg_modelodocumento(numero)
);

CREATE TABLE SISCOP.lg_temp
(
  id     DOUBLE PRECISION,
  numero DOUBLE PRECISION,
  tipo   DOUBLE PRECISION,
  ano    DOUBLE PRECISION,
  texto1 VARCHAR(4000),
  texto2 VARCHAR(4000),
  texto3 VARCHAR(4000),
  texto4 VARCHAR(4000),
  texto5 VARCHAR(4000),
  texto6 VARCHAR(4000),
  texto7 VARCHAR(4000),
  texto8 VARCHAR(4000),
  texto9 VARCHAR(4000),
  texto10 VARCHAR(4000)
);

CREATE TABLE SISCOP.lg_tipodiario (
  id DOUBLE PRECISION NOT NULL,
  descricao VARCHAR(150),
  CONSTRAINT pk_tipodiario PRIMARY KEY (id)
);

INSERT INTO SISCOP.LG_TIPODIARIO (ID, DESCRICAO) VALUES (1, 'Ordinária');

INSERT INTO SISCOP.LG_TIPODIARIO (ID, DESCRICAO) VALUES (2, 'Suplementar');

CREATE TABLE SISCOP.lg_diariooficial (
  numero            DOUBLE PRECISION NOT NULL,
  tipo              DOUBLE PRECISION NOT NULL,
  ano               DOUBLE PRECISION NOT NULL,
  descricao         VARCHAR(4000),
  data              TIMESTAMP,
  datapublicacao    TIMESTAMP,
  situacao          VARCHAR(1),
  arquivo           BYTEA,
  responsavel       DOUBLE PRECISION,
  usuariopublicacao VARCHAR(150),
  CONSTRAINT pk_diariooficial PRIMARY KEY (numero, tipo, ano),
  CONSTRAINT fk_diario_resp FOREIGN KEY (responsavel) REFERENCES lg_pessoa(pessoa),
  CONSTRAINT fk_diario_tipo FOREIGN KEY (tipo) REFERENCES lg_tipodiario(id)
);

CREATE TABLE SISCOP.lg_documento_diariooficial (
  numerodocumento DOUBLE PRECISION NOT NULL,
  tipodocumento   DOUBLE PRECISION NOT NULL,
  anodocumento    DOUBLE PRECISION NOT NULL,
  numerodiario    DOUBLE PRECISION NOT NULL,
  tipodiario      DOUBLE PRECISION NOT NULL,
  anodiario       DOUBLE PRECISION NOT NULL,
  CONSTRAINT pk_doc_diario PRIMARY KEY (tipodocumento, numerodocumento, anodocumento, numerodiario, tipodiario, anodiario),
  CONSTRAINT fk_docdia_doc FOREIGN KEY (tipodocumento, numerodocumento, anodocumento) REFERENCES lg_documento(tipo, numero, ano),
  CONSTRAINT fk_docdia_diario FOREIGN KEY (numerodiario, tipodiario, anodiario) REFERENCES lg_diariooficial(numero, tipo, ano)
);