/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource.params;

import br.com.elotech.core.utils.StringUtils;
import java.sql.Date;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class LiquidacaoParams {
    private Long id;
    private Long entidade;
    private Long exercicio;
    private String cnpjCpf;
    private String nome;
    private String notaFiscal;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataInicial;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataFinal;
    private String exportType;
    private String tipo;
    private String order;
    private Long empenho;
    private Long empenhoExercicio;
    private Boolean isPorExercicio;
    private Boolean isPendentes;
    private Boolean isSomentePagos = Boolean.FALSE;
    private Boolean isSomenteComOrdemPagamento = Boolean.FALSE;
    private Boolean isSomenteComOrdensNaoCanceladas = Boolean.FALSE;
    private Long noOrdem;
    private Long sequencia;
    private Long liquidacao;
    private String isCovid;
    private String isFundeb;
    private String fonteRecurso;
    private String tipoContrato;
    private String tipoContratoContabil;

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        if (Objects.nonNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
        if (Objects.nonNull(this.exercicio)) {
            params.addValue("exercicio", (Object)this.exercicio, 2);
        }
        if (Objects.nonNull(this.dataInicial)) {
            params.addValue("dataInicial", (Object)Date.valueOf(this.dataInicial), 91);
        }
        if (Objects.nonNull(this.dataFinal)) {
            params.addValue("dataFinal", (Object)Date.valueOf(this.dataFinal), 91);
        }
        if (Objects.nonNull(this.empenhoExercicio)) {
            params.addValue("empenhoExercicio", (Object)this.empenhoExercicio, 2);
        }
        if (Objects.nonNull(this.noOrdem)) {
            params.addValue("noOrdem", (Object)this.noOrdem, 2);
        }
        if (Objects.nonNull(this.sequencia)) {
            params.addValue("sequencia", (Object)this.sequencia, 2);
        }
        return params;
    }

    public Optional<String> getNome() {
        return Optional.ofNullable(this.nome);
    }

    public Optional<String> getCnpjCpf() {
        return Optional.ofNullable(StringUtils.somenteNumeros((String)this.cnpjCpf));
    }

    public Optional<Long> getExercicio() {
        return Optional.ofNullable(this.exercicio);
    }

    public Optional<Long> getEntidade() {
        return Optional.ofNullable(this.entidade);
    }

    public Optional<Long> getEmpenho() {
        return Optional.ofNullable(this.empenho);
    }

    public Optional<String> getFonteRecurso() {
        return Optional.ofNullable(this.fonteRecurso);
    }

    public Optional<Long> getEmpenhoExercicio() {
        return Optional.ofNullable(this.empenhoExercicio);
    }

    public Optional<String> getTipoContrato() {
        return Optional.ofNullable(this.tipoContrato);
    }

    public Optional<String> getTipoContratoContabil() {
        return Optional.ofNullable(this.tipoContratoContabil);
    }

    public LocalDate getDataInicial() {
        return this.dataInicial;
    }

    public LocalDate getDataFinal() {
        return this.dataFinal;
    }

    public Optional<Long> getNoOrdem() {
        return Optional.ofNullable(this.noOrdem);
    }

    public Optional<Long> getSequencia() {
        return Optional.ofNullable(this.sequencia);
    }

    public Boolean getIsPorExercicio() {
        return BooleanUtils.isTrue((Boolean)this.isPorExercicio);
    }

    public Boolean getIsPendentes() {
        return BooleanUtils.isTrue((Boolean)this.isPendentes);
    }

    public Boolean getIsSomentePagos() {
        return BooleanUtils.isTrue((Boolean)this.isSomentePagos);
    }

    public Boolean getIsSomenteComOrdemPagamento() {
        return BooleanUtils.isTrue((Boolean)this.isSomenteComOrdemPagamento);
    }

    public Boolean getIsSomenteComOrdensNaoCanceladas() {
        return BooleanUtils.isTrue((Boolean)this.isSomenteComOrdensNaoCanceladas);
    }

    public final boolean filtrarPorEmpenhosPendentes() {
        return this.getIsPorExercicio() == false && this.getIsPendentes() != false && this.getExercicio().isPresent();
    }

    public final boolean filtrarPorExercicioDoEmpenho() {
        return this.getIsPendentes() == false && this.getIsPorExercicio() != false && this.getExercicio().isPresent();
    }

    @Generated
    public LiquidacaoParams() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getNotaFiscal() {
        return this.notaFiscal;
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @Generated
    public String getTipo() {
        return this.tipo;
    }

    @Generated
    public String getOrder() {
        return this.order;
    }

    @Generated
    public Long getLiquidacao() {
        return this.liquidacao;
    }

    @Generated
    public String getIsCovid() {
        return this.isCovid;
    }

    @Generated
    public String getIsFundeb() {
        return this.isFundeb;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setNotaFiscal(String notaFiscal) {
        this.notaFiscal = notaFiscal;
    }

    @Generated
    public void setDataInicial(LocalDate dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Generated
    public void setDataFinal(LocalDate dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    @Generated
    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setOrder(String order) {
        this.order = order;
    }

    @Generated
    public void setEmpenho(Long empenho) {
        this.empenho = empenho;
    }

    @Generated
    public void setEmpenhoExercicio(Long empenhoExercicio) {
        this.empenhoExercicio = empenhoExercicio;
    }

    @Generated
    public void setIsPorExercicio(Boolean isPorExercicio) {
        this.isPorExercicio = isPorExercicio;
    }

    @Generated
    public void setIsPendentes(Boolean isPendentes) {
        this.isPendentes = isPendentes;
    }

    @Generated
    public void setIsSomentePagos(Boolean isSomentePagos) {
        this.isSomentePagos = isSomentePagos;
    }

    @Generated
    public void setIsSomenteComOrdemPagamento(Boolean isSomenteComOrdemPagamento) {
        this.isSomenteComOrdemPagamento = isSomenteComOrdemPagamento;
    }

    @Generated
    public void setIsSomenteComOrdensNaoCanceladas(Boolean isSomenteComOrdensNaoCanceladas) {
        this.isSomenteComOrdensNaoCanceladas = isSomenteComOrdensNaoCanceladas;
    }

    @Generated
    public void setNoOrdem(Long noOrdem) {
        this.noOrdem = noOrdem;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setLiquidacao(Long liquidacao) {
        this.liquidacao = liquidacao;
    }

    @Generated
    public void setIsCovid(String isCovid) {
        this.isCovid = isCovid;
    }

    @Generated
    public void setIsFundeb(String isFundeb) {
        this.isFundeb = isFundeb;
    }

    @Generated
    public void setFonteRecurso(String fonteRecurso) {
        this.fonteRecurso = fonteRecurso;
    }

    @Generated
    public void setTipoContrato(String tipoContrato) {
        this.tipoContrato = tipoContrato;
    }

    @Generated
    public void setTipoContratoContabil(String tipoContratoContabil) {
        this.tipoContratoContabil = tipoContratoContabil;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LiquidacaoParams)) {
            return false;
        }
        LiquidacaoParams other = (LiquidacaoParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Optional this$entidade = this.getEntidade();
        Optional other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Optional this$exercicio = this.getExercicio();
        Optional other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Optional this$cnpjCpf = this.getCnpjCpf();
        Optional other$cnpjCpf = other.getCnpjCpf();
        if (this$cnpjCpf == null ? other$cnpjCpf != null : !((Object)this$cnpjCpf).equals(other$cnpjCpf)) {
            return false;
        }
        Optional this$nome = this.getNome();
        Optional other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !((Object)this$nome).equals(other$nome)) {
            return false;
        }
        String this$notaFiscal = this.getNotaFiscal();
        String other$notaFiscal = other.getNotaFiscal();
        if (this$notaFiscal == null ? other$notaFiscal != null : !this$notaFiscal.equals(other$notaFiscal)) {
            return false;
        }
        LocalDate this$dataInicial = this.getDataInicial();
        LocalDate other$dataInicial = other.getDataInicial();
        if (this$dataInicial == null ? other$dataInicial != null : !((Object)this$dataInicial).equals(other$dataInicial)) {
            return false;
        }
        LocalDate this$dataFinal = this.getDataFinal();
        LocalDate other$dataFinal = other.getDataFinal();
        if (this$dataFinal == null ? other$dataFinal != null : !((Object)this$dataFinal).equals(other$dataFinal)) {
            return false;
        }
        String this$exportType = this.getExportType();
        String other$exportType = other.getExportType();
        if (this$exportType == null ? other$exportType != null : !this$exportType.equals(other$exportType)) {
            return false;
        }
        String this$tipo = this.getTipo();
        String other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        String this$order = this.getOrder();
        String other$order = other.getOrder();
        if (this$order == null ? other$order != null : !this$order.equals(other$order)) {
            return false;
        }
        Optional this$empenho = this.getEmpenho();
        Optional other$empenho = other.getEmpenho();
        if (this$empenho == null ? other$empenho != null : !((Object)this$empenho).equals(other$empenho)) {
            return false;
        }
        Optional this$empenhoExercicio = this.getEmpenhoExercicio();
        Optional other$empenhoExercicio = other.getEmpenhoExercicio();
        if (this$empenhoExercicio == null ? other$empenhoExercicio != null : !((Object)this$empenhoExercicio).equals(other$empenhoExercicio)) {
            return false;
        }
        Boolean this$isPorExercicio = this.getIsPorExercicio();
        Boolean other$isPorExercicio = other.getIsPorExercicio();
        if (this$isPorExercicio == null ? other$isPorExercicio != null : !((Object)this$isPorExercicio).equals(other$isPorExercicio)) {
            return false;
        }
        Boolean this$isPendentes = this.getIsPendentes();
        Boolean other$isPendentes = other.getIsPendentes();
        if (this$isPendentes == null ? other$isPendentes != null : !((Object)this$isPendentes).equals(other$isPendentes)) {
            return false;
        }
        Boolean this$isSomentePagos = this.getIsSomentePagos();
        Boolean other$isSomentePagos = other.getIsSomentePagos();
        if (this$isSomentePagos == null ? other$isSomentePagos != null : !((Object)this$isSomentePagos).equals(other$isSomentePagos)) {
            return false;
        }
        Boolean this$isSomenteComOrdemPagamento = this.getIsSomenteComOrdemPagamento();
        Boolean other$isSomenteComOrdemPagamento = other.getIsSomenteComOrdemPagamento();
        if (this$isSomenteComOrdemPagamento == null ? other$isSomenteComOrdemPagamento != null : !((Object)this$isSomenteComOrdemPagamento).equals(other$isSomenteComOrdemPagamento)) {
            return false;
        }
        Boolean this$isSomenteComOrdensNaoCanceladas = this.getIsSomenteComOrdensNaoCanceladas();
        Boolean other$isSomenteComOrdensNaoCanceladas = other.getIsSomenteComOrdensNaoCanceladas();
        if (this$isSomenteComOrdensNaoCanceladas == null ? other$isSomenteComOrdensNaoCanceladas != null : !((Object)this$isSomenteComOrdensNaoCanceladas).equals(other$isSomenteComOrdensNaoCanceladas)) {
            return false;
        }
        Optional this$noOrdem = this.getNoOrdem();
        Optional other$noOrdem = other.getNoOrdem();
        if (this$noOrdem == null ? other$noOrdem != null : !((Object)this$noOrdem).equals(other$noOrdem)) {
            return false;
        }
        Optional this$sequencia = this.getSequencia();
        Optional other$sequencia = other.getSequencia();
        if (this$sequencia == null ? other$sequencia != null : !((Object)this$sequencia).equals(other$sequencia)) {
            return false;
        }
        Long this$liquidacao = this.getLiquidacao();
        Long other$liquidacao = other.getLiquidacao();
        if (this$liquidacao == null ? other$liquidacao != null : !((Object)this$liquidacao).equals(other$liquidacao)) {
            return false;
        }
        String this$isCovid = this.getIsCovid();
        String other$isCovid = other.getIsCovid();
        if (this$isCovid == null ? other$isCovid != null : !this$isCovid.equals(other$isCovid)) {
            return false;
        }
        String this$isFundeb = this.getIsFundeb();
        String other$isFundeb = other.getIsFundeb();
        if (this$isFundeb == null ? other$isFundeb != null : !this$isFundeb.equals(other$isFundeb)) {
            return false;
        }
        Optional this$fonteRecurso = this.getFonteRecurso();
        Optional other$fonteRecurso = other.getFonteRecurso();
        if (this$fonteRecurso == null ? other$fonteRecurso != null : !((Object)this$fonteRecurso).equals(other$fonteRecurso)) {
            return false;
        }
        Optional this$tipoContrato = this.getTipoContrato();
        Optional other$tipoContrato = other.getTipoContrato();
        if (this$tipoContrato == null ? other$tipoContrato != null : !((Object)this$tipoContrato).equals(other$tipoContrato)) {
            return false;
        }
        Optional this$tipoContratoContabil = this.getTipoContratoContabil();
        Optional other$tipoContratoContabil = other.getTipoContratoContabil();
        return !(this$tipoContratoContabil == null ? other$tipoContratoContabil != null : !((Object)this$tipoContratoContabil).equals(other$tipoContratoContabil));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LiquidacaoParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Optional $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Optional $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Optional $cnpjCpf = this.getCnpjCpf();
        result = result * 59 + ($cnpjCpf == null ? 43 : ((Object)$cnpjCpf).hashCode());
        Optional $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : ((Object)$nome).hashCode());
        String $notaFiscal = this.getNotaFiscal();
        result = result * 59 + ($notaFiscal == null ? 43 : $notaFiscal.hashCode());
        LocalDate $dataInicial = this.getDataInicial();
        result = result * 59 + ($dataInicial == null ? 43 : ((Object)$dataInicial).hashCode());
        LocalDate $dataFinal = this.getDataFinal();
        result = result * 59 + ($dataFinal == null ? 43 : ((Object)$dataFinal).hashCode());
        String $exportType = this.getExportType();
        result = result * 59 + ($exportType == null ? 43 : $exportType.hashCode());
        String $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        String $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : $order.hashCode());
        Optional $empenho = this.getEmpenho();
        result = result * 59 + ($empenho == null ? 43 : ((Object)$empenho).hashCode());
        Optional $empenhoExercicio = this.getEmpenhoExercicio();
        result = result * 59 + ($empenhoExercicio == null ? 43 : ((Object)$empenhoExercicio).hashCode());
        Boolean $isPorExercicio = this.getIsPorExercicio();
        result = result * 59 + ($isPorExercicio == null ? 43 : ((Object)$isPorExercicio).hashCode());
        Boolean $isPendentes = this.getIsPendentes();
        result = result * 59 + ($isPendentes == null ? 43 : ((Object)$isPendentes).hashCode());
        Boolean $isSomentePagos = this.getIsSomentePagos();
        result = result * 59 + ($isSomentePagos == null ? 43 : ((Object)$isSomentePagos).hashCode());
        Boolean $isSomenteComOrdemPagamento = this.getIsSomenteComOrdemPagamento();
        result = result * 59 + ($isSomenteComOrdemPagamento == null ? 43 : ((Object)$isSomenteComOrdemPagamento).hashCode());
        Boolean $isSomenteComOrdensNaoCanceladas = this.getIsSomenteComOrdensNaoCanceladas();
        result = result * 59 + ($isSomenteComOrdensNaoCanceladas == null ? 43 : ((Object)$isSomenteComOrdensNaoCanceladas).hashCode());
        Optional $noOrdem = this.getNoOrdem();
        result = result * 59 + ($noOrdem == null ? 43 : ((Object)$noOrdem).hashCode());
        Optional $sequencia = this.getSequencia();
        result = result * 59 + ($sequencia == null ? 43 : ((Object)$sequencia).hashCode());
        Long $liquidacao = this.getLiquidacao();
        result = result * 59 + ($liquidacao == null ? 43 : ((Object)$liquidacao).hashCode());
        String $isCovid = this.getIsCovid();
        result = result * 59 + ($isCovid == null ? 43 : $isCovid.hashCode());
        String $isFundeb = this.getIsFundeb();
        result = result * 59 + ($isFundeb == null ? 43 : $isFundeb.hashCode());
        Optional $fonteRecurso = this.getFonteRecurso();
        result = result * 59 + ($fonteRecurso == null ? 43 : ((Object)$fonteRecurso).hashCode());
        Optional $tipoContrato = this.getTipoContrato();
        result = result * 59 + ($tipoContrato == null ? 43 : ((Object)$tipoContrato).hashCode());
        Optional $tipoContratoContabil = this.getTipoContratoContabil();
        result = result * 59 + ($tipoContratoContabil == null ? 43 : ((Object)$tipoContratoContabil).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LiquidacaoParams(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", cnpjCpf=" + this.getCnpjCpf() + ", nome=" + this.getNome() + ", notaFiscal=" + this.getNotaFiscal() + ", dataInicial=" + this.getDataInicial() + ", dataFinal=" + this.getDataFinal() + ", exportType=" + this.getExportType() + ", tipo=" + this.getTipo() + ", order=" + this.getOrder() + ", empenho=" + this.getEmpenho() + ", empenhoExercicio=" + this.getEmpenhoExercicio() + ", isPorExercicio=" + this.getIsPorExercicio() + ", isPendentes=" + this.getIsPendentes() + ", isSomentePagos=" + this.getIsSomentePagos() + ", isSomenteComOrdemPagamento=" + this.getIsSomenteComOrdemPagamento() + ", isSomenteComOrdensNaoCanceladas=" + this.getIsSomenteComOrdensNaoCanceladas() + ", noOrdem=" + this.getNoOrdem() + ", sequencia=" + this.getSequencia() + ", liquidacao=" + this.getLiquidacao() + ", isCovid=" + this.getIsCovid() + ", isFundeb=" + this.getIsFundeb() + ", fonteRecurso=" + this.getFonteRecurso() + ", tipoContrato=" + this.getTipoContrato() + ", tipoContratoContabil=" + this.getTipoContratoContabil() + ")";
    }
}

