select
	A.ENTIDADE,
	A.EXERCICIO,
	SUM(A.VALORPREVISTO) VALORPLANEJADO,
	SUM(A.VALORPREVISTO + B.VALORSUPLEMENTACAO - B.VALORREDUCAO - B.VALORESTSUPLEMENTACAO + B.VALORESTREDUCAO) VALORPLANEJADOATUALIZADO,
	SUM(B.VALOREMPENHO - B.VALORANULACAOEMPENHO + B.VALORESTANULACAOEMPENHO) VALOREXECUTADO,
	cast(SUBSTR(A.PROGRAMATICA, 15, 4) as VARCHAR(10)) PROJETO,
	cast(SUBSTR(A.PROGRAMATICA, 1, 5) as VARCHAR(10)) UNIDADE,
	cast(SUBSTR(A.PROGRAMATICA, 6, 2) as VARCHAR(10)) FUNCAO,
	cast(SUBSTR(A.PROGRAMATICA, 8, 3) as VARCHAR(10)) SUBFUNCAO,
	cast(SUBSTR(A.PROGRAMATICA, 11, 4) as VARCHAR(10)) PROGRAMA,
	(
	select
		DESCRICAO
	from
		${db.contabilidade.schema}.ORCPARAMETRODESPESA
	where
		ENTIDADE = A.ENTIDADE
		and EXERCICIO = A.EXERCICIO
		and ORDEM = 6
		and CODIGO = SUBSTR(A.PROGRAMATICA,
		15, 4)) DESCRICAOPROJETO
from
	${db.contabilidade.schema}.DESPESA A
join (
	select
		DESPESA.ENTIDADE,
		DESPESA.EXERCICIO,
		DESPESA.PROGRAMATICA,
		DESPESA.FONTERECURSO,
		SUM(DESPESAMENSAL.VALORSUPLEMENTACAO) as VALORSUPLEMENTACAO,
		SUM(DESPESAMENSAL.VALORREDUCAO) as VALORREDUCAO,
		SUM(DESPESAMENSAL.VALOREMPENHO) as VALOREMPENHO,
		SUM(DESPESAMENSAL.VALORANULACAOEMPENHO) as VALORANULACAOEMPENHO,
		SUM(DESPESAMENSAL.VALORESTSUPLEMENTACAO) as VALORESTSUPLEMENTACAO,
		SUM(DESPESAMENSAL.VALORESTREDUCAO) as VALORESTREDUCAO,
		SUM(DESPESAMENSAL.VALORESTANULACAOEMPENHO) as VALORESTANULACAOEMPENHO
	from
		${db.contabilidade.schema}.DESPESAMENSAL DESPESAMENSAL
	join ${db.contabilidade.schema}.DESPESA DESPESA on
		DESPESA.ENTIDADE = DESPESAMENSAL.ENTIDADE
		and DESPESA.EXERCICIO = DESPESAMENSAL.EXERCICIO
		and DESPESA.PROGRAMATICA = DESPESAMENSAL.PROGRAMATICA
		and DESPESA.FONTERECURSO = DESPESAMENSAL.FONTERECURSO
	where
		DESPESA.EXERCICIO between :exercicio - 2 and :exercicio
		and DESPESA.NIVEL = 6
	group by
		DESPESA.ENTIDADE,
		DESPESA.EXERCICIO,
		DESPESA.PROGRAMATICA,
		DESPESA.FONTERECURSO) B on
	A.ENTIDADE = B.ENTIDADE
	and A.EXERCICIO = B.EXERCICIO
	and A.PROGRAMATICA = B.PROGRAMATICA
	and A.FONTERECURSO = B.FONTERECURSO
where
	A.EXERCICIO between :exercicio - 2 and :exercicio
	and A.NIVEL = 6
	$[filtros]
group by
	A.ENTIDADE,
	A.EXERCICIO,
	A.PROGRAMATICA
