/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.ContratoArquivoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.ContratoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.TipoContratoDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.ContratoRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindContratoParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindExercicioParams;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ContratoItensDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class ContratoRepositoryImpl
implements ContratoRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContratoRepositoryImpl.class);
    private static final String WHERE_ENTIDADE = " WHERE A.ENTIDADE = :entidade ";
    private static final String CONTRATOS = "db/sql/compras/contratos.sql";
    private static final String CONTRATOS_ITENS = "db/sql/compras/contratos_itens.sql";
    private static final String CONTRATO_ARQUIVOS = "db/sql/compras/contratos_arquivos.sql";
    private static final String ULTIMA_ATUALIZACAO = "db/sql/compras/ultimaAtualizacaoContrato.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public ContratoRepositoryImpl(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public Page<ContratoDTO> findContratos(FindContratoParams params, Pageable pageable) {
        String sql = FileUtils.readResourceAsString((String)CONTRATOS);
        StringBuilder query = new StringBuilder(sql);
        this.condicaoContratos(params, query);
        this.filtro(params, query);
        StringBuilder queryCount = new StringBuilder("");
        queryCount.append("SELECT COUNT(*) FROM (");
        queryCount.append((CharSequence)query);
        queryCount.append(") X");
        String queryOrder = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)query.toString(), (String)"ORDER BY A.EXERCICIO DESC, A.NUMEROCONTRATO DESC");
        sql = SqlUtils.aplicaPaginacaoRowNumber((Pageable)pageable, (String)queryOrder, (String)"R.EXERCICIO DESC, R.NUMEROCONTRATO DESC", (String)this.datasourceWrapper.getPlatform());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(sql);
            LOGGER.debug(queryCount.toString());
            LOGGER.debug(params.toString());
        }
        MapSqlParameterSource parameter = params.toJdbcParameter();
        List contratos = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ContratoDTO.class));
        for (ContratoDTO contratoDTO : contratos) {
            contratoDTO.setDisplayContrato(String.format("%d/%d", contratoDTO.getNumeroContrato(), contratoDTO.getExercicio()));
            contratoDTO.setDisplayTipoContrato(contratoDTO.getTipoContrato());
            if (!contratoDTO.possuiNumeroLicitacao().booleanValue()) continue;
            contratoDTO.setDisplayLicitacao(String.format("%d/%d", contratoDTO.getNumeroLicitacao(), contratoDTO.getExercicioLicitacao()));
        }
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(queryCount.toString(), (SqlParameterSource)parameter, Long.class);
        return new PageImpl(contratos, pageable, total.longValue());
    }

    private void condicaoContratos(FindContratoParams params, StringBuilder query) {
        if (Objects.nonNull(params.getEntidade())) {
            query.append(WHERE_ENTIDADE).append(" AND ");
        } else {
            query.append(" WHERE ");
        }
        query.append(" (A.EXERCICIO = :exercicio ");
        query.append("   OR :exercicio BETWEEN  EXTRACT(YEAR FROM A.INICIOVIGENCIA) AND EXTRACT(YEAR FROM A.VIGENCIA)  )");
    }

    private void filtro(FindContratoParams params, StringBuilder query) {
        params.getTipoContrato().ifPresent(tipoContrato -> query.append("RA".equalsIgnoreCase((String)tipoContrato) ? " AND ((A.TIPOCONTRATO = :tipoContrato) OR (COALESCE(A.RATEIO, 'N') = 'S')) " : " AND A.TIPOCONTRATO  = :tipoContrato "));
        params.getNumeroContrato().ifPresent(numeroContrato -> query.append(" AND A.NUMEROCONTRATO = :numeroContrato "));
        params.getNome().ifPresent(nome -> query.append(" AND  ${db.compras.schema}.tiraacento(LOWER(A.NOME)) LIKE ${db.compras.schema}.tiraacento(LOWER(:nome)) "));
        params.getTipoLicitacao().ifPresent(tipoLicitacao -> query.append(" AND A.TIPOLICITACAO  = :tipoLicitacao "));
        params.getExercicioLicitacao().ifPresent(exercicioLicitacao -> query.append(" AND A.EXERCICIOLICITACAO = :exercicioLicitacao "));
        params.getNumeroLicitacao().ifPresent(numeroLicitacao -> query.append(" AND A.NUMEROLICITACAO = :numeroLicitacao "));
        params.getDataInicialAssinatura().ifPresent(d -> query.append(" AND A.DATAASSINATURA >= :dataInicialAssinatura "));
        params.getDataFinalAssinatura().ifPresent(d -> query.append(" AND A.DATAASSINATURA <= :dataFinalAssinatura "));
        params.getRateio().ifPresent(d -> query.append(" AND A.RATEIO = :rateio "));
        params.getisCovid().ifPresent(d -> query.append(" AND COALESCE(A.MPCOVID19,'N') = 'S' "));
        params.getTipoAto().ifPresent(d -> query.append(" AND A.TIPOATO = :tipoAto "));
        params.getObjeto().ifPresent(objeto -> query.append(SqlUtils.andLike((String)"${db.compras.schema}", (String)"A.OBJETO", (String)objeto)));
        params.getExercicioContrato().ifPresent(exercicio -> query.append("AND A.EXERCICIO = :exercicioContrato"));
    }

    private void consoleLogger(FindContratoParams params, String sql) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(sql);
            LOGGER.debug(params.toString());
        }
    }

    public ContratoDTO findContrato(FindContratoParams params) {
        String sql = FileUtils.readResourceAsString((String)CONTRATOS);
        String query = this.filtroFindOne(params, sql);
        this.consoleLogger(params, query);
        try {
            ContratoDTO contrato = (ContratoDTO)this.datasourceWrapper.getJdbcTemplate().queryForObject(query, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ContratoDTO.class));
            String sqlItens = FileUtils.readResourceAsString((String)CONTRATOS_ITENS);
            MapSqlParameterSource paramsItens = new MapSqlParameterSource();
            paramsItens.addValue("entidade", (Object)contrato.getEntidade(), 2);
            paramsItens.addValue("exercicio", (Object)contrato.getExercicio(), 2);
            paramsItens.addValue("contrato", (Object)contrato.getContrato(), 2);
            contrato.setItens(this.datasourceWrapper.getJdbcTemplate().query(sqlItens, (SqlParameterSource)paramsItens, (RowMapper)new ElotechBeanPropertyRowMapper(ContratoItensDTO.class)));
            return contrato;
        }
        catch (EmptyResultDataAccessException e) {
            return new ContratoDTO();
        }
    }

    public List<ContratoArquivoDTO> findArquivos(FindContratoParams params, String nomeSchemaEloArquivo) {
        String queryContrato = this.filtroFindOne(params, FileUtils.readResourceAsString((String)CONTRATO_ARQUIVOS)).replaceAll("schema_eloarquivo", nomeSchemaEloArquivo);
        StringBuilder query = new StringBuilder(queryContrato);
        query.append(" AND ((P.DATA IS NOT NULL           AND P.DATA = (SELECT MIN(DATA)                           FROM ${db.compras.schema}.CLCONTRATOPUBLICACAO P1                          WHERE P1.ENTIDADE = P.ENTIDADE                            AND P1.EXERCICIO = P.EXERCICIO                            AND P1.CONTRATO = P.CONTRATO)) OR P.DATA IS NULL)");
        query.append(" AND COALESCE(B.ARQUIVOSIGILOSO,'N') <> 'S' ");
        this.consoleLogger(params, query.toString());
        query.append(" ORDER BY C.ID ");
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ContratoArquivoDTO.class));
    }

    private String filtroFindOne(FindContratoParams params, String sql) {
        StringBuilder query = new StringBuilder(sql);
        query.append(WHERE_ENTIDADE);
        params.getExercicio().ifPresent(p -> query.append(" AND A.EXERCICIO = :exercicio "));
        params.getContrato().ifPresent(p -> query.append(" AND A.CONTRATO = :contrato "));
        params.getNumeroContrato().ifPresent(p -> query.append(" AND A.NUMEROCONTRATO = :numeroContrato "));
        params.getIdContrato().ifPresent(p -> query.append(" AND A.IDCONTRATO = :idContrato"));
        params.getNumeroLicitacao().ifPresent(p -> query.append(" AND A.NUMEROLICITACAO = :numeroLicitacao"));
        params.getExercicioLicitacao().ifPresent(p -> query.append(" AND A.EXERCICIOLICITACAO = :exercicioLicitacao"));
        params.getTipoAto().ifPresent(p -> query.append(" AND A.TIPOATO = :tipoAto"));
        return query.toString();
    }

    public List<TipoContratoDTO> findTiposContrato(String uf) {
        StringBuilder query = new StringBuilder();
        query.append(" SELECT DISTINCT c.tipocontrato AS tipoContrato, c.tipocontrato AS siglaTipoContrato, e.unidadefederacao FROM ${db.compras.schema}.clcontrato c ");
        query.append(" JOIN ${db.compras.schema}.entidade e ON e.entidade = c.entidade ");
        query.append(" WHERE e.unidadefederacao = '");
        query.append(uf);
        query.append("' ORDER BY c.tipocontrato ASC ");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(query.toString());
        }
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (RowMapper)new ElotechBeanPropertyRowMapper(TipoContratoDTO.class));
    }

    public List<ContratoDTO> findContratosLicitacao(FindContratoParams params) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)CONTRATOS));
        query.append(" WHERE A.ENTIDADELICITACAO = :entidade ");
        query.append(" AND A.EXERCICIOLICITACAO = :exercicioLicitacao ");
        query.append(" AND A.TIPOLICITACAO = :tipoLicitacao ");
        query.append(" AND A.LICITACAO = :numeroLicitacao ");
        query.append(" AND A.TIPOATO in (1,2) ");
        this.consoleLogger(params, query.toString());
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ContratoDTO.class));
    }

    public ContratoDTO findContratoByIdContrato(FindContratoParams params) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)CONTRATOS));
        query.append(" WHERE A.IDCONTRATO = :contrato ");
        if (Objects.nonNull(params.getEntidade())) {
            query.append(" AND A.ENTIDADE = :entidade ");
        }
        params.getExercicio().ifPresent(item -> query.append(" AND A.EXERCICIO = :exercicio "));
        this.consoleLogger(params, query.toString());
        return (ContratoDTO)this.datasourceWrapper.getJdbcTemplate().queryForObject(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ContratoDTO.class));
    }

    public List<UltimaAtualizacaoDTO> findUltimaAtualizacao(FindExercicioParams params) {
        String sql = FileUtils.readResourceAsString((String)ULTIMA_ATUALIZACAO);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(UltimaAtualizacaoDTO.class));
    }
}

