/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.AjudaCustoDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorAjudaCustoDTO;
import br.com.elotech.portaltransparencia.aiseportal.repository.AjudaCustoRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AjudaCustoParams;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeAiseService;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AjudaCustoRepositoryImpl
implements AjudaCustoRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(AjudaCustoRepositoryImpl.class);
    private static final String FILTRO = "$[FILTRO]";
    private static final String AJUDASCUSTO = "db/sql/aise/ajudasCusto.sql";
    private static final String AJUDACUSTO = "db/sql/aise/ajudaCusto.sql";
    private final EntidadeAiseService entidadeAiseService;
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public AjudaCustoRepositoryImpl(DatasourceWrapper datasourceWrapper, EntidadeAiseService entidadeAiseService) {
        this.datasourceWrapper = datasourceWrapper;
        this.entidadeAiseService = entidadeAiseService;
    }

    public Page<ServidorAjudaCustoDTO> findAjudasCusto(AjudaCustoParams params, Pageable pageable) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        List list = this.fetchServidorAjudaCusto(params, pageable);
        StringBuilder sqlCount = new StringBuilder("SELECT COUNT (*) FROM (");
        sqlCount.append(FileUtils.readResourceAsString((String)AJUDASCUSTO));
        sqlCount = this.addFilter(params, sqlCount);
        sqlCount.append(" ) AJUDASCUSTO");
        LOGGER.debug(sqlCount.toString());
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(sqlCount.toString(), (SqlParameterSource)params.toJdbcParameter(), Long.class);
        return new PageImpl(list, pageable, total.longValue());
    }

    private List<ServidorAjudaCustoDTO> fetchServidorAjudaCusto(AjudaCustoParams params, Pageable pageable) {
        StringBuilder sql = new StringBuilder();
        sql = sql.append(FileUtils.readResourceAsString((String)AJUDASCUSTO));
        sql = this.addFilter(params, sql);
        String query = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql.toString(), (String)" ORDER BY FF.ENTIDADE,P.NOME,FU.MATRICULA,CA.CARGO,CA.DESCRICAO ");
        query = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)query, (String)this.datasourceWrapper.getPlatform());
        LOGGER.debug(query);
        LOGGER.debug(params.toString());
        return this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ServidorAjudaCustoDTO.class));
    }

    private StringBuilder addFilter(AjudaCustoParams params, StringBuilder sql) {
        StringBuilder filtro = new StringBuilder("");
        params.getMatricula().ifPresent(m -> filtro.append("\n  AND FF.MATRICULA = :matricula"));
        params.getNome().ifPresent(n -> filtro.append("\n  AND ${db.aise.schema}.tiraAcento(UPPER(P.NOME)) LIKE ${db.aise.schema}.tiraAcento(UPPER(:nome))"));
        int start = sql.indexOf(FILTRO);
        int end = FILTRO.length();
        return sql.replace(start, start + end, filtro.toString());
    }

    public Page<AjudaCustoDTO> findAjudaCusto(AjudaCustoParams params, Pageable pageable) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        StringBuilder sql = new StringBuilder();
        sql.append(FileUtils.readResourceAsString((String)AJUDACUSTO));
        StringBuilder sqlCount = new StringBuilder();
        sqlCount.append("SELECT COUNT (*) FROM (");
        sqlCount.append(FileUtils.readResourceAsString((String)AJUDACUSTO));
        sqlCount.append(" ) AJUDACUSTO");
        String query = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)sql.toString(), (String)this.datasourceWrapper.getPlatform());
        LOGGER.debug(query);
        LOGGER.debug(params.toString());
        MapSqlParameterSource parameter = params.toJdbcParameter();
        List list = this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(AjudaCustoDTO.class));
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(sqlCount.toString(), (SqlParameterSource)parameter, Long.class);
        return new PageImpl(list, pageable, total.longValue());
    }
}

