/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.portaltransparencia.admportal.repository.PublicacaoRepository;
import br.com.elotech.portaltransparencia.admportal.repository.PublicacaoSubGrupoRepository;
import br.com.elotech.portaltransparencia.contabportal.domain.PublicacaoSubGrupo;
import br.com.elotech.portaltransparencia.contabportal.domain.PublicacaoSubGrupoExercicio;
import br.com.elotech.portaltransparencia.contabportal.repository.PublicacaoSubGrupoExercicioRepository;
import java.time.LocalDateTime;
import java.util.Objects;
import lombok.Generated;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class PublicacaoSubGrupoExercicioService
extends CrudService<PublicacaoSubGrupoExercicio, Long> {
    private final PublicacaoRepository publicacaoRepository;
    private final PublicacaoSubGrupoRepository subGrupoRepository;
    private final PublicacaoSubGrupoExercicioRepository repository;

    protected void beforeSave(PublicacaoSubGrupoExercicio entity, Authentication authentication) {
        PublicacaoSubGrupo subGrupoRelatorio = entity.getSubGrupoRelatorio();
        if (Objects.nonNull(subGrupoRelatorio.getId())) {
            this.subGrupoRepository.findById((Object)subGrupoRelatorio.getId()).ifPresent(publicacaoGrupo -> {
                if (!publicacaoGrupo.getDescricao().equals(subGrupoRelatorio.getDescricao())) {
                    this.validateVinculoDescricaoExists(entity);
                }
            });
        } else {
            this.validateVinculoDescricaoExists(entity);
        }
        entity.setSubGrupoRelatorio(this.findSubGrupoByDescricaoOrCreate(entity.getSubGrupoRelatorio()));
        subGrupoRelatorio.setDataUltimaAtualizacao(LocalDateTime.now());
    }

    private void validateVinculoDescricaoExists(PublicacaoSubGrupoExercicio entity) {
        PublicacaoSubGrupo subGrupoRelatorio = entity.getSubGrupoRelatorio();
        this.repository.findFirstBySubGrupoRelatorioDescricaoAndSubGrupoRelatorioIdGrupoRelatorioAndEntidadeAndExercicio(subGrupoRelatorio.getDescricao(), subGrupoRelatorio.getIdGrupoRelatorio(), entity.getEntidade(), entity.getExercicio()).ifPresent(found -> {
            throw new IllegalArgumentException(String.format("O Sub Grupo [%s] j\u00e1 existe para a Entidade [%s] no Exerc\u00edcio [%s].", subGrupoRelatorio.getDescricao(), entity.getEntidade(), entity.getExercicio()));
        });
    }

    private PublicacaoSubGrupo findSubGrupoByDescricaoOrCreate(PublicacaoSubGrupo entity) {
        return this.subGrupoRepository.findFirstByDescricaoAndIdGrupoRelatorioOrderById(entity.getDescricao(), entity.getIdGrupoRelatorio()).orElseGet(() -> (PublicacaoSubGrupo)this.subGrupoRepository.save((Object)entity));
    }

    protected void beforeDelete(PublicacaoSubGrupoExercicio entity, Authentication authentication) {
        if (this.publicacaoRepository.existsByGrupoId(entity.getId())) {
            throw new EloValidationException("Existem publica\u00e7\u00f5es para o Sub Grupo em quest\u00e3o.");
        }
    }

    @Generated
    public PublicacaoSubGrupoExercicioService(PublicacaoRepository publicacaoRepository, PublicacaoSubGrupoRepository subGrupoRepository, PublicacaoSubGrupoExercicioRepository repository) {
        this.publicacaoRepository = publicacaoRepository;
        this.subGrupoRepository = subGrupoRepository;
        this.repository = repository;
    }
}

