/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RenunciaReceitaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RenunciaReceitaDetalhesDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.RenunciaReceitaRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.RenunciaReceitaParams;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class RenunciaReceitaRepositoryImpl
implements RenunciaReceitaRepository {
    private static final String SQL_RENUNCIARECEITA = "db/sql/contab/renuncia-receita.sql";
    private static final String SQL_RENUNCIARECEITA_DETALHES = "db/sql/contab/renuncia-receita-detalhes.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public RenunciaReceitaRepositoryImpl(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public Page<RenunciaReceitaDTO> findRenuncias(RenunciaReceitaParams params, Pageable pageable) {
        String filter = this.getFiltros(params);
        String sql = FileUtils.readResourceAsString((String)SQL_RENUNCIARECEITA) + filter;
        String query = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql, (String)" ORDER BY ID DESC ");
        query = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)query, (String)this.datasourceWrapper.getPlatform());
        List renuncias = this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(RenunciaReceitaDTO.class));
        return new PageImpl(renuncias, pageable, this.getQuantidade(sql, params.toJdbcParameter()).longValue());
    }

    public Page<RenunciaReceitaDetalhesDTO> findRenunciasDetalhes(RenunciaReceitaParams params, Pageable pageable) {
        String filter = this.getFiltrosDetalhes(params);
        String sql = FileUtils.readResourceAsString((String)SQL_RENUNCIARECEITA_DETALHES) + filter;
        String query = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql, (String)" ORDER BY DATA DESC ");
        query = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)query, (String)this.datasourceWrapper.getPlatform());
        List realizacoes = this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(RenunciaReceitaDetalhesDTO.class));
        return new PageImpl(realizacoes, pageable, this.getQuantidade(sql, params.toJdbcParameter()).longValue());
    }

    private String getFiltros(RenunciaReceitaParams params) {
        StringBuilder filtro = new StringBuilder();
        filtro.append(" WHERE 1 = 1 ");
        params.getId().ifPresent(i -> filtro.append(" AND ID = ").append(params.getId().get()));
        params.getEntidade().ifPresent(i -> filtro.append(" AND ENTIDADE = ").append(params.getEntidade().get()));
        params.getExercicio().ifPresent(i -> filtro.append(" AND EXERCICIO = ").append(params.getExercicio().get()));
        params.getSetorBeneficiario().ifPresent(i -> filtro.append(" AND ${db.contabilidade.schema}.tiraacento(LOWER(SETORBENEFICIARIO)) LIKE ${db.contabilidade.schema}.tiraacento(LOWER('%").append((String)params.getSetorBeneficiario().get()).append("%')) "));
        params.getCompensacao().ifPresent(i -> filtro.append(" AND ${db.contabilidade.schema}.tiraacento(LOWER(COMPENSACAO)) LIKE ${db.contabilidade.schema}.tiraacento(LOWER('%").append((String)params.getCompensacao().get()).append("%')) "));
        params.getTributo().ifPresent(i -> filtro.append(" AND ${db.contabilidade.schema}.tiraacento(LOWER(TRIBUTOCONTRIB)) LIKE ${db.contabilidade.schema}.tiraacento(LOWER('%").append((String)params.getTributo().get()).append("%')) "));
        params.getDescTipoTributo().ifPresent(i -> filtro.append(" AND TIPOTRIBUTO = ").append(params.getTipoTributo()));
        params.getDescTipoModalidade().ifPresent(i -> filtro.append(" AND TIPOMODALIDADE = ").append(params.getTipoModalidade()));
        return filtro.toString();
    }

    private String getFiltrosDetalhes(RenunciaReceitaParams params) {
        StringBuilder filtro = new StringBuilder();
        Long tipoTributo = params.getTipoTributo();
        filtro.append("  WHERE IDTIPOOPERACAORECEITA IN (2, 3, 4, 99) ");
        params.getEntidade().ifPresent(i -> filtro.append(" AND ENTIDADE = ").append(params.getEntidade().get()));
        params.getExercicio().ifPresent(i -> filtro.append(" AND EXERCICIO = ").append(params.getExercicio().get()));
        if (Objects.nonNull(params.getDataInicio()) && Objects.nonNull(params.getDataFim())) {
            filtro.append(" AND DATA BETWEEN :dataInicio AND :dataFim");
        }
        if (tipoTributo == 1L) {
            if ((Long)params.getExercicio().get() < 2022L) {
                filtro.append(" AND RECEITA LIKE '1118011%' ");
            } else {
                filtro.append(" AND RECEITA LIKE '111250%' ");
            }
        } else if (tipoTributo == 2L) {
            if ((Long)params.getExercicio().get() < 2022L) {
                filtro.append(" AND RECEITA LIKE '1118014%' ");
            } else {
                filtro.append(" AND RECEITA LIKE '111253%' ");
            }
        } else if (tipoTributo == 3L) {
            if ((Long)params.getExercicio().get() < 2022L) {
                filtro.append(" AND RECEITA LIKE '1118023%' ");
            } else {
                filtro.append(" AND RECEITA LIKE '1114511%' ");
            }
        } else if (tipoTributo == 4L) {
            filtro.append(" AND RECEITA LIKE '113%' ");
        } else if (tipoTributo == 5L) {
            filtro.append(" AND RECEITA LIKE '112%' ");
        } else if (tipoTributo == 7L) {
            filtro.append(" AND RECEITA LIKE '124%' ");
        }
        return filtro.toString();
    }

    private Long getQuantidade(String query, MapSqlParameterSource parameter) {
        StringBuilder queryCount = new StringBuilder("SELECT COUNT(*) FROM (");
        queryCount.append(query);
        queryCount.append(") COUNT");
        return (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(queryCount.toString(), (SqlParameterSource)parameter, Long.class);
    }
}

