/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.resource.params;

import br.com.elotech.oxy.adm.compras.client.portal.FindLicitacaoPortalParamsDTO;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindLicitacaoParams;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.sql.Date;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

/*
 * Exception performing whole class analysis ignored.
 */
public class FindLicitacaoParams {
    private Long entidade;
    private Long exercicio;
    private Long tipoLicitacao;
    private Long licitacao;
    private Long modalidade;
    private Long numeroLicitacao;
    private Long numeroProcesso;
    private String situacao;
    private String objeto;
    private String exportType;
    private String dataAbertura;
    private String dataAberturaMaior;
    private String natureza;
    private String cnpjCpf;
    private String isCovid;
    private String aplicaLei14133;
    private Boolean ignoraExercicioLogado;

    public Optional<Long> getTipoLicitacao() {
        return Optional.ofNullable(this.tipoLicitacao);
    }

    public Optional<Long> getLicitacao() {
        return Optional.ofNullable(this.licitacao);
    }

    public Optional<Long> getModalidade() {
        return Optional.ofNullable(this.modalidade);
    }

    public Optional<Long> getNumeroLicitacao() {
        return Optional.ofNullable(this.numeroLicitacao);
    }

    public Optional<Long> getNumeroProcesso() {
        return Optional.ofNullable(this.numeroProcesso);
    }

    public Optional<String> getSituacao() {
        return Optional.ofNullable(this.situacao);
    }

    public Optional<String> getObjeto() {
        return Optional.ofNullable(this.objeto);
    }

    public Optional<LocalDate> getDataAbertura() {
        LocalDate localDate = null;
        if (StringUtils.isNotEmpty((String)this.dataAbertura)) {
            localDate = LocalDate.parse(this.dataAbertura);
        }
        return Optional.ofNullable(localDate);
    }

    public Optional<LocalDate> getDataAberturaMaior() {
        LocalDate localDate = null;
        if (StringUtils.isNotEmpty((String)this.dataAberturaMaior)) {
            localDate = LocalDate.parse(this.dataAberturaMaior);
        }
        return Optional.ofNullable(localDate);
    }

    public Optional<String> getNatureza() {
        return Optional.ofNullable(this.natureza);
    }

    public Optional<String> getCnpjCpf() {
        return Optional.ofNullable(this.cnpjCpf);
    }

    public Optional<String> getIsCovid() {
        return Optional.ofNullable(this.isCovid);
    }

    public Optional<String> getAplicaLei14133() {
        return Optional.ofNullable(this.aplicaLei14133);
    }

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.chechEntidade(params);
        this.checkExercicio(params);
        this.checkTipoLicitacao(params);
        this.checkLicitacao(params);
        this.checkModalidade(params);
        this.checkNumeroLicitacao(params);
        this.checkNumeroProcesso(params);
        this.checkSituacao(params);
        this.checkObjeto(params);
        this.checkDataAbertura(params);
        this.checkDataAberturaMaior(params);
        this.checkCnpjCpf(params);
        this.checkAplicaLei14133(params);
        return params;
    }

    private void checkAplicaLei14133(MapSqlParameterSource params) {
        if (Objects.nonNull(this.aplicaLei14133)) {
            params.addValue("aplicaLei14133", (Object)this.aplicaLei14133, 12);
        }
    }

    private void checkCnpjCpf(MapSqlParameterSource params) {
        if (Objects.nonNull(this.cnpjCpf)) {
            params.addValue("cnpjCpf", (Object)this.cnpjCpf, 12);
        }
    }

    private void checkDataAbertura(MapSqlParameterSource params) {
        if (Objects.nonNull(this.dataAbertura)) {
            params.addValue("dataAbertura", (Object)Date.valueOf(this.dataAbertura), 91);
        }
    }

    private void checkDataAberturaMaior(MapSqlParameterSource params) {
        if (Objects.nonNull(this.dataAberturaMaior)) {
            params.addValue("dataAberturaMaior", (Object)Date.valueOf(this.dataAberturaMaior), 91);
        }
    }

    private void checkObjeto(MapSqlParameterSource params) {
        if (Objects.nonNull(this.objeto)) {
            params.addValue("objeto", (Object)("%" + this.objeto + "%"), 12);
        }
    }

    private void checkSituacao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.situacao)) {
            params.addValue("situacao", (Object)this.situacao, 12);
        }
    }

    private void checkNumeroProcesso(MapSqlParameterSource params) {
        if (Objects.nonNull(this.numeroProcesso)) {
            params.addValue("numeroProcesso", (Object)this.numeroProcesso, 2);
        }
    }

    private void checkNumeroLicitacao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.numeroLicitacao)) {
            params.addValue("numeroLicitacao", (Object)this.numeroLicitacao, 2);
        }
    }

    private void checkModalidade(MapSqlParameterSource params) {
        if (Objects.nonNull(this.modalidade)) {
            params.addValue("modalidade", (Object)this.modalidade, 2);
        }
    }

    private void checkLicitacao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.licitacao)) {
            params.addValue("licitacao", (Object)this.licitacao, 2);
        }
    }

    private void checkTipoLicitacao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.tipoLicitacao)) {
            params.addValue("tipoLicitacao", (Object)this.tipoLicitacao, 2);
        }
    }

    private void checkExercicio(MapSqlParameterSource params) {
        if (Objects.nonNull(this.exercicio)) {
            params.addValue("exercicio", (Object)this.exercicio, 2);
        }
    }

    private void chechEntidade(MapSqlParameterSource params) {
        if (Objects.nonNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
    }

    public StringBuilder filtrosLicitacao(String sql, String platform) {
        StringBuilder query = new StringBuilder(sql);
        this.getModalidade().ifPresent(item -> query.append(" AND L.TIPOLICITACAO = :modalidade "));
        this.getNumeroLicitacao().ifPresent(item -> query.append(" AND L.NUMEROLICITACAO = :numeroLicitacao"));
        this.getNumeroProcesso().ifPresent(item -> query.append(" AND L.PROTOCOLO = :numeroProcesso "));
        this.getSituacao().ifPresent(item -> query.append(" AND LOWER(CASE WHEN L.tipocancelamento = 'A' THEN 'Anulada'             WHEN L.tipocancelamento = 'D' THEN 'Deserta'             WHEN L.tipocancelamento = 'F' THEN 'Fracassada'             WHEN L.tipocancelamento = 'R' THEN 'Revogada'             WHEN L.tipocancelamento = 'S' THEN 'Suspensa pelo TCE'             WHEN L.tipocancelamento = 'P' THEN 'Suspensa'             WHEN (EXISTS(               SELECT 1               FROM ${db.compras.schema}.clAcompanhamento ac               WHERE ac.entidade = l.entidade                 AND ac.exercicioLicitacao = l.exercicio                 AND ac.tipoLicitacao = l.tipoLicitacao                 AND ac.licitacao = l.licitacao                 AND ac.situacao = '09'               )) THEN 'Adjudicada'             WHEN (EXISTS( SELECT h.entidade                             FROM ${db.compras.schema}.clhomologacao h                             JOIN ${db.compras.schema}.clanalisevencedor v                               ON h.entidade = v.entidade                              AND h.exerciciolicitacao = v.exerciciolicitacao                              AND h.tipolicitacao = v.tipolicitacao                              AND h.licitacao = v.licitacao                              AND h.pessoa = v.pessoa                              AND v.vencedor = 'S'                            WHERE L.entidade = h.entidade                              AND L.exercicio = h.exerciciolicitacao                              AND L.tipolicitacao = h.tipolicitacao                              AND L.licitacao = h.licitacao)) THEN 'Homologada'             WHEN L.dataabertura < CURRENT_DATE THEN 'Em Andamento'             ELSE CASE WHEN L.status = 2 THEN 'Descartada'                       ELSE 'Aguardando Abertura'                  END END) = LOWER(:situacao) "));
        this.getObjeto().ifPresent(item -> query.append(" AND ${db.compras.schema}.tiraacento(LOWER(L.OBJETO)) LIKE ${db.compras.schema}.tiraacento(LOWER(:objeto)) "));
        this.getDataAbertura().ifPresent(item -> query.append(" AND CAST(L.DATAABERTURA AS DATE) = :dataAbertura "));
        this.getNatureza().ifPresent(item -> query.append(SqlUtils.andBeginsWith((String)"${db.compras.schema}", (String)"N.DESCRICAO", (String)this.natureza)));
        this.getCnpjCpf().ifPresent(item -> query.append(" AND L.LICITACAO IN (SELECT PD.LICITACAO").append("  FROM ${db.compras.schema}.PESSOA P").append("  JOIN ${db.compras.schema}.CLFORNECEDORDOCUMENTACAO PD").append("    ON P.PESSOA = PD.PESSOA").append(" WHERE PD.ENTIDADE  = :entidade").append("   AND PD.EXERCICIO = :exercicio").append(SqlUtils.andEqualNumbers((String)"P.CNPJ_CPF", (String)":cnpjCpf", (String)platform)).append(")"));
        this.getIsCovid().ifPresent(isCovid -> query.append(" AND L.MPCOVID19 = 'S'"));
        this.getAplicaLei14133().ifPresent(item -> query.append(" AND L.lei_14133_2021sn = :aplicaLei14133 "));
        return query;
    }

    public FindLicitacaoPortalParamsDTO toComprasOxyParams() {
        FindLicitacaoPortalParamsDTO dto = new FindLicitacaoPortalParamsDTO();
        dto.setEntidade(this.entidade);
        dto.setExercicio(this.exercicio);
        dto.setTipoLicitacao(this.tipoLicitacao);
        dto.setLicitacao(this.licitacao);
        dto.setModalidade(this.modalidade);
        dto.setNumeroLicitacao(this.numeroLicitacao);
        dto.setNumeroProcesso(this.numeroProcesso);
        dto.setSituacao(this.situacao);
        dto.setObjeto(this.objeto);
        dto.setExportType(this.exportType);
        dto.setDataAbertura(this.dataAbertura);
        dto.setDataAberturaMaior(this.dataAberturaMaior);
        dto.setNatureza(this.natureza);
        dto.setCnpjCpf(this.cnpjCpf);
        dto.setIsCovid(this.isCovid);
        dto.setAplicaLei14133(this.aplicaLei14133);
        dto.setIgnoraExercicioLogado(this.ignoraExercicioLogado);
        return dto;
    }

    @Generated
    private static Boolean $default$ignoraExercicioLogado() {
        return Boolean.FALSE;
    }

    @Generated
    public static FindLicitacaoParamsBuilder builder() {
        return new FindLicitacaoParamsBuilder();
    }

    @Generated
    public String toString() {
        return "FindLicitacaoParams(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", tipoLicitacao=" + this.getTipoLicitacao() + ", licitacao=" + this.getLicitacao() + ", modalidade=" + this.getModalidade() + ", numeroLicitacao=" + this.getNumeroLicitacao() + ", numeroProcesso=" + this.getNumeroProcesso() + ", situacao=" + this.getSituacao() + ", objeto=" + this.getObjeto() + ", exportType=" + this.getExportType() + ", dataAbertura=" + this.getDataAbertura() + ", dataAberturaMaior=" + this.getDataAberturaMaior() + ", natureza=" + this.getNatureza() + ", cnpjCpf=" + this.getCnpjCpf() + ", isCovid=" + this.getIsCovid() + ", aplicaLei14133=" + this.getAplicaLei14133() + ", ignoraExercicioLogado=" + this.getIgnoraExercicioLogado() + ")";
    }

    @Generated
    public FindLicitacaoParams() {
        this.ignoraExercicioLogado = FindLicitacaoParams.$default$ignoraExercicioLogado();
    }

    @Generated
    public FindLicitacaoParams(Long entidade, Long exercicio, Long tipoLicitacao, Long licitacao, Long modalidade, Long numeroLicitacao, Long numeroProcesso, String situacao, String objeto, String exportType, String dataAbertura, String dataAberturaMaior, String natureza, String cnpjCpf, String isCovid, String aplicaLei14133, Boolean ignoraExercicioLogado) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.tipoLicitacao = tipoLicitacao;
        this.licitacao = licitacao;
        this.modalidade = modalidade;
        this.numeroLicitacao = numeroLicitacao;
        this.numeroProcesso = numeroProcesso;
        this.situacao = situacao;
        this.objeto = objeto;
        this.exportType = exportType;
        this.dataAbertura = dataAbertura;
        this.dataAberturaMaior = dataAberturaMaior;
        this.natureza = natureza;
        this.cnpjCpf = cnpjCpf;
        this.isCovid = isCovid;
        this.aplicaLei14133 = aplicaLei14133;
        this.ignoraExercicioLogado = ignoraExercicioLogado;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @Generated
    public Boolean getIgnoraExercicioLogado() {
        return this.ignoraExercicioLogado;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoLicitacao(Long tipoLicitacao) {
        this.tipoLicitacao = tipoLicitacao;
    }

    @Generated
    public void setLicitacao(Long licitacao) {
        this.licitacao = licitacao;
    }

    @Generated
    public void setModalidade(Long modalidade) {
        this.modalidade = modalidade;
    }

    @Generated
    public void setNumeroLicitacao(Long numeroLicitacao) {
        this.numeroLicitacao = numeroLicitacao;
    }

    @Generated
    public void setNumeroProcesso(Long numeroProcesso) {
        this.numeroProcesso = numeroProcesso;
    }

    @Generated
    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setObjeto(String objeto) {
        this.objeto = objeto;
    }

    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    @Generated
    public void setDataAbertura(String dataAbertura) {
        this.dataAbertura = dataAbertura;
    }

    @Generated
    public void setDataAberturaMaior(String dataAberturaMaior) {
        this.dataAberturaMaior = dataAberturaMaior;
    }

    @Generated
    public void setNatureza(String natureza) {
        this.natureza = natureza;
    }

    @Generated
    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    @Generated
    public void setIsCovid(String isCovid) {
        this.isCovid = isCovid;
    }

    @Generated
    public void setAplicaLei14133(String aplicaLei14133) {
        this.aplicaLei14133 = aplicaLei14133;
    }

    @Generated
    public void setIgnoraExercicioLogado(Boolean ignoraExercicioLogado) {
        this.ignoraExercicioLogado = ignoraExercicioLogado;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindLicitacaoParams)) {
            return false;
        }
        FindLicitacaoParams other = (FindLicitacaoParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Optional this$tipoLicitacao = this.getTipoLicitacao();
        Optional other$tipoLicitacao = other.getTipoLicitacao();
        if (this$tipoLicitacao == null ? other$tipoLicitacao != null : !((Object)this$tipoLicitacao).equals(other$tipoLicitacao)) {
            return false;
        }
        Optional this$licitacao = this.getLicitacao();
        Optional other$licitacao = other.getLicitacao();
        if (this$licitacao == null ? other$licitacao != null : !((Object)this$licitacao).equals(other$licitacao)) {
            return false;
        }
        Optional this$modalidade = this.getModalidade();
        Optional other$modalidade = other.getModalidade();
        if (this$modalidade == null ? other$modalidade != null : !((Object)this$modalidade).equals(other$modalidade)) {
            return false;
        }
        Optional this$numeroLicitacao = this.getNumeroLicitacao();
        Optional other$numeroLicitacao = other.getNumeroLicitacao();
        if (this$numeroLicitacao == null ? other$numeroLicitacao != null : !((Object)this$numeroLicitacao).equals(other$numeroLicitacao)) {
            return false;
        }
        Optional this$numeroProcesso = this.getNumeroProcesso();
        Optional other$numeroProcesso = other.getNumeroProcesso();
        if (this$numeroProcesso == null ? other$numeroProcesso != null : !((Object)this$numeroProcesso).equals(other$numeroProcesso)) {
            return false;
        }
        Optional this$situacao = this.getSituacao();
        Optional other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !((Object)this$situacao).equals(other$situacao)) {
            return false;
        }
        Optional this$objeto = this.getObjeto();
        Optional other$objeto = other.getObjeto();
        if (this$objeto == null ? other$objeto != null : !((Object)this$objeto).equals(other$objeto)) {
            return false;
        }
        String this$exportType = this.getExportType();
        String other$exportType = other.getExportType();
        if (this$exportType == null ? other$exportType != null : !this$exportType.equals(other$exportType)) {
            return false;
        }
        Optional this$dataAbertura = this.getDataAbertura();
        Optional other$dataAbertura = other.getDataAbertura();
        if (this$dataAbertura == null ? other$dataAbertura != null : !((Object)this$dataAbertura).equals(other$dataAbertura)) {
            return false;
        }
        Optional this$dataAberturaMaior = this.getDataAberturaMaior();
        Optional other$dataAberturaMaior = other.getDataAberturaMaior();
        if (this$dataAberturaMaior == null ? other$dataAberturaMaior != null : !((Object)this$dataAberturaMaior).equals(other$dataAberturaMaior)) {
            return false;
        }
        Optional this$natureza = this.getNatureza();
        Optional other$natureza = other.getNatureza();
        if (this$natureza == null ? other$natureza != null : !((Object)this$natureza).equals(other$natureza)) {
            return false;
        }
        Optional this$cnpjCpf = this.getCnpjCpf();
        Optional other$cnpjCpf = other.getCnpjCpf();
        if (this$cnpjCpf == null ? other$cnpjCpf != null : !((Object)this$cnpjCpf).equals(other$cnpjCpf)) {
            return false;
        }
        Optional this$isCovid = this.getIsCovid();
        Optional other$isCovid = other.getIsCovid();
        if (this$isCovid == null ? other$isCovid != null : !((Object)this$isCovid).equals(other$isCovid)) {
            return false;
        }
        Optional this$aplicaLei14133 = this.getAplicaLei14133();
        Optional other$aplicaLei14133 = other.getAplicaLei14133();
        if (this$aplicaLei14133 == null ? other$aplicaLei14133 != null : !((Object)this$aplicaLei14133).equals(other$aplicaLei14133)) {
            return false;
        }
        Boolean this$ignoraExercicioLogado = this.getIgnoraExercicioLogado();
        Boolean other$ignoraExercicioLogado = other.getIgnoraExercicioLogado();
        return !(this$ignoraExercicioLogado == null ? other$ignoraExercicioLogado != null : !((Object)this$ignoraExercicioLogado).equals(other$ignoraExercicioLogado));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindLicitacaoParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Optional $tipoLicitacao = this.getTipoLicitacao();
        result = result * 59 + ($tipoLicitacao == null ? 43 : ((Object)$tipoLicitacao).hashCode());
        Optional $licitacao = this.getLicitacao();
        result = result * 59 + ($licitacao == null ? 43 : ((Object)$licitacao).hashCode());
        Optional $modalidade = this.getModalidade();
        result = result * 59 + ($modalidade == null ? 43 : ((Object)$modalidade).hashCode());
        Optional $numeroLicitacao = this.getNumeroLicitacao();
        result = result * 59 + ($numeroLicitacao == null ? 43 : ((Object)$numeroLicitacao).hashCode());
        Optional $numeroProcesso = this.getNumeroProcesso();
        result = result * 59 + ($numeroProcesso == null ? 43 : ((Object)$numeroProcesso).hashCode());
        Optional $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : ((Object)$situacao).hashCode());
        Optional $objeto = this.getObjeto();
        result = result * 59 + ($objeto == null ? 43 : ((Object)$objeto).hashCode());
        String $exportType = this.getExportType();
        result = result * 59 + ($exportType == null ? 43 : $exportType.hashCode());
        Optional $dataAbertura = this.getDataAbertura();
        result = result * 59 + ($dataAbertura == null ? 43 : ((Object)$dataAbertura).hashCode());
        Optional $dataAberturaMaior = this.getDataAberturaMaior();
        result = result * 59 + ($dataAberturaMaior == null ? 43 : ((Object)$dataAberturaMaior).hashCode());
        Optional $natureza = this.getNatureza();
        result = result * 59 + ($natureza == null ? 43 : ((Object)$natureza).hashCode());
        Optional $cnpjCpf = this.getCnpjCpf();
        result = result * 59 + ($cnpjCpf == null ? 43 : ((Object)$cnpjCpf).hashCode());
        Optional $isCovid = this.getIsCovid();
        result = result * 59 + ($isCovid == null ? 43 : ((Object)$isCovid).hashCode());
        Optional $aplicaLei14133 = this.getAplicaLei14133();
        result = result * 59 + ($aplicaLei14133 == null ? 43 : ((Object)$aplicaLei14133).hashCode());
        Boolean $ignoraExercicioLogado = this.getIgnoraExercicioLogado();
        result = result * 59 + ($ignoraExercicioLogado == null ? 43 : ((Object)$ignoraExercicioLogado).hashCode());
        return result;
    }
}

