/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.repository.impl;

import br.com.elotech.adm.compras.client.ContratoClient;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.oxy.adm.compras.client.portal.ContratoPortalDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.ContratoArquivoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.ContratoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.TipoContratoDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.ContratoRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindContratoParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindExercicioParams;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class ContratoOxyRepositoryImpl
implements ContratoRepository {
    private final ContratoClient client;

    public ContratoOxyRepositoryImpl(ContratoClient client) {
        this.client = client;
    }

    public Page<ContratoDTO> findContratos(FindContratoParams params, Pageable pageable) {
        EloPage page = this.client.findContratos(params.toComprasOxyParams(), pageable);
        List contratos = page.getContent().stream().map(ContratoDTO::fromContratoOxy).collect(Collectors.toList());
        return new PageImpl(contratos, pageable, page.getTotalElements());
    }

    public ContratoDTO findContrato(FindContratoParams params) {
        return ContratoDTO.fromContratoOxy((ContratoPortalDTO)this.client.findContrato(params.toComprasOxyParams()));
    }

    public List<ContratoArquivoDTO> findArquivos(FindContratoParams params, String nomeSchemaEloArquivo) {
        return this.client.findArquivos(params.toComprasOxyParams()).stream().map(ContratoArquivoDTO::fromContratoArquivoOxy).collect(Collectors.toList());
    }

    public List<TipoContratoDTO> findTiposContrato(String uf) {
        return this.client.findTiposContrato(uf).stream().map(TipoContratoDTO::fromTipoOxy).collect(Collectors.toList());
    }

    public List<ContratoDTO> findContratosLicitacao(FindContratoParams params) {
        return this.client.findContratosLicitacao(params.toComprasOxyParams()).stream().map(ContratoDTO::fromContratoOxy).collect(Collectors.toList());
    }

    public ContratoDTO findContratoByIdContrato(FindContratoParams params) {
        return ContratoDTO.fromContratoOxy((ContratoPortalDTO)this.client.findContratoByIdContrato(params.toComprasOxyParams()));
    }

    public List<UltimaAtualizacaoDTO> findUltimaAtualizacao(FindExercicioParams params) {
        return UltimaAtualizacaoDTO.fromUltimasAtualizacoesOxy((List)this.client.findUltimaAtualizacao(params.toComprasOxyParams()));
    }
}

