/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.service.impl;

import br.com.elotech.portaltransparencia.arquivoportal.domain.Arquivo;
import br.com.elotech.portaltransparencia.arquivoportal.repository.EloArquivoRepository;
import br.com.elotech.portaltransparencia.arquivoportal.service.ArquivoService;
import br.com.elotech.portaltransparencia.comprasportal.domain.LicitacaoArquivo;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.AtaLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.CertidaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.CotacaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.LicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.LicitacaoSeiDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.MidiaLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.ParecerDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.PrecoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.PublicacaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.RecursoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.LicitacaoArquivoRepository;
import br.com.elotech.portaltransparencia.comprasportal.repository.LicitacaoRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindExercicioParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindLicitacaoParams;
import br.com.elotech.portaltransparencia.comprasportal.service.LicitacaoService;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public class LicitacaoServiceImpl
implements LicitacaoService {
    private final LicitacaoRepository licitacaoRepository;
    private final LicitacaoArquivoRepository licitacaoArquivoRepository;
    private final EloArquivoRepository eloArquivoRepository;
    private final ArquivoService arquivoService;

    @Autowired
    public LicitacaoServiceImpl(LicitacaoRepository licitacaoRepository, LicitacaoArquivoRepository licitacaoArquivoRepository, EloArquivoRepository eloArquivoRepository, ArquivoService arquivoService) {
        this.licitacaoRepository = licitacaoRepository;
        this.licitacaoArquivoRepository = licitacaoArquivoRepository;
        this.eloArquivoRepository = eloArquivoRepository;
        this.arquivoService = arquivoService;
    }

    public Page<LicitacaoDTO> findLicitacoes(FindLicitacaoParams findLicitacaoParams, Pageable pageable) {
        return this.licitacaoRepository.findLicitacoes(findLicitacaoParams, pageable);
    }

    public LicitacaoDTO findLicitacao(FindLicitacaoParams params) {
        return this.licitacaoRepository.findLicitacao(params);
    }

    public List<ParecerDTO> findPareceres(FindLicitacaoParams params) {
        return this.licitacaoRepository.findPareceres(params, this.arquivoService.getNomeSchemaEloArquivo());
    }

    public List<MidiaLicitacaoDTO> findMidia(FindLicitacaoParams params) {
        return this.licitacaoRepository.findMidia(params);
    }

    public List<CotacaoLicitacaoDTO> findCotacoes(FindLicitacaoParams params) {
        return this.licitacaoRepository.findCotacoes(params, this.arquivoService.getNomeSchemaEloArquivo());
    }

    public List<PublicacaoLicitacaoDTO> findPublicacoes(FindLicitacaoParams params) {
        return this.licitacaoRepository.findPublicacoes(params, this.arquivoService.getNomeSchemaEloArquivo());
    }

    public List<AtaLicitacaoDTO> findAtas(FindLicitacaoParams params) {
        String nomeSchemaEloArquivo = this.arquivoService.getNomeSchemaEloArquivo();
        ArrayList<AtaLicitacaoDTO> list = new ArrayList<AtaLicitacaoDTO>();
        list.addAll(this.licitacaoRepository.findAtasRegistroPreco(params, nomeSchemaEloArquivo));
        list.addAll(this.licitacaoRepository.findAtasLicitacao(params, nomeSchemaEloArquivo));
        list.addAll(this.licitacaoRepository.findAtasSessaoPregao(params, nomeSchemaEloArquivo));
        Collections.sort(list);
        return list;
    }

    public List<LicitacaoArquivo> findArquivos(FindLicitacaoParams params) {
        if (!params.getTipoLicitacao().isPresent() && !params.getLicitacao().isPresent()) {
            return new ArrayList<LicitacaoArquivo>();
        }
        List<LicitacaoArquivo> licitacaoArquivos = this.licitacaoArquivoRepository.findByEntidadeAndExercicioAndTipoLicitacaoAndLicitacao(params.getEntidade(), params.getExercicio(), (Long)params.getTipoLicitacao().get(), (Long)params.getLicitacao().get()).stream().filter(LicitacaoArquivo::arquivoNaoSigiloso).collect(Collectors.toList());
        licitacaoArquivos.stream().filter(LicitacaoArquivo::possuiEloArquivo).map(LicitacaoArquivo::getArquivoCompras).forEach(arquivo -> {
            arquivo.setTamanhoArquivo(this.eloArquivoRepository.getTamanhoArquivo(arquivo.getArquivo().getId()));
            Arquivo arq = (Arquivo)this.eloArquivoRepository.getOne((Object)arquivo.getIdArquivo());
            if (Objects.isNull(arquivo.getData()) && Objects.nonNull(arq.getDataCriacao())) {
                arquivo.setData(arq.getDataCriacao());
            }
        });
        return licitacaoArquivos;
    }

    @Transactional
    public List<CertidaoLicitacaoDTO> findCertidoes(FindLicitacaoParams params) {
        return this.licitacaoRepository.findCertidoes(params, this.arquivoService.getNomeSchemaEloArquivo());
    }

    public List<PrecoLicitacaoDTO> findPrecos(FindLicitacaoParams params) {
        return this.licitacaoRepository.findPrecos(params, this.arquivoService.getNomeSchemaEloArquivo());
    }

    public List<RecursoLicitacaoDTO> findRecursos(FindLicitacaoParams params) {
        return this.licitacaoRepository.findRecursos(params, this.arquivoService.getNomeSchemaEloArquivo());
    }

    public List<UltimaAtualizacaoDTO> findUltimasAtualizacoes(FindExercicioParams params) {
        return this.licitacaoRepository.findUltimaAtualizacao(params);
    }

    public List<LicitacaoSeiDTO> findSei(FindLicitacaoParams params) {
        return this.licitacaoRepository.findSei(params);
    }
}

