/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.PessoaAdmDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.PessoaAdmRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindPessoaAdmParams;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class PessoaAdmRepositoryImpl
implements PessoaAdmRepository {
    private static final String PESSOASADM = "db/sql/compras/pessoaAdm.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public PessoaAdmRepositoryImpl(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public Page<PessoaAdmDTO> findPessoasAdm(FindPessoaAdmParams params, Pageable pageable) {
        Object sql = FileUtils.readResourceAsString((String)PESSOASADM);
        sql = (String)sql + params.montaWhere();
        Long qtdPessoa = this.countPessoasAdm((String)sql, params);
        sql = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql, (String)"ORDER BY A.NOME");
        sql = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)sql, (String)this.datasourceWrapper.getPlatform());
        List pessoas = this.datasourceWrapper.getJdbcTemplate().query((String)sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(PessoaAdmDTO.class));
        return new PageImpl(pessoas, pageable, qtdPessoa.longValue());
    }

    public Long countPessoasAdm(String sql, FindPessoaAdmParams params) {
        String sqlQuery = String.format("SELECT COUNT(1) FROM (%s) QTD", sql);
        return (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(sqlQuery, (SqlParameterSource)params.toJdbcParameter(), Long.class);
    }
}

