/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.resource.params;

import br.com.elotech.portaltransparencia.admportal.resource.params.EmendaParlamentarParams;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class EmendaParlamentarParams {
    private Long id;
    private Long entidade;
    private Long exercicio;
    private String autoria;
    private String tipo;
    private Long numero;
    private String objeto;
    private String funcao;
    private String exportType;

    public Optional<Long> getId() {
        return Optional.ofNullable(this.id);
    }

    public Optional<Long> getEntidade() {
        return Optional.ofNullable(this.entidade);
    }

    public Optional<Long> getExercicio() {
        return Optional.ofNullable(this.exercicio);
    }

    public Optional<String> getAutoria() {
        return Optional.ofNullable(this.autoria);
    }

    public Optional<String> getTipo() {
        return Optional.ofNullable(this.tipo);
    }

    public Optional<Long> getNumero() {
        return Optional.ofNullable(this.numero);
    }

    public Optional<String> getObjeto() {
        return Optional.ofNullable(this.objeto);
    }

    public Optional<String> getFuncao() {
        return Optional.ofNullable(this.funcao);
    }

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addEntidade(params);
        this.addExercicio(params);
        this.addAutoria(params);
        this.addTipo(params);
        this.addNumero(params);
        this.addObjeto(params);
        this.addFuncao(params);
        return params;
    }

    private void addEntidade(MapSqlParameterSource params) {
        if (Objects.nonNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
    }

    private void addExercicio(MapSqlParameterSource params) {
        if (Objects.nonNull(this.exercicio)) {
            params.addValue("exercicio", (Object)this.exercicio, 2);
        }
    }

    private void addAutoria(MapSqlParameterSource params) {
        if (Objects.nonNull(this.autoria)) {
            params.addValue("autoria", (Object)("%" + this.autoria + "%"), 12);
        }
    }

    private void addTipo(MapSqlParameterSource params) {
        if (Objects.nonNull(this.tipo)) {
            params.addValue("tipo", (Object)("%" + this.tipo + "%"), 12);
        }
    }

    private void addNumero(MapSqlParameterSource params) {
        if (Objects.nonNull(this.numero)) {
            params.addValue("numero", (Object)this.numero, 2);
        }
    }

    private void addFuncao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.funcao)) {
            params.addValue("funcao", (Object)("%" + this.funcao + "%"), 12);
        }
    }

    private void addObjeto(MapSqlParameterSource params) {
        if (Objects.nonNull(this.objeto)) {
            params.addValue("objeto", (Object)("%" + this.objeto + "%"), 12);
        }
    }

    @Generated
    public static EmendaParlamentarParamsBuilder builder() {
        return new EmendaParlamentarParamsBuilder();
    }

    @Generated
    public String toString() {
        return "EmendaParlamentarParams(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", autoria=" + this.getAutoria() + ", tipo=" + this.getTipo() + ", numero=" + this.getNumero() + ", objeto=" + this.getObjeto() + ", funcao=" + this.getFuncao() + ", exportType=" + this.getExportType() + ")";
    }

    @Generated
    public EmendaParlamentarParams() {
    }

    @Generated
    public EmendaParlamentarParams(Long id, Long entidade, Long exercicio, String autoria, String tipo, Long numero, String objeto, String funcao, String exportType) {
        this.id = id;
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.autoria = autoria;
        this.tipo = tipo;
        this.numero = numero;
        this.objeto = objeto;
        this.funcao = funcao;
        this.exportType = exportType;
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setAutoria(String autoria) {
        this.autoria = autoria;
    }

    @Generated
    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setNumero(Long numero) {
        this.numero = numero;
    }

    @Generated
    public void setObjeto(String objeto) {
        this.objeto = objeto;
    }

    @Generated
    public void setFuncao(String funcao) {
        this.funcao = funcao;
    }

    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmendaParlamentarParams)) {
            return false;
        }
        EmendaParlamentarParams other = (EmendaParlamentarParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Optional this$id = this.getId();
        Optional other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Optional this$entidade = this.getEntidade();
        Optional other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Optional this$exercicio = this.getExercicio();
        Optional other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Optional this$autoria = this.getAutoria();
        Optional other$autoria = other.getAutoria();
        if (this$autoria == null ? other$autoria != null : !((Object)this$autoria).equals(other$autoria)) {
            return false;
        }
        Optional this$tipo = this.getTipo();
        Optional other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !((Object)this$tipo).equals(other$tipo)) {
            return false;
        }
        Optional this$numero = this.getNumero();
        Optional other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !((Object)this$numero).equals(other$numero)) {
            return false;
        }
        Optional this$objeto = this.getObjeto();
        Optional other$objeto = other.getObjeto();
        if (this$objeto == null ? other$objeto != null : !((Object)this$objeto).equals(other$objeto)) {
            return false;
        }
        Optional this$funcao = this.getFuncao();
        Optional other$funcao = other.getFuncao();
        if (this$funcao == null ? other$funcao != null : !((Object)this$funcao).equals(other$funcao)) {
            return false;
        }
        String this$exportType = this.getExportType();
        String other$exportType = other.getExportType();
        return !(this$exportType == null ? other$exportType != null : !this$exportType.equals(other$exportType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EmendaParlamentarParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Optional $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Optional $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Optional $autoria = this.getAutoria();
        result = result * 59 + ($autoria == null ? 43 : ((Object)$autoria).hashCode());
        Optional $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : ((Object)$tipo).hashCode());
        Optional $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : ((Object)$numero).hashCode());
        Optional $objeto = this.getObjeto();
        result = result * 59 + ($objeto == null ? 43 : ((Object)$objeto).hashCode());
        Optional $funcao = this.getFuncao();
        result = result * 59 + ($funcao == null ? 43 : ((Object)$funcao).hashCode());
        String $exportType = this.getExportType();
        result = result * 59 + ($exportType == null ? 43 : $exportType.hashCode());
        return result;
    }
}

