SELECT	OPR.ENTIDADE,
		OPR.ANODOCORIGEM AS EXERCICIO,
		OPR.NODOCORIGEM AS EMPENHO,
		OPR.UNIDADEDOCORIGEM AS UNIDADEORCAMENTARIA,
		OPR.EXERCICIO AS EXERCICIOLIQUIDACAO,
		OPR.NOLIQUIDACAO,
		OP.DATA AS DATA,
		SUM(OPR.VALOR) AS VALOR,
		SUM(CASE WHEN OP.CANCELADO = 'S' THEN OPR.VALOR ELSE 0 END) AS VALORESTORNADO,
		CASE
			WHEN COALESCE(TX.CODIGO, 0) = 17 THEN '[F] - PENSÃO ALIMENTÍCIA'
			ELSE COALESCE(CC.DESCRICAO, P.DESCRICAO)
		END AS DESCRICAO
FROM ${db.contabilidade.schema}.ORDEMPAGAMENTO_RETENCAO OPR
LEFT OUTER JOIN ${db.contabilidade.schema}.ORDEMPAGAMENTO OP ON
	OPR.ENTIDADE = OP.ENTIDADE
	AND OPR.EXERCICIO = OP.EXERCICIO
	AND OPR.NOORDEM = OP.NOORDEM
LEFT OUTER JOIN ${db.contabilidade.schema}.EMPENHO E ON
	OPR.ENTIDADE = E.ENTIDADE
	AND OPR.ANODOCORIGEM = E.EXERCICIO
	AND OPR.NODOCORIGEM = E.EMPENHO
	AND OPR.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA
LEFT OUTER JOIN ${db.contabilidade.schema}.CONTACORRENTE CC ON
	OPR.ENTIDADE = CC.ENTIDADE
	AND OPR.IDCONTACORRENTE = CC.IDCONTACORRENTE
LEFT OUTER JOIN ${db.contabilidade.schema}.PLANO P ON
	OPR.ENTIDADE = P.ENTIDADE
	AND OPR.EXERCICIO = P.EXERCICIO
	AND OPR.CODIGORETENCAO = P.CONTA
LEFT JOIN ${db.contabilidade.schema}.CADASTROEXTRA CX ON
	CX.ID = CC.IDCADASTROEXTRA
	AND CX.ENTIDADE = CC.ENTIDADE
LEFT JOIN ${db.contabilidade.schema}.TIPOEXTRAORCAMENTARIO TX ON
	TX.ID = CX.IDTIPOEXTRAORCAMENTARIO