/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.report;

import br.com.elotech.core.utils.web.HeaderUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import org.springframework.util.ResourceUtils;

public class ReportUtils {
    @Generated
    private static final Logger log = Logger.getLogger(ReportUtils.class.getName());

    private ReportUtils() {
    }

    public static JasperReport getJasperReportByLocation(String location) {
        try {
            URL url = ResourceUtils.getURL((String)location);
            return (JasperReport)JRLoader.loadObject((URL)url);
        }
        catch (FileNotFoundException f) {
            log.log(Level.SEVERE, f.getMessage(), f);
            throw new IOException("N\u00e3o foi poss\u00edvel encontrar o arquivo.", f);
        }
        catch (JRException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new JRException("Falha ao converter o arquivo.", (Throwable)e);
        }
    }

    public static byte[] exportToPdfByJasperPrint(JasperPrint jasperPrint) throws JRException {
        return JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
    }

    public static void writePdfToResponse(HttpServletResponse response, byte[] arquivo, String fileName) throws IOException {
        HeaderUtil.addPdfHeadersToResponse((HttpServletResponse)response, (String)fileName);
        response.getOutputStream().write(arquivo);
        response.setContentLength(arquivo.length);
    }
}

