/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.service.impl;

import br.com.elotech.core.common.dto.MailResultInfo;
import br.com.elotech.portaltransparencia.contabportal.service.ProcessoMailService;
import br.com.elotech.portaltransparencia.exception.SituacaoProcessoNaoEncontradoException;
import br.com.elotech.portaltransparencia.exception.TipoProcessoNaoEncontradoException;
import br.com.elotech.portaltransparencia.protocportal.domain.EnderecoPessoa;
import br.com.elotech.portaltransparencia.protocportal.domain.Escolaridade;
import br.com.elotech.portaltransparencia.protocportal.domain.Local;
import br.com.elotech.portaltransparencia.protocportal.domain.PROTOCEntidade;
import br.com.elotech.portaltransparencia.protocportal.domain.Pessoa;
import br.com.elotech.portaltransparencia.protocportal.domain.Processo;
import br.com.elotech.portaltransparencia.protocportal.domain.ProcessoPK;
import br.com.elotech.portaltransparencia.protocportal.domain.Sexo;
import br.com.elotech.portaltransparencia.protocportal.domain.Situacao;
import br.com.elotech.portaltransparencia.protocportal.domain.TipoProcesso;
import br.com.elotech.portaltransparencia.protocportal.domain.Tramite;
import br.com.elotech.portaltransparencia.protocportal.domain.TramitePK;
import br.com.elotech.portaltransparencia.protocportal.dto.ProcessoDTO;
import br.com.elotech.portaltransparencia.protocportal.mapper.ProcessoToDTO;
import br.com.elotech.portaltransparencia.protocportal.params.SalvaProcessoParams;
import br.com.elotech.portaltransparencia.protocportal.repository.EscolaridadeRepository;
import br.com.elotech.portaltransparencia.protocportal.repository.LocalRepository;
import br.com.elotech.portaltransparencia.protocportal.repository.ProcessoRepository;
import br.com.elotech.portaltransparencia.protocportal.repository.SituacaoRepository;
import br.com.elotech.portaltransparencia.protocportal.repository.TipoProcessoRepository;
import br.com.elotech.portaltransparencia.protocportal.service.ParametroService;
import br.com.elotech.portaltransparencia.protocportal.service.PessoaService;
import br.com.elotech.portaltransparencia.protocportal.service.ProcessoService;
import br.com.elotech.protocolo.dto.AssuntoDTO;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class ProcessoServiceImpl
implements ProcessoService {
    private static final String ESIC = "e-SIC";
    private static final String EMPTY = "";
    private static final int MAX_VALUE = 88888;
    private static final int MIN_VALUE = 21311;
    private final TipoProcessoRepository tipoProcessoRepository;
    private final ProcessoRepository processoRepository;
    private final SituacaoRepository situacaoRepository;
    private final ParametroService parametroService;
    private final PessoaService pessoaService;
    private final ProcessoMailService processoMailService;
    private final LocalRepository localRepository;
    private final EscolaridadeRepository escolaridadeRepository;

    public ProcessoServiceImpl(TipoProcessoRepository tipoProcessoRepository, ProcessoRepository processoRepository, SituacaoRepository situacaoRepository, ParametroService parametroService, PessoaService pessoaService, ProcessoMailService processoMailService, LocalRepository localRepository, EscolaridadeRepository escolaridadeRepository) {
        this.tipoProcessoRepository = tipoProcessoRepository;
        this.processoRepository = processoRepository;
        this.situacaoRepository = situacaoRepository;
        this.parametroService = parametroService;
        this.pessoaService = pessoaService;
        this.processoMailService = processoMailService;
        this.localRepository = localRepository;
        this.escolaridadeRepository = escolaridadeRepository;
    }

    @Transactional
    public ProcessoDTO salvaProcesso(SalvaProcessoParams params) {
        Processo processo = this.buildProcesso(params);
        Tramite tramiteOrigem = new Tramite(TramitePK.of((Processo)processo, (Long)1L), processo, "C", processo.getLocalOrigem());
        processo.addTramite(tramiteOrigem);
        Tramite tramiteDestino = new Tramite(TramitePK.of((Processo)processo, (Long)2L), processo, "E", processo.getLocalDestino());
        processo.addTramite(tramiteDestino);
        ProcessoDTO processoDTO = new ProcessoToDTO().convert((Processo)this.processoRepository.saveAndFlush((Object)processo));
        if (processoDTO != null) {
            processoDTO.setEntidade(params.getEntidade().toString());
        }
        return processoDTO;
    }

    private Processo buildProcesso(SalvaProcessoParams params) {
        String email;
        Long entidade = params.getEntidadeProtocolo();
        Long exercicio = params.getExercicio();
        Pessoa pessoa = params.getPessoa();
        EnderecoPessoa endereco = params.getEndereco();
        String assunto = params.getAssunto();
        String formaRecebimento = params.getFormaRecebimento();
        String digitacao = params.getDigitacao();
        String processoReferencia = params.getProcessoReferencia();
        Long escolaridade = params.getEscolaridade();
        String sexo = params.getSexo();
        LocalDate dataNascimento = params.getDataNascimento();
        PROTOCEntidade entidadeObj = new PROTOCEntidade(entidade);
        TipoProcesso tipo = this.findTipoProcessoProtocolo(entidade, exercicio);
        Processo processo = new Processo();
        ProcessoPK id = ProcessoPK.of((PROTOCEntidade)entidadeObj, (TipoProcesso)tipo, (Long)0L, (Long)exercicio);
        processo.setId(id);
        processo.setDigitacao(digitacao);
        processo.setProcessoReferencia(processoReferencia);
        processo.setDataNascimento(dataNascimento);
        if (sexo != null && !sexo.isEmpty()) {
            processo.setSexo(Sexo.fromValue((String)sexo));
        }
        processo.setEscolaridade(this.getEscolaridade(escolaridade));
        processo.setSituacao(this.findSituacao(entidade));
        processo.setCodAssunto(this.codAssunto(entidade));
        processo.setLocalOrigem(this.localOrigem(entidade));
        processo.setLocalDestino(this.localDestino(entidade));
        processo.setLocalAtual(this.localDestino(entidade));
        processo.setSenha(this.createSenha());
        processo.setAssunto(assunto);
        processo.setOutrosDados(this.formaRecebimento(formaRecebimento));
        processo.setStatus("E");
        processo.setDataprocesso(LocalDate.now());
        processo.setDataOrigem(LocalDate.now());
        processo.setDataDestino(LocalDate.now());
        if (pessoa != null && StringUtils.isNotBlank((CharSequence)(email = pessoa.fetchEmail()))) {
            processo.setEmail(email);
        }
        pessoa = this.pessoaService.fetchPessoa(entidade, exercicio, pessoa, endereco);
        processo.setPessoa(pessoa);
        processo.setTelefone(pessoa.fetchTelefone());
        processo.setRg(pessoa.getRg());
        if (StringUtils.isBlank((CharSequence)processo.getEmail())) {
            processo.setEmail(pessoa.fetchEmail());
        }
        processo.setCelular(pessoa.fetchCelular());
        processo.setCnpjCpf(pessoa.getCnpjCpf());
        if (Objects.nonNull(endereco)) {
            this.setEndereco(processo, endereco);
        }
        processo.setUsuarioReg(ESIC);
        processo.getId().setNumero(this.processoRepository.getNextSequence(processo));
        return processo;
    }

    private Escolaridade getEscolaridade(Long escolaridade) {
        if (Objects.nonNull(escolaridade)) {
            return this.findEscolaridade(escolaridade);
        }
        return null;
    }

    private void setEndereco(Processo processo, EnderecoPessoa endereco) {
        processo.setComplemento(endereco.getComplemento());
        processo.setCep(endereco.getCep());
        processo.setNumeroEndereco(endereco.getNumero());
        processo.setCidadeAux(endereco.getCidadeAux());
        processo.setBairroAux(endereco.getBairroAux());
        processo.setEndereco(endereco.getEndereco());
        if (!this.isEmptyOrNull((Object)endereco.getUfId()).booleanValue()) {
            processo.setUf(endereco.getUfId());
            processo.setUnidadeFederacao(endereco.getUfId());
        }
    }

    private Boolean isEmptyOrNull(Object obj) {
        return Objects.isNull(obj) || obj.equals(EMPTY);
    }

    private String formaRecebimento(String formaRecebimento) {
        if (Objects.nonNull(formaRecebimento)) {
            String prefix = "Forma de recebimento da resposta: ";
            return prefix.concat(formaRecebimento);
        }
        return formaRecebimento;
    }

    private String createSenha() {
        Random generator = new Random();
        int numero = generator.nextInt();
        while (numero < 21311 || numero > 88888) {
            numero = generator.nextInt();
        }
        return Integer.toString(numero);
    }

    private Local localOrigem(Long entidade) {
        String origem = this.parametroService.findParametroPorEntidadeEExercicio(entidade, Long.valueOf(86L));
        if (Objects.nonNull(origem)) {
            return this.localRepository.findOneByIdIdAndIdEntidadeId(Long.valueOf(Long.parseLong(origem)), entidade);
        }
        return null;
    }

    private Local localDestino(Long entidade) {
        String destino = this.parametroService.findParametroPorEntidadeEExercicio(entidade, Long.valueOf(87L));
        if (Objects.nonNull(destino)) {
            return this.localRepository.findOneByIdIdAndIdEntidadeId(Long.valueOf(Long.parseLong(destino)), entidade);
        }
        return null;
    }

    private Long codAssunto(Long entidade) {
        String assunto = this.parametroService.findParametroPorEntidadeEExercicio(entidade, Long.valueOf(84L));
        if (Objects.nonNull(assunto)) {
            return Long.parseLong(assunto);
        }
        return null;
    }

    private Situacao findSituacao(Long entidade) {
        String situacao = this.parametroService.findParametroPorEntidadeEExercicio(entidade, Long.valueOf(85L));
        if (Objects.nonNull(situacao)) {
            return this.situacaoRepository.findTopByIdOrderByIdDesc(Long.valueOf(Long.parseLong(situacao)));
        }
        throw new SituacaoProcessoNaoEncontradoException(situacao);
    }

    private TipoProcesso findTipoProcessoProtocolo(Long entidade, Long exercicio) {
        Long tipo = this.tipoProcessoProtocolo(entidade, exercicio);
        if (Objects.nonNull(tipo)) {
            return (TipoProcesso)this.tipoProcessoRepository.findOne((Object)tipo);
        }
        throw new TipoProcessoNaoEncontradoException(tipo);
    }

    private Escolaridade findEscolaridade(Long escolaridade) {
        return (Escolaridade)this.escolaridadeRepository.findOne((Object)escolaridade);
    }

    private Long tipoProcessoProtocolo(Long entidade, Long exercicio) {
        return Long.parseLong(this.parametroService.findTipoProcessoProtocoloOrThrow(entidade, exercicio));
    }

    public Future<MailResultInfo> enviaeSicEmail(ProcessoDTO processo) {
        return this.processoMailService.enviaeSicEmail(processo);
    }

    public Future<MailResultInfo> enviaContatoEmail(ProcessoDTO processo) {
        return this.processoMailService.enviaContatoEmail(processo);
    }

    public List<Escolaridade> loadEscolaridades() {
        return this.escolaridadeRepository.findAll();
    }

    public List<AssuntoDTO> loadAssuntos(Long entidade, String search) {
        return new ArrayList<AssuntoDTO>();
    }
}

