/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.service.impl;

import br.com.elotech.core.utils.EloPage;
import br.com.elotech.portaltransparencia.protocportal.params.ConsultaProcessoEsicParams;
import br.com.elotech.portaltransparencia.protocportal.params.ConsultaProcessoParams;
import br.com.elotech.portaltransparencia.protocportal.service.ParametroService;
import br.com.elotech.portaltransparencia.protocportal.service.ProcessoConsultaEsicService;
import br.com.elotech.protocolo.client.feign.ConsultaProcessoIntegracaoClientFeign;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.dto.TipoProcessoDTO;
import br.com.elotech.protocolo.dto.params.PesquisaProcessoParams;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class ProcessoConsultaEsicServiceOxyImpl
implements ProcessoConsultaEsicService {
    private final ConsultaProcessoIntegracaoClientFeign client;
    private final ParametroService parametroService;

    public ProcessoConsultaEsicServiceOxyImpl(ConsultaProcessoIntegracaoClientFeign client, ParametroService parametroService) {
        this.client = client;
        this.parametroService = parametroService;
    }

    public br.com.elotech.portaltransparencia.protocportal.dto.ProcessoDTO consultaProcesso(ConsultaProcessoParams params) {
        PesquisaProcessoParams pesquisaProcessoParams = params.toOxyParams();
        ProcessoDTO processoDTO = this.client.findOne(pesquisaProcessoParams.getEntidade(), pesquisaProcessoParams.getAno(), pesquisaProcessoParams.getTipo(), pesquisaProcessoParams.getNumero());
        return br.com.elotech.portaltransparencia.protocportal.dto.ProcessoDTO.fromOxyProcesso((ProcessoDTO)Optional.ofNullable(processoDTO).orElse(new ProcessoDTO()));
    }

    public Page<br.com.elotech.portaltransparencia.protocportal.dto.ProcessoDTO> findProcessoByTipo(ConsultaProcessoEsicParams params, Pageable pageable) {
        StringBuilder searchBuilder = new StringBuilder();
        if (params.getUsuario().isPresent() && StringUtils.isNotBlank((String)((String)params.getUsuario().get()))) {
            searchBuilder.append(String.format(" usuarioRegistro==%s", params.getUsuario().get()));
        } else {
            searchBuilder.append(" usuarioRegistro!='e-SIC'");
        }
        params.getDataInicial().ifPresent(item -> searchBuilder.append(String.format(" and dataProcesso>=%s", params.getDataInicial().get())));
        params.getDataFinal().ifPresent(item -> searchBuilder.append(String.format(" and dataProcesso<=%s", params.getDataFinal().get())));
        EloPage processosByTipo = this.client.findProcessosGeraisByAssunto(null, searchBuilder.toString(), params.getEntidade(), pageable);
        List content = processosByTipo.getContent();
        List processos = content.stream().map(br.com.elotech.portaltransparencia.protocportal.dto.ProcessoDTO::fromOxyProcesso).collect(Collectors.toList());
        return new PageImpl(processos, pageable, processosByTipo.getTotalElements());
    }

    public List<TipoProcessoDTO> findTipoProcesso(Long entidade, Long exercicio) {
        return this.client.findTiposProcesso();
    }
}

