/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.utils;

import br.com.elotech.contabilidade.client.dto.DespesaDTO;
import br.com.elotech.contabilidade.client.params.EmpenhoParams;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.utils.StringUtils;
import br.com.elotech.orcamento.client.dto.DespesaPadraoTCEDTO;
import br.com.elotech.portaltransparencia.web.rest.params.ProgramaticaParams;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import cz.jirutka.rsql.parser.ast.RSQLOperators;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

/*
 * Exception performing whole class analysis ignored.
 */
public final class EmpenhoOxyUtils {
    private static final int OPERATOR_SIZE = 2;
    private static final int NIVEL_DESPESA_CAT_ECONOMICA = 0;
    private static final int NIVEL_DESPESA_ELEMENTO = 6;
    private static final String DATA = "data";
    private static final String VALOR = "valor";
    private static final String ID_EMPENHO = "id.empenho";
    private static final String FORNECEDOR = "fornecedor.nome";
    private static final String HISTORICO = "historico";
    private static final HashMap<String, BiFunction<Sort.Order, String, Sort.Order>> ORDERS = new HashMap();
    private static final HashMap<String, Function<String, String>> FILTERS = new HashMap();

    public static EmpenhoParams translateParams(br.com.elotech.portaltransparencia.web.rest.params.EmpenhoParams params) {
        Map mapExercicio = EmpenhoOxyUtils.extracValueSearch((String)params.getSearch(), (String)"id.exercicio");
        Map mapDataSaldo = EmpenhoOxyUtils.extracValueSearch((String)params.getSearch(), (String)"fichasEmpenho.id.data");
        Long exercicio = null;
        if (!mapExercicio.isEmpty()) {
            exercicio = Long.parseLong((String)mapExercicio.get(RSQLOperators.EQUAL.getSymbol()));
        }
        LocalDate inicio = null;
        LocalDate fim = null;
        for (Map.Entry map : mapDataSaldo.entrySet()) {
            if (((String)map.getKey()).equals(RSQLOperators.GREATER_THAN_OR_EQUAL.getSymbols()[1])) {
                inicio = LocalDate.parse((CharSequence)map.getValue());
                continue;
            }
            fim = LocalDate.parse((CharSequence)map.getValue());
        }
        return EmpenhoParams.builder().entidade(params.getEntidade()).exercicio(exercicio).dataInicio(inicio).dataFim(fim).applyFilterDataEmpenho(Boolean.TRUE).onlyAPagar(params.getAPagar()).onlyPassagens(params.getPassagens()).onlyComprasDireta(params.getComprasDireta()).fonteRecurso(params.getFonteRecurso()).build();
    }

    public static Map<String, String> extracValueSearch(String search, String field) {
        if (!FILTERS.containsKey(field)) {
            throw new IllegalArgumentException("Campo deve existir nos filtros.");
        }
        HashMap<String, String> opeardorValue = new HashMap<String, String>();
        Splitter.on((String)"and").trimResults().splitToList((CharSequence)search).forEach(filter -> {
            if (filter.startsWith(field)) {
                int length = field.length();
                opeardorValue.put(filter.substring(length, length + 2), filter.substring(length + 2).replaceAll("'", ""));
            }
        });
        return opeardorValue;
    }

    public static Pageable translateSortToOxy(Pageable page) {
        ArrayList orders = new ArrayList();
        if (page.getSort().isSorted()) {
            List list = page.getSort().toList();
            list.forEach(sort -> {
                if ("id.empenho".equals(sort.getProperty())) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "numeroEmpenho"));
                }
                if ("data".equals(sort.getProperty())) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "data"));
                }
                if ("fornecedor.nome".equals(sort.getProperty()) || "nome".equals(sort.getProperty())) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "credor.nome"));
                }
                if ("fornecedor.cnpj".equals(sort.getProperty()) || "cnpjCpf".equals(sort.getProperty())) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "credor.cnpjCpf"));
                }
                if ("historico".equals(sort.getProperty())) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get(sort.getProperty())).apply(sort, "complementoHistorico"));
                }
            });
        }
        return PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize(), (Sort)Sort.by(orders));
    }

    public static String translateSearchToOxy(br.com.elotech.portaltransparencia.web.rest.params.EmpenhoParams empenhoParams) {
        String search = empenhoParams.getSearch();
        if (!Strings.isNullOrEmpty((String)search)) {
            search = EmpenhoOxyUtils.translateFields((String)search);
            if (Objects.nonNull(empenhoParams.getProgramatica())) {
                search = search.concat(EmpenhoOxyUtils.translateSearchDesdobramento((ProgramaticaParams)empenhoParams.getProgramatica()));
            }
        }
        if (Objects.nonNull(empenhoParams.getIsCovid()) && SimNao.toBoolean((String)empenhoParams.getIsCovid().replace("'", "")).booleanValue()) {
            search = search.concat(";covid==true");
        }
        return search;
    }

    private static String translateFields(String search) {
        StringBuilder rsql = new StringBuilder();
        Splitter.on((String)"and").trimResults().splitToList((CharSequence)search).forEach(filter -> FILTERS.keySet().stream().forEach(key -> {
            String rsqlOxy;
            if (filter.startsWith((String)key) && !(rsqlOxy = (String)((Function)FILTERS.get(key)).apply(filter)).isEmpty()) {
                rsql.append(";").append(rsqlOxy);
            }
        }));
        return rsql.substring(1);
    }

    public static String translateSearchDesdobramento(ProgramaticaParams params) {
        StringBuilder rsql = new StringBuilder();
        EmpenhoOxyUtils.applyFilter((StringBuilder)rsql, (String)params.getOrgao(), (String)";dotacao.unidade.unidadeComposta=='%s*'");
        EmpenhoOxyUtils.applyFilter((StringBuilder)rsql, (String)params.getUnidade(), (String)";dotacao.unidade.unidadeComposta=='%s'");
        EmpenhoOxyUtils.applyFilter((StringBuilder)rsql, (String)params.getFuncao(), (String)";dotacao.funcao.codigo=='%s'");
        EmpenhoOxyUtils.applyFilter((StringBuilder)rsql, (String)params.getSubFuncao(), (String)";dotacao.subfuncao.codigo=='%s'");
        EmpenhoOxyUtils.applyFilter((StringBuilder)rsql, (String)params.getPrograma(), (String)";dotacao.programa.codigo=='%s'");
        EmpenhoOxyUtils.applyFilter((StringBuilder)rsql, (String)params.getProjeto(), (String)";dotacao.projetoAtividade.codigo=='%s'");
        Optional.ofNullable(params.getDespesaCodigo()).ifPresent(dc -> EmpenhoOxyUtils.applyFilter((StringBuilder)rsql, (String)dc.replace("%", ""), (String)";despesaCodigo=='%s*'"));
        return rsql.toString();
    }

    public static String buildSearchDespesa(DespesaDTO despesa) {
        StringBuilder search = new StringBuilder();
        search.append(String.format("codigo==%s%s*", StringUtils.safeSubstring((String)despesa.getCodigo(), (int)0, (int)6), Optional.ofNullable(despesa.getDesdobramento()).orElse("")));
        return search.toString();
    }

    public static String getDescricaoByNivel(List<DespesaPadraoTCEDTO> despesas, String codigo, int nivel) {
        return despesas.stream().filter(d -> d.getNivelDespesa(nivel).equals(codigo)).map(DespesaPadraoTCEDTO::getDescricao).findAny().orElse("");
    }

    public static void applyFilter(StringBuilder rsql, String value, String filter) {
        Optional.ofNullable(value).ifPresent(v -> rsql.append(String.format(filter, v)));
    }

    static {
        ORDERS.put("id.empenho", (sort, field) -> new Sort.Order(sort.getDirection(), field));
        ORDERS.put("data", (sort, field) -> new Sort.Order(sort.getDirection(), field));
        ORDERS.put("fornecedor.nome", (sort, field) -> new Sort.Order(sort.getDirection(), field));
        ORDERS.put("nome", (sort, field) -> new Sort.Order(sort.getDirection(), field));
        ORDERS.put("historico", (sort, field) -> new Sort.Order(sort.getDirection(), field));
        ORDERS.put("fornecedor.cnpj", (sort, field) -> new Sort.Order(sort.getDirection(), field));
        ORDERS.put("cnpjCpf", (sort, field) -> new Sort.Order(sort.getDirection(), field));
        FILTERS.put("fichasEmpenho.id.data", filter -> "");
        FILTERS.put("data", filter -> filter.replace("data", "data").replaceAll("'", ""));
        FILTERS.put("valor", filter -> filter.replace("valor", "valor").replaceAll("'", ""));
        FILTERS.put("fornecedor.cnpj", filter -> filter.replace("fornecedor.cnpj", "credor.cnpjCpf"));
        FILTERS.put("id.exercicio", filter -> filter.replace("id.exercicio", "exercicio.exercicio").replaceAll("'", ""));
        FILTERS.put("id.entidade", filter -> filter.replace("id.entidade", "exercicio.entidade.id").replaceAll("'", ""));
        FILTERS.put("fornecedor.nome", filter -> filter.replace("fornecedor.nome", "credor.nome").replaceAll("\"", "'"));
        FILTERS.put("id.empenho", filter -> filter.replace("id.empenho", "numeroEmpenho").replaceAll("'", ""));
        FILTERS.put("anoLicitacao", filter -> filter.replace("anoLicitacao", "licitacao.ano"));
        FILTERS.put("noLicitacao", filter -> filter.replace("noLicitacao", "licitacao.numeroLicitacao"));
        FILTERS.put("tipoLicitacao.compras", filter -> filter.replace("tipoLicitacao.compras", "licitacao.modalidade.id"));
    }
}

