/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.repository.PortalParametroRepository;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class AtendimentoService {
    private final PortalParametroRepository portalParametroRepository;

    @Autowired
    public AtendimentoService(PortalParametroRepository portalParametroRepository) {
        this.portalParametroRepository = portalParametroRepository;
    }

    public List<PortalParametroContabil> getAtendimento(Long entidade, Long exercicio) {
        Specification & Serializable spec = (Specification & Serializable)(root, query, cb) -> {
            ArrayList<Object> predicates = new ArrayList<Object>();
            CriteriaBuilder.In inClause = cb.in((Expression)root.get("id").get("id"));
            List.of(Parametros.PARAM_ATENDIMENTO_ORGAO, Parametros.PARAM_ATENDIMENTO_ENDERECO, Parametros.PARAM_ATENDIMENTO_CIDADE, Parametros.PARAM_ATENDIMENTO_TELEFONE, Parametros.PARAM_ATENDIMENTO_EMAIL, Parametros.PARAM_ATENDIMENTO_EXPEDIENTE).forEach(arg_0 -> ((CriteriaBuilder.In)inClause).value(arg_0));
            predicates.add(inClause);
            Subquery subQuery = query.subquery(PortalParametroContabil.class);
            Root subQueryRoot = subQuery.from(PortalParametroContabil.class);
            subQuery.select((Expression)subQueryRoot);
            Predicate predicateEntidadeExercicio = cb.or(new Predicate[]{cb.and((Expression)cb.equal((Expression)root.get("id").get("entidade"), (Object)entidade), (Expression)cb.equal((Expression)root.get("id").get("exercicio"), (Object)exercicio)), cb.and(new Predicate[]{cb.equal((Expression)root.get("id").get("entidade"), (Object)entidade), cb.equal((Expression)root.get("id").get("exercicio"), (Object)Parametros.NAO_DEPENDE_EXERCICIO), cb.not((Expression)cb.exists(subQuery.where((Expression)cb.and(new Predicate[]{cb.equal((Expression)subQueryRoot.get("id").get("entidade"), (Object)entidade), cb.equal((Expression)subQueryRoot.get("id").get("exercicio"), (Object)exercicio), cb.equal((Expression)subQueryRoot.get("id").get("id"), (Expression)root.get("id").get("id"))}))))}), cb.and(new Predicate[]{cb.equal((Expression)root.get("id").get("entidade"), (Object)Parametros.NAO_DEPENDE_ENTIDADE), cb.equal((Expression)root.get("id").get("exercicio"), (Object)Parametros.NAO_DEPENDE_EXERCICIO), cb.not((Expression)cb.exists(subQuery.where((Expression)cb.and(new Predicate[]{cb.equal((Expression)subQueryRoot.get("id").get("entidade"), (Object)entidade), cb.equal((Expression)subQueryRoot.get("id").get("exercicio"), (Object)Parametros.NAO_DEPENDE_EXERCICIO), cb.equal((Expression)subQueryRoot.get("id").get("id"), (Expression)root.get("id").get("id"))}))))})});
            predicates.add(predicateEntidadeExercicio);
            return cb.and(predicates.toArray(new Predicate[0]));
        };
        return this.portalParametroRepository.findAll((Specification)spec, this.sortById());
    }

    private Sort sortById() {
        return Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"id.id"});
    }
}

