/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.service.impl;

import br.com.elotech.core.utils.NumberUtils;
import br.com.elotech.portaltransparencia.admportal.domain.EloPortalParametroTexto;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.domain.dto.EloPortalParametroTextoDTO;
import br.com.elotech.portaltransparencia.admportal.domain.dto.converter.EloPortalParametroTextoConverter;
import br.com.elotech.portaltransparencia.admportal.repository.EloPortalParametroTextoRepository;
import br.com.elotech.portaltransparencia.admportal.repository.PortalParametroRepository;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.arquivoportal.domain.ArquivoInterface;
import br.com.elotech.portaltransparencia.arquivoportal.repository.EloArquivoRepository;
import br.com.elotech.portaltransparencia.contabportal.domain.ArquivoContab;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.Fornecedor;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroPK;
import br.com.elotech.portaltransparencia.contabportal.domain.QPortalParametroContabil;
import br.com.elotech.portaltransparencia.contabportal.repository.ArquivoRepository;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.portaltransparencia.contabportal.service.FornecedorService;
import br.com.elotech.portaltransparencia.enums.GrupoParametro;
import com.google.common.collect.Lists;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PortalParametroServiceImpl
implements PortalParametroService {
    private static final Long IDARQUIVO_0 = 0L;
    private static final Long EXERCICIO_0 = 0L;
    private static final Long ENTIDADE_0 = 0L;
    private final EloArquivoRepository eloArquivoRepository;
    private final ArquivoRepository arquivoRepository;
    private final PortalParametroRepository portalParametroRepository;
    private final EntidadeContabilidadeService entidadeService;
    private final FornecedorService fornecedorService;
    private final EloPortalParametroTextoRepository eloPortalParametroTexto;

    @Autowired
    public PortalParametroServiceImpl(PortalParametroRepository portalParametroRepository, EloArquivoRepository eloArquivoRepository, ArquivoRepository arquivoRepository, FornecedorService fornecedorService, EloPortalParametroTextoRepository eloPortalParametroTexto, EntidadeContabilidadeService entidadeService) {
        this.portalParametroRepository = portalParametroRepository;
        this.eloArquivoRepository = eloArquivoRepository;
        this.arquivoRepository = arquivoRepository;
        this.fornecedorService = fornecedorService;
        this.eloPortalParametroTexto = eloPortalParametroTexto;
        this.entidadeService = entidadeService;
    }

    public List<PortalParametroContabil> getParametros(Long entidade, Long exercicio) {
        Entidade entidadeObj = this.entidadeService.getEntidadeSelecionada(entidade);
        BooleanExpression filtroParametros = QPortalParametroContabil.portalParametroContabil.id().entidade.eq((Object)entidadeObj.getId()).and((com.querydsl.core.types.Predicate)QPortalParametroContabil.portalParametroContabil.id().exercicio.eq((Object)exercicio)).or((com.querydsl.core.types.Predicate)QPortalParametroContabil.portalParametroContabil.id().entidade.eq((Object)0L).and((com.querydsl.core.types.Predicate)QPortalParametroContabil.portalParametroContabil.id().exercicio.eq((Object)exercicio)).or((com.querydsl.core.types.Predicate)QPortalParametroContabil.portalParametroContabil.id().entidade.eq((Object)0L).and((com.querydsl.core.types.Predicate)QPortalParametroContabil.portalParametroContabil.id().exercicio.eq((Object)0L))));
        Iterable todosParametros = this.portalParametroRepository.findAll((com.querydsl.core.types.Predicate)filtroParametros);
        ArrayList result = Lists.newArrayList((Iterable)todosParametros);
        result.stream().filter(p -> p.getId().getId().equals(Parametros.PARAM_FORMULARIO_MENSAGEM)).forEach(p -> this.verifyConfigMail(Parametros.PARAM_FORMULARIO_MENSAGEM, p, entidade, exercicio));
        return result;
    }

    public Map<Long, PortalParametroContabil> loadParametrosByGrupo(Long entidade, Long exercicio, GrupoParametro grupoParametro) {
        BooleanExpression parametroNoExercicio = QPortalParametroContabil.portalParametroContabil.id().id.in((Object[])grupoParametro.getIds()).and((com.querydsl.core.types.Predicate)QPortalParametroContabil.portalParametroContabil.id().entidade.eq((Object)entidade).and((com.querydsl.core.types.Predicate)QPortalParametroContabil.portalParametroContabil.id().exercicio.eq((Object)exercicio).or((com.querydsl.core.types.Predicate)QPortalParametroContabil.portalParametroContabil.id().entidade.eq((Object)entidade).and((com.querydsl.core.types.Predicate)QPortalParametroContabil.portalParametroContabil.id().exercicio.eq((Object)0L))).or((com.querydsl.core.types.Predicate)QPortalParametroContabil.portalParametroContabil.id().entidade.eq((Object)0L).and((com.querydsl.core.types.Predicate)QPortalParametroContabil.portalParametroContabil.id().exercicio.eq((Object)0L)))));
        ArrayList parametrosDB = Lists.newArrayList((Iterable)this.portalParametroRepository.findAll((com.querydsl.core.types.Predicate)parametroNoExercicio));
        Map parametrosByGrupo = grupoParametro.getCreator().create(entidade, exercicio);
        this.insereValorDoBanco((List)parametrosDB, parametrosByGrupo);
        return parametrosByGrupo;
    }

    private void insereValorDoBanco(List<PortalParametroContabil> parametrosDB, Map<Long, PortalParametroContabil> parametrosByGrupo) {
        parametrosByGrupo.forEach((key, parametro) -> {
            PortalParametroContabil parametroDB = parametrosDB.stream().filter(PortalParametroServiceImpl.getParametroEntidadeExercicioPredicate((PortalParametroContabil)parametro)).findFirst().orElse(parametrosDB.stream().filter(PortalParametroServiceImpl.getParametroEntidadePredicate((PortalParametroContabil)parametro)).findFirst().orElse(parametrosDB.stream().filter(PortalParametroServiceImpl.getParametroPredicate((PortalParametroContabil)parametro)).findFirst().orElse(null)));
            if (Objects.nonNull(parametroDB)) {
                parametro.setValor(parametroDB.getValor());
            } else {
                parametro.setValor("");
            }
        });
    }

    private static Predicate<PortalParametroContabil> getParametroEntidadeExercicioPredicate(PortalParametroContabil parametro) {
        return t -> t.getIdParametro().equals(parametro.getIdParametro()) && t.getId().getEntidade().equals(parametro.getId().getEntidade()) && t.getId().getExercicio().equals(parametro.getId().getExercicio());
    }

    private static Predicate<PortalParametroContabil> getParametroEntidadePredicate(PortalParametroContabil parametro) {
        return t -> t.getIdParametro().equals(parametro.getIdParametro()) && t.getId().getEntidade().equals(parametro.getId().getEntidade()) && t.getId().getExercicio().equals(0L);
    }

    private static Predicate<PortalParametroContabil> getParametroPredicate(PortalParametroContabil parametro) {
        return t -> t.getIdParametro().equals(parametro.getIdParametro()) && t.getId().getEntidade().equals(0L) && t.getId().getExercicio().equals(0L);
    }

    public Long getIdArquivo(Long entidade, Long exercicio, Long parametro) {
        PortalParametroContabil portalParametro = (PortalParametroContabil)this.portalParametroRepository.findOne((Object)new PortalParametroPK(entidade, exercicio, parametro));
        if (Objects.nonNull(portalParametro) && StringUtils.isNotBlank((CharSequence)portalParametro.getValor())) {
            return NumberUtils.toLong((String)portalParametro.getValor());
        }
        return IDARQUIVO_0;
    }

    public ArquivoInterface getLeieSIC(Long entidade, Long exercicio) {
        Long idArquivo = this.getIdArquivo(entidade, exercicio, Parametros.PARAM_IDARQUIVO_LAI);
        return this.findArquivoContabilByIdArquivo(idArquivo);
    }

    public ArquivoInterface getLeiOrganicaMunicipio() {
        Long idArquivo = this.getIdArquivo(ENTIDADE_0, EXERCICIO_0, Parametros.PARAM_LEI_ORGANICA_DO_MUNICIPIO);
        return this.findArquivoContabilByIdArquivo(idArquivo);
    }

    public ArquivoInterface getInstrucaoNormativa(Long entidade, Long exercicio) {
        Long idArquivo = this.getIdArquivo(entidade, exercicio, Parametros.PARAM_INSTRUCAO_NORMATIVA);
        return this.findArquivoContabilByIdArquivo(idArquivo);
    }

    public ArquivoInterface getArquivoAjuda() {
        Long idArquivo = this.getIdArquivo(ENTIDADE_0, EXERCICIO_0, Parametros.PARAM_IDARQUIVO_AJUDA);
        if (NumberUtils.isBiggerThanZero((Number)idArquivo).booleanValue()) {
            return this.findArquivoContabilByIdArquivo(idArquivo);
        }
        return null;
    }

    public PortalParametroContabil getPortalParametro(Long entidade, Long exercicio, Long codigo) {
        if (EXERCICIO_0.equals(exercicio)) {
            return this.portalParametroRepository.findFirstByIdEntidadeAndIdIdOrderByIdExercicioDesc(entidade, codigo);
        }
        return this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(entidade, exercicio, codigo);
    }

    private void verifyConfigMail(Long codigo, PortalParametroContabil portalParametro, Long entidade, Long exercicio) {
        PortalParametroContabil paramMailPassword;
        PortalParametroContabil paramMailUsername;
        PortalParametroContabil paramMailPort;
        PortalParametroContabil paramMailHost;
        if (Parametros.PARAM_FORMULARIO_MENSAGEM.equals(codigo) && "1".equals(portalParametro.getValor()) && this.notValidMailParams(paramMailHost = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(entidade, exercicio, Parametros.PARAM_MAIL_HOST), paramMailPort = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(entidade, exercicio, Parametros.PARAM_MAIL_PORT), paramMailUsername = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(entidade, exercicio, Parametros.PARAM_MAIL_USERNAME), paramMailPassword = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(entidade, exercicio, Parametros.PARAM_MAIL_PASSWORD))) {
            portalParametro.setValor("0");
        }
    }

    private boolean notValidMailParams(PortalParametroContabil paramMailHost, PortalParametroContabil paramMailPort, PortalParametroContabil paramMailUsername, PortalParametroContabil paramMailPassword) {
        return Objects.isNull(paramMailHost) || StringUtils.isBlank((CharSequence)paramMailHost.getValor()) || Objects.isNull(paramMailPort) || StringUtils.isBlank((CharSequence)paramMailPort.getValor()) || Objects.isNull(paramMailUsername) || StringUtils.isBlank((CharSequence)paramMailUsername.getValor()) || Objects.isNull(paramMailPassword) || StringUtils.isBlank((CharSequence)paramMailPassword.getValor());
    }

    public String getPortalParametroValor(Long entidade, Long exercicio, Long codigo) {
        PortalParametroContabil portalParametro = this.getPortalParametro(entidade, exercicio, codigo);
        if (Objects.nonNull(portalParametro) && StringUtils.isNotBlank((CharSequence)portalParametro.getValor())) {
            return portalParametro.getValor();
        }
        return null;
    }

    public ArquivoInterface getManualFornecedor() {
        Long idArquivo = this.getIdArquivo(ENTIDADE_0, EXERCICIO_0, Parametros.PARAM_IDARQUIVO_MANUAL_FORNECEDOR);
        return this.findArquivoContabilByIdArquivo(idArquivo);
    }

    public ArquivoInterface getArquivoSicFisico() {
        Long idArquivo = this.getIdArquivo(ENTIDADE_0, EXERCICIO_0, Parametros.PARAM_IDARQUIVO_SIC_FISICO);
        return this.findArquivoContabilByIdArquivo(idArquivo);
    }

    public EloPortalParametroTextoDTO getMensagemParametroTexto(Long entidade, Long exercicio, Long tipoCadastro) {
        EloPortalParametroTexto parametro = this.eloPortalParametroTexto.findByIdEntidadeAndIdExercicioAndIdTipoCadastro(entidade, exercicio, tipoCadastro);
        EloPortalParametroTextoDTO parametroDTO = new EloPortalParametroTextoDTO();
        if (Objects.nonNull(parametro)) {
            parametroDTO.setEntidade(parametro.getId().getEntidade());
            parametroDTO.setExercicio(parametro.getId().getExercicio());
            parametroDTO.setTexto(parametro.getTexto());
            parametroDTO.setTipoCadastro(parametro.getId().getTipoCadastro());
        } else {
            parametroDTO.setEntidade(entidade);
            parametroDTO.setExercicio(exercicio);
            parametroDTO.setTexto("");
            parametroDTO.setTipoCadastro(tipoCadastro);
        }
        return parametroDTO;
    }

    public EloPortalParametroTextoDTO saveMensagemParametroTexto(EloPortalParametroTextoDTO parametroTextoDTO) {
        return EloPortalParametroTextoConverter.toDTO((EloPortalParametroTexto)((EloPortalParametroTexto)this.eloPortalParametroTexto.save((Object)EloPortalParametroTextoConverter.toEntity((EloPortalParametroTextoDTO)parametroTextoDTO))));
    }

    private ArquivoInterface findArquivoContabilByIdArquivo(Long idArquivo) {
        ArquivoContab arquivo;
        if (NumberUtils.isBiggerThanZero((Number)idArquivo).booleanValue() && Objects.nonNull(arquivo = (ArquivoContab)this.arquivoRepository.findOne((Object)idArquivo)) && Objects.nonNull(arquivo.getEloArquivo().getId())) {
            return this.eloArquivoRepository.findByIdProjection(arquivo.getEloArquivo().getId());
        }
        return null;
    }

    public Fornecedor findResponsavelLai(Long entidade, Long exercicio) {
        PortalParametroContabil param = this.getPortalParametro(entidade, exercicio, Parametros.PARAM_RESPONSAVEL_LAI);
        if (Objects.nonNull(param) && StringUtils.isNotBlank((CharSequence)param.getValor())) {
            Long id = Long.valueOf(param.getValor());
            return Optional.ofNullable(this.fornecedorService.getFornecedor(id)).map(fornecedor -> {
                PortalParametroContabil paramEmail;
                PortalParametroContabil paramTel;
                if (Objects.isNull(fornecedor.getTel()) && Objects.nonNull(paramTel = this.getPortalParametro(ENTIDADE_0, EXERCICIO_0, Parametros.PARAM_ATENDIMENTO_TELEFONE))) {
                    fornecedor.setTel(paramTel.getValor());
                }
                if (Objects.isNull(fornecedor.getEmail()) && Objects.nonNull(paramEmail = this.getPortalParametro(ENTIDADE_0, EXERCICIO_0, Parametros.PARAM_ATENDIMENTO_EMAIL))) {
                    fornecedor.setEmail(paramEmail.getValor());
                }
                return fornecedor;
            }).orElse(null);
        }
        return null;
    }

    public ArquivoInterface getMedidasAdotadasCobranca(Long entidade, Long exercicio) {
        Long idArquivo = this.getIdArquivo(entidade, exercicio, Parametros.PARAM_IDARQUIVO_MEDIDAS_ADOTADAS);
        return this.findArquivoContabilByIdArquivo(idArquivo);
    }

    public PortalParametroContabil save(PortalParametroContabil parametro) {
        return (PortalParametroContabil)this.portalParametroRepository.save((Object)parametro);
    }
}

