SELECT C.NOME FORNECEDOR, 
       CASE
       		WHEN C.TIPOPESSOA = 'F'
    		THEN '**' || SUBSTR(C.CNPJ_CPF,3,5) || '****'
    		ELSE C.CNPJ_CPF
	   END as CNPJCPF, 
       CASE WHEN D.NOMEARQUIVO IS NULL THEN ELOARQ.NOME ELSE D.NOMEARQUIVO END AS NOMEARQUIVO,
       D.IDARQUIVO, 
       D.DATA AS DATAARQUIVO,
       LENGTH(AC.ARQUIVO) AS TAMANHOARQUIVO
  FROM ${db.compras.schema}.CLLICITACAOFORNECEDOR A
 INNER JOIN ${db.compras.schema}.CLLICITACAO B
    ON B.ENTIDADE = A.ENTIDADE
   AND B.EXERCICIO = A.EXERCICIOLICITACAO
   AND B.TIPOLICITACAO = A.TIPOLICITACAO
   AND B.LICITACAO = A.LICITACAO
 INNER JOIN ${db.compras.schema}.PESSOA C
    ON C.PESSOA = A.PESSOA
  LEFT OUTER JOIN ${db.compras.schema}.ARQUIVO D
    ON D.ID = A.IDARQUIVO
  LEFT OUTER JOIN schema_eloarquivo.ARQUIVO ELOARQ
    ON ELOARQ.ID = D.IDARQUIVO
  LEFT OUTER JOIN schema_eloarquivo.ARQUIVO_CONTENT AC
    ON AC.ID = D.IDARQUIVO
 WHERE B.ENTIDADE =  :entidade
   AND B.EXERCICIO =  :exercicio
   AND B.TIPOLICITACAO =  :tipoLicitacao
   AND B.LICITACAO =  :licitacao