SELECT P.NOME, 
       CASE
	   		WHEN P.TIPOPESSOA = 'F'
	    	THEN '**' || SUBSTR(P.CNPJ_CPF,3,5) || '****'
	    	ELSE P.CNPJ_CPF
	   END as CNPJCPF, 
       A.DATA, A.PESSOA, 
       A.EXERCICIOLICITACAO
  FROM ${db.compras.schema}.CLHOMOLOGACAO A
  LEFT JOIN ${db.compras.schema}.CLLICITACAO B
    ON A.ENTIDADE           = B.ENTIDADE 
   AND A.EXERCICIOLICITACAO = B.EXERCICIO 
   AND A.TIPOLICITACAO      = B.TIPOLICITACAO 
   AND A.LICITACAO          = B.LICITACAO 
  LEFT JOIN ${db.compras.schema}.PESSOA P
    ON A.PESSOA = P.PESSOA   
 WHERE A.ENTIDADE           = :entidade
   AND A.EXERCICIO          = :exercicio
   AND A.EXERCICIOLICITACAO = :exercicioLicitacao
   AND A.TIPOLICITACAO      = :tipoLicitacao
   AND A.LICITACAO          = :licitacao
   AND A.PESSOA             = :pessoa 