SELECT A.ENTIDADE, A.EXERCICIO, A.IDORDEMSERVICO, A.ORDEMSERVICO, A.BEMPROPRIO AS DESCRICAOBEM,
 A.DESCRICAO, A.BEM, A.VALOR AS VALORINTERVENCAO, C.VALOR AS VALORCONTRATO, P.NOME AS EMPRESA,
 ((SELECT SUM(COALESCE(AD.VALOR,0) - COALESCE(AD.VALORREDUCAO,0))
    FROM ${db.aise.schema}.OBRAEMPRESACONTRATOADITIVO AD
   WHERE C.IDEMPRESACONTRATO = AD.IDEMPRESACONTRATO)) AS VALORADITIVO,
 ((SELECT SUM(COALESCE(AC.VALORFATURAMENTO,0) + COALESCE(AC.VALORCONVENIO,0))
    FROM ${db.aise.schema}.OBRAACOMPANHAMENTO AC
   WHERE A.ENTIDADE = AC.ENTIDADE
     AND A.EXERCICIO = AC.EXERCICIO
     AND A.IDORDEMSERVICO = AC.IDORDEMSERVICO)) AS VALORPAGO,
 A.DATAINICIO AS DATA,
 T.IDTIPOACOMPANHAMENTO AS SITUACAO, 
 A.PERCENTUAL, 
 A.OBJETO, 
 C.NOCONTRATO AS NUMEROCONTRATO, 
 C.EXERCICIOCONTRATO, 
 C.IDCONTRATO,
 A.PREVISAOTERMINO,
 A.POPULACAOATENDIDA,
 F.MATRICULA,
 PF.NOME AS NOMEFISCAL,
 (SELECT COALESCE(COUNT(*),0) FROM ${db.aise.schema}.OBRAORDEMPLANILHAORCAMENTO B
   WHERE B.ENTIDADE = A.ENTIDADE
   AND B.EXERCICIO = A.EXERCICIO
   AND B.IDORDEMSERVICO = A.IDORDEMSERVICO) AS EXISTEPLANILHA
 FROM ${db.aise.schema}.OBRAORDEMSERVICO A
 LEFT OUTER JOIN ${db.aise.schema}.OBRABEM B ON
      A.ENTIDADE = B.ENTIDADE
      AND A.BEM = B.BEM
 LEFT OUTER JOIN ${db.aise.schema}.OBRAEMPRESACONTRATO C ON
      A.IDEMPRESACONTRATO = C.IDEMPRESACONTRATO
 LEFT OUTER JOIN ${db.aise.schema}.PESSOA P ON
      A.CONSTRUTORA = P.PESSOA
 LEFT OUTER JOIN ${db.aise.schema}.OBRATIPOACOMPANHAMENTO T ON
      A.IDTIPOACOMPANHAMENTO = T.IDTIPOACOMPANHAMENTO
 LEFT JOIN ${db.aise.schema}.OBRAFISCAL F on
      F.PESSOA = A.FISCAL
 LEFT JOIN ${db.aise.schema}.PESSOA PF on
      PF.PESSOA = F.PESSOA
 WHERE A.ENTIDADE = :entidade
 	AND A.EXERCICIO = :exercicioObra
 	AND A.IDORDEMSERVICO = :idOrdemServico
