/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.CentroCustoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.CentroCustoCustomRepository;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CentroCustoRepositoryImpl
implements CentroCustoCustomRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CentroCustoRepositoryImpl.class);
    private static final String CENTROCUSTO_MOVIMENTACAO = "db/sql/contab/centrocusto-com-movimentacao.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public CentroCustoRepositoryImpl(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public List<CentroCustoDTO> findByAtivoAndCentroDeOrigemAndComMovimentacaoAndEntidade(Long entidade) {
        String sql = FileUtils.readResourceAsString((String)CENTROCUSTO_MOVIMENTACAO);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("entidade", (Object)entidade, 2);
        LOGGER.debug(sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(CentroCustoDTO.class));
    }
}

