/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.resource;

import br.com.elotech.portaltransparencia.admportal.domain.dto.EloPortalParametroTextoDTO;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.arquivoportal.domain.ArquivoInterface;
import br.com.elotech.portaltransparencia.contabportal.domain.ArquivoContab;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroPK;
import br.com.elotech.portaltransparencia.contabportal.service.ArquivoContabilService;
import br.com.elotech.portaltransparencia.enums.GrupoParametro;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.InvalidPathException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/admin/parametros"})
public class AdminPortalParametroResource {
    private final ArquivoContabilService arquivoService;
    private final PortalParametroService portalParametroService;

    public AdminPortalParametroResource(ArquivoContabilService arquivoService, PortalParametroService portalParametroService) {
        this.arquivoService = arquivoService;
        this.portalParametroService = portalParametroService;
    }

    @GetMapping(value={"/{entidade}/{exercicio}"})
    public ResponseEntity<List<PortalParametroContabil>> getParametros(@PathVariable Long entidade, @PathVariable Long exercicio) {
        return ResponseEntity.ok((Object)this.portalParametroService.getParametros(entidade, exercicio));
    }

    @GetMapping(value={"/{entidade}/{exercicio}/grupo/{grupo}"})
    public ResponseEntity<Map<Long, PortalParametroContabil>> loadParametrosByGrupo(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable String grupo) {
        return ResponseEntity.ok((Object)this.portalParametroService.loadParametrosByGrupo(entidade, exercicio, GrupoParametro.fromValue((String)grupo)));
    }

    @GetMapping(value={"/leiesic/{entidade}/{exercicio}"})
    public ResponseEntity<ArquivoInterface> getLeiESic(@PathVariable Long entidade, @PathVariable Long exercicio) {
        ArquivoInterface leieSIC = this.portalParametroService.getLeieSIC(entidade, exercicio);
        if (Objects.nonNull(leieSIC)) {
            return ResponseEntity.ok((Object)leieSIC);
        }
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/instrucao-normativa/{entidade}/{exercicio}"})
    public ResponseEntity<ArquivoInterface> getInstrucaoNormativa(@PathVariable Long entidade, @PathVariable Long exercicio) {
        ArquivoInterface instrucaoNormativa = this.portalParametroService.getInstrucaoNormativa(entidade, exercicio);
        if (Objects.nonNull(instrucaoNormativa)) {
            return ResponseEntity.ok((Object)instrucaoNormativa);
        }
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/medidas-adotadas-cobranca/{entidade}/{exercicio}"})
    public ResponseEntity<ArquivoInterface> getMedidasAdotadasCobranca(@PathVariable Long entidade, @PathVariable Long exercicio) {
        ArquivoInterface medidaAdotaCobranca = this.portalParametroService.getMedidasAdotadasCobranca(entidade, exercicio);
        if (Objects.nonNull(medidaAdotaCobranca)) {
            return ResponseEntity.ok((Object)medidaAdotaCobranca);
        }
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/manual-fornecedor"})
    public ResponseEntity<ArquivoInterface> getIdManualFornecedor() {
        ArquivoInterface arquivoManualFornecedor = this.portalParametroService.getManualFornecedor();
        if (Objects.nonNull(arquivoManualFornecedor)) {
            return ResponseEntity.ok((Object)arquivoManualFornecedor);
        }
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/sic-fisico"})
    public ResponseEntity<ArquivoInterface> getArquivoSicFisico() {
        ArquivoInterface arquivoSicFisico = this.portalParametroService.getArquivoSicFisico();
        if (Objects.nonNull(arquivoSicFisico)) {
            return ResponseEntity.ok((Object)arquivoSicFisico);
        }
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/sic-fisico/mensagem"})
    public ResponseEntity<EloPortalParametroTextoDTO> getMensagemSicFisico(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @RequestParam Long tipoCadastro) {
        return ResponseEntity.ok((Object)this.portalParametroService.getMensagemParametroTexto(entidade, exercicio, tipoCadastro));
    }

    @PostMapping(value={"/sic-fisico/mensagem"})
    public ResponseEntity<EloPortalParametroTextoDTO> saveMensagemSicFisico(@RequestBody EloPortalParametroTextoDTO parametroTexto) {
        return ResponseEntity.ok((Object)this.portalParametroService.saveMensagemParametroTexto(parametroTexto));
    }

    @PostMapping
    public ResponseEntity<PortalParametroContabil> save(@RequestBody PortalParametroContabil parametro) throws URISyntaxException {
        if (Objects.isNull(parametro.getValor())) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.created((URI)new URI("")).body((Object)this.portalParametroService.save(parametro));
    }

    @PostMapping(value={"/multi"})
    public ResponseEntity<Map<Long, PortalParametroContabil>> saveMultiplosParametros(@RequestBody Map<Long, PortalParametroContabil> parametros) throws URISyntaxException {
        parametros.values().stream().forEach(arg_0 -> this.removerArquivosAntigosESalvarParametros(arg_0));
        return ResponseEntity.created((URI)new URI("")).body(parametros);
    }

    private void removerArquivosAntigosESalvarParametros(PortalParametroContabil parametroContabil) {
        String idArquivoAntigo;
        if (Objects.isNull(parametroContabil.getValor())) {
            parametroContabil.setValor("");
        }
        if (GrupoParametro.ARQUIVOS.getIdsAsSet().contains(parametroContabil.getIdParametro()) && StringUtils.isBlank((String)parametroContabil.getValor()) && StringUtils.isNotBlank((String)(idArquivoAntigo = this.portalParametroService.getPortalParametroValor(parametroContabil.getId().getEntidade(), parametroContabil.getId().getExercicio(), parametroContabil.getIdParametro())))) {
            this.arquivoService.remove(Long.valueOf(Long.parseLong(idArquivoAntigo)));
        }
        this.portalParametroService.save(parametroContabil);
    }

    @PostMapping(value={"/arquivos/{entidade}/{exercicio}/{id}"})
    public ResponseEntity<ArquivoContab> saveArquivo(@RequestParam(value="file") MultipartFile file, @RequestParam(value="nome") String nome, @PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long id) throws URISyntaxException, IOException {
        if (file.isEmpty()) {
            return ResponseEntity.noContent().build();
        }
        try {
            this.removerArquivo(entidade, exercicio, id);
            ArquivoContab arquivoContab = this.arquivoService.salvarArquivo(file, nome);
            return ResponseEntity.created((URI)new URI("")).body((Object)this.arquivoService.save(arquivoContab));
        }
        catch (IOException | InvalidPathException e) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
    }

    private void removerArquivo(Long entidade, Long exercicio, Long id) {
        String valor = this.portalParametroService.getPortalParametroValor(entidade, exercicio, id);
        if (Objects.nonNull(valor)) {
            this.arquivoService.remove(Long.valueOf(Long.parseLong(valor)));
        }
    }

    @GetMapping(value={"/{entidade}/{exercicio}/{id}"})
    public ResponseEntity<PortalParametroContabil> getParametro(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long id) {
        PortalParametroContabil parametroFound = this.portalParametroService.getPortalParametro(entidade, exercicio, id);
        if (Objects.isNull(parametroFound)) {
            PortalParametroContabil novoParametro = new PortalParametroContabil();
            novoParametro.setId(new PortalParametroPK(entidade, exercicio, id));
            return ResponseEntity.ok((Object)novoParametro);
        }
        return ResponseEntity.ok((Object)parametroFound);
    }

    @GetMapping(value={"/manual-ajuda"})
    public ResponseEntity<ArquivoInterface> getManualAjuda() {
        ArquivoInterface arquivoManualAjuda = this.portalParametroService.getArquivoAjuda();
        if (Objects.nonNull(arquivoManualAjuda)) {
            return ResponseEntity.ok((Object)arquivoManualAjuda);
        }
        return ResponseEntity.noContent().build();
    }
}

